/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.spark.launcher.AbstractCommandBuilder;
import org.apache.spark.launcher.CommandBuilderUtils;

class SparkClassCommandBuilder
extends AbstractCommandBuilder {
    private final String className;
    private final List<String> classArgs;

    SparkClassCommandBuilder(String className, List<String> classArgs) {
        this.className = className;
        this.classArgs = classArgs;
    }

    @Override
    public List<String> buildCommand(Map<String, String> env) throws IOException, IllegalArgumentException {
        ArrayList<String> javaOptsKeys = new ArrayList<String>();
        String memKey = null;
        String extraClassPath = null;
        switch (this.className) {
            case "org.apache.spark.deploy.master.Master": {
                javaOptsKeys.add("SPARK_DAEMON_JAVA_OPTS");
                javaOptsKeys.add("SPARK_MASTER_OPTS");
                extraClassPath = this.getenv("SPARK_DAEMON_CLASSPATH");
                memKey = "SPARK_DAEMON_MEMORY";
                break;
            }
            case "org.apache.spark.deploy.worker.Worker": {
                javaOptsKeys.add("SPARK_DAEMON_JAVA_OPTS");
                javaOptsKeys.add("SPARK_WORKER_OPTS");
                extraClassPath = this.getenv("SPARK_DAEMON_CLASSPATH");
                memKey = "SPARK_DAEMON_MEMORY";
                break;
            }
            case "org.apache.spark.deploy.history.HistoryServer": {
                javaOptsKeys.add("SPARK_DAEMON_JAVA_OPTS");
                javaOptsKeys.add("SPARK_HISTORY_OPTS");
                extraClassPath = this.getenv("SPARK_DAEMON_CLASSPATH");
                memKey = "SPARK_DAEMON_MEMORY";
                break;
            }
            case "org.apache.spark.executor.CoarseGrainedExecutorBackend": {
                javaOptsKeys.add("SPARK_EXECUTOR_OPTS");
                memKey = "SPARK_EXECUTOR_MEMORY";
                extraClassPath = this.getenv("SPARK_EXECUTOR_CLASSPATH");
                break;
            }
            case "org.apache.spark.executor.MesosExecutorBackend": {
                javaOptsKeys.add("SPARK_EXECUTOR_OPTS");
                memKey = "SPARK_EXECUTOR_MEMORY";
                extraClassPath = this.getenv("SPARK_EXECUTOR_CLASSPATH");
                break;
            }
            case "org.apache.spark.deploy.mesos.MesosClusterDispatcher": {
                javaOptsKeys.add("SPARK_DAEMON_JAVA_OPTS");
                extraClassPath = this.getenv("SPARK_DAEMON_CLASSPATH");
                memKey = "SPARK_DAEMON_MEMORY";
                break;
            }
            case "org.apache.spark.deploy.ExternalShuffleService": 
            case "org.apache.spark.deploy.mesos.MesosExternalShuffleService": {
                javaOptsKeys.add("SPARK_DAEMON_JAVA_OPTS");
                javaOptsKeys.add("SPARK_SHUFFLE_OPTS");
                extraClassPath = this.getenv("SPARK_DAEMON_CLASSPATH");
                memKey = "SPARK_DAEMON_MEMORY";
                break;
            }
            case "org.apache.hive.beeline.BeeLine": {
                javaOptsKeys.add("SPARK_BEELINE_OPTS");
                memKey = "SPARK_BEELINE_MEMORY";
                break;
            }
            default: {
                memKey = "SPARK_DRIVER_MEMORY";
            }
        }
        List<String> cmd = this.buildJavaCommand(extraClassPath);
        for (String key : javaOptsKeys) {
            String envValue = System.getenv(key);
            if (!CommandBuilderUtils.isEmpty(envValue) && envValue.contains("Xmx")) {
                String msg = String.format("%s is not allowed to specify max heap(Xmx) memory settings (was %s). Use the corresponding configuration instead.", key, envValue);
                throw new IllegalArgumentException(msg);
            }
            this.addOptionString(cmd, envValue);
        }
        String mem = CommandBuilderUtils.firstNonEmpty(memKey != null ? System.getenv(memKey) : null, "1g");
        cmd.add("-Xmx" + mem);
        cmd.add(this.className);
        cmd.addAll(this.classArgs);
        return cmd;
    }
}

