/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumnVector;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil;
import org.apache.spark.sql.execution.datasources.parquet.SpecificParquetRecordReaderBase;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedColumnReader;
import org.apache.spark.sql.execution.vectorized.ColumnVectorUtils;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.sparkproject.guava.annotations.VisibleForTesting;
import scala.Option;
import scala.jdk.javaapi.CollectionConverters;

public class VectorizedParquetRecordReader
extends SpecificParquetRecordReaderBase<Object> {
    private int capacity;
    private int batchIdx = 0;
    private int numBatched = 0;
    private ParquetColumnVector[] columnVectors;
    private long rowsReturned;
    private long totalCountLoadedSoFar = 0L;
    private Set<ParquetColumn> missingColumns;
    private final ZoneId convertTz;
    private final String datetimeRebaseMode;
    private final String datetimeRebaseTz;
    private final String int96RebaseMode;
    private final String int96RebaseTz;
    private ColumnarBatch columnarBatch;
    private boolean returnColumnarBatch;
    private ParquetRowIndexUtil.RowIndexGenerator rowIndexGenerator = null;
    private final MemoryMode MEMORY_MODE;

    public VectorizedParquetRecordReader(ZoneId convertTz, String datetimeRebaseMode, String datetimeRebaseTz, String int96RebaseMode, String int96RebaseTz, boolean useOffHeap, int capacity) {
        this.convertTz = convertTz;
        this.datetimeRebaseMode = datetimeRebaseMode;
        this.datetimeRebaseTz = datetimeRebaseTz;
        this.int96RebaseMode = int96RebaseMode;
        this.int96RebaseTz = int96RebaseTz;
        this.MEMORY_MODE = useOffHeap ? MemoryMode.OFF_HEAP : MemoryMode.ON_HEAP;
        this.capacity = capacity;
    }

    public VectorizedParquetRecordReader(boolean useOffHeap, int capacity) {
        this(null, "CORRECTED", "UTC", "LEGACY", ZoneId.systemDefault().getId(), useOffHeap, capacity);
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException, UnsupportedOperationException {
        super.initialize(inputSplit, taskAttemptContext);
        this.initializeInternal();
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext, Option<HadoopInputFile> inputFile, Option<SeekableInputStream> inputStream, Option<ParquetMetadata> fileFooter) throws IOException, InterruptedException, UnsupportedOperationException {
        super.initialize(inputSplit, taskAttemptContext, inputFile, inputStream, fileFooter);
        this.initializeInternal();
    }

    @Override
    public void initialize(String path, List<String> columns) throws IOException, UnsupportedOperationException {
        super.initialize(path, columns);
        this.initializeInternal();
    }

    @Override
    @VisibleForTesting
    public void initialize(MessageType fileSchema, MessageType requestedSchema, SpecificParquetRecordReaderBase.ParquetRowGroupReader rowGroupReader, int totalRowCount) throws IOException {
        super.initialize(fileSchema, requestedSchema, rowGroupReader, totalRowCount);
        this.initializeInternal();
    }

    @Override
    public void close() throws IOException {
        if (this.columnarBatch != null) {
            this.columnarBatch.close();
            this.columnarBatch = null;
        }
        super.close();
    }

    public boolean nextKeyValue() throws IOException {
        this.resultBatch();
        if (this.returnColumnarBatch) {
            return this.nextBatch();
        }
        if (this.batchIdx >= this.numBatched && !this.nextBatch()) {
            return false;
        }
        ++this.batchIdx;
        return true;
    }

    public Object getCurrentValue() {
        if (this.returnColumnarBatch) {
            return this.columnarBatch;
        }
        return this.columnarBatch.getRow(this.batchIdx - 1);
    }

    public float getProgress() {
        return (float)this.rowsReturned / (float)this.totalRowCount;
    }

    private void initBatch(MemoryMode memMode, StructType partitionColumns, InternalRow partitionValues) {
        StructType batchSchema = new StructType(this.sparkSchema.fields());
        int constantColumnLength = 0;
        if (partitionColumns != null) {
            for (StructField f : partitionColumns.fields()) {
                batchSchema = batchSchema.add(f);
            }
            constantColumnLength = partitionColumns.fields().length;
        }
        ColumnVector[] vectors = this.allocateColumns(this.capacity, batchSchema, memMode == MemoryMode.OFF_HEAP, constantColumnLength);
        this.columnarBatch = new ColumnarBatch(vectors);
        this.columnVectors = new ParquetColumnVector[this.sparkSchema.fields().length];
        for (int i = 0; i < this.columnVectors.length; ++i) {
            Object defaultValue = null;
            if (this.sparkRequestedSchema != null) {
                defaultValue = ResolveDefaultColumns.existenceDefaultValues((StructType)this.sparkRequestedSchema)[i];
            }
            this.columnVectors[i] = new ParquetColumnVector((ParquetColumn)this.parquetColumn.children().apply(i), (WritableColumnVector)vectors[i], this.capacity, memMode, this.missingColumns, true, defaultValue);
        }
        if (partitionColumns != null) {
            int partitionIdx = this.sparkSchema.fields().length;
            for (int i = 0; i < partitionColumns.fields().length; ++i) {
                ColumnVectorUtils.populate((ConstantColumnVector)vectors[i + partitionIdx], partitionValues, i);
            }
        }
        this.rowIndexGenerator = ParquetRowIndexUtil.createGeneratorIfNeeded(this.sparkSchema);
    }

    private void initBatch() {
        this.initBatch(this.MEMORY_MODE, null, null);
    }

    public void initBatch(StructType partitionColumns, InternalRow partitionValues) {
        this.initBatch(this.MEMORY_MODE, partitionColumns, partitionValues);
    }

    public ColumnarBatch resultBatch() {
        if (this.columnarBatch == null) {
            this.initBatch();
        }
        return this.columnarBatch;
    }

    public void enableReturningBatches() {
        this.returnColumnarBatch = true;
    }

    public boolean nextBatch() throws IOException {
        for (ParquetColumnVector vector : this.columnVectors) {
            vector.reset();
        }
        this.columnarBatch.setNumRows(0);
        if (this.rowsReturned >= this.totalRowCount) {
            return false;
        }
        this.checkEndOfRowGroup();
        int num = (int)Math.min((long)this.capacity, this.totalCountLoadedSoFar - this.rowsReturned);
        for (ParquetColumnVector cv : this.columnVectors) {
            for (ParquetColumnVector leafCv : cv.getLeaves()) {
                VectorizedColumnReader columnReader = leafCv.getColumnReader();
                if (columnReader == null) continue;
                columnReader.readBatch(num, leafCv.getValueVector(), leafCv.getRepetitionLevelVector(), leafCv.getDefinitionLevelVector());
            }
            cv.assemble();
        }
        if (this.rowIndexGenerator != null) {
            this.rowIndexGenerator.populateRowIndex(this.columnVectors, num);
        }
        this.rowsReturned += (long)num;
        this.columnarBatch.setNumRows(num);
        this.numBatched = num;
        this.batchIdx = 0;
        return true;
    }

    private void initializeInternal() throws IOException, UnsupportedOperationException {
        this.missingColumns = new HashSet<ParquetColumn>();
        for (ParquetColumn column : CollectionConverters.asJava(this.parquetColumn.children())) {
            this.checkColumn(column);
        }
    }

    private void checkColumn(ParquetColumn column) throws IOException {
        Object[] path = CollectionConverters.asJava(column.path()).toArray(new String[0]);
        if (this.containsPath((Type)this.fileSchema, (String[])path)) {
            if (column.isPrimitive()) {
                ColumnDescriptor desc = (ColumnDescriptor)column.descriptor().get();
                ColumnDescriptor fd = this.fileSchema.getColumnDescription(desc.getPath());
                if (!fd.equals((Object)desc)) {
                    throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3185");
                }
            } else {
                for (ParquetColumn childColumn : CollectionConverters.asJava(column.children())) {
                    this.checkColumn(childColumn);
                }
            }
        } else {
            if (column.required()) {
                throw new IOException("Required column is missing in data file. Col: " + Arrays.toString(path));
            }
            this.missingColumns.add(column);
        }
    }

    private boolean containsPath(Type parquetType, String[] path) {
        return this.containsPath(parquetType, path, 0);
    }

    private boolean containsPath(Type parquetType, String[] path, int depth) {
        String fieldName;
        GroupType parquetGroupType;
        if (path.length == depth) {
            return true;
        }
        if (parquetType instanceof GroupType && (parquetGroupType = (GroupType)parquetType).containsField(fieldName = path[depth])) {
            return this.containsPath(parquetGroupType.getType(fieldName), path, depth + 1);
        }
        return false;
    }

    private void checkEndOfRowGroup() throws IOException {
        if (this.rowsReturned != this.totalCountLoadedSoFar) {
            return;
        }
        PageReadStore pages = this.reader.readNextRowGroup();
        if (pages == null) {
            throw new IOException("expecting more rows but reached last block. Read " + this.rowsReturned + " out of " + this.totalRowCount);
        }
        if (this.rowIndexGenerator != null) {
            this.rowIndexGenerator.initFromPageReadStore(pages);
        }
        for (ParquetColumnVector cv : this.columnVectors) {
            this.initColumnReader(pages, cv);
        }
        this.totalCountLoadedSoFar += pages.getRowCount();
    }

    private void initColumnReader(PageReadStore pages, ParquetColumnVector cv) throws IOException {
        if (!this.missingColumns.contains(cv.getColumn())) {
            if (cv.getColumn().isPrimitive()) {
                ParquetColumn column = cv.getColumn();
                VectorizedColumnReader reader = new VectorizedColumnReader((ColumnDescriptor)column.descriptor().get(), column.required(), pages, this.convertTz, this.datetimeRebaseMode, this.datetimeRebaseTz, this.int96RebaseMode, this.int96RebaseTz, this.writerVersion);
                cv.setColumnReader(reader);
            } else {
                for (ParquetColumnVector childCv : cv.getChildren()) {
                    this.initColumnReader(pages, childCv);
                }
            }
        }
    }

    private ColumnVector[] allocateColumns(int capacity, StructType schema, boolean useOffHeap, int constantColumnLength) {
        int i;
        StructField[] fields = schema.fields();
        int fieldsLength = fields.length;
        ColumnVector[] vectors = new ColumnVector[fieldsLength];
        if (useOffHeap) {
            for (i = 0; i < fieldsLength - constantColumnLength; ++i) {
                vectors[i] = new OffHeapColumnVector(capacity, fields[i].dataType());
            }
        } else {
            for (i = 0; i < fieldsLength - constantColumnLength; ++i) {
                vectors[i] = new OnHeapColumnVector(capacity, fields[i].dataType());
            }
        }
        for (i = fieldsLength - constantColumnLength; i < fieldsLength; ++i) {
            vectors[i] = new ConstantColumnVector(capacity, fields[i].dataType());
        }
        return vectors;
    }
}

