/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FormatNumber$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr1, expr2) - Formats the number `expr1` like '#,###,###.##', rounded to `expr2`\n      decimal places. If `expr2` is 0, the result has no decimal point or fractional part.\n      `expr2` also accept a user specified format.\n      This is supposed to function like MySQL's FORMAT.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(12332.123456, 4);\n       12,332.1235\n      > SELECT _FUNC_(12332.123456, '##################.###');\n       12332.123\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\tuc\u0001B\u0016-\u0001fB\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t7\u0002\u0011\t\u0012)A\u00051\"AA\f\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003Y\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015\u0019\u0007\u0001\"\u0011X\u0011\u0015!\u0007\u0001\"\u0011X\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015Q\u0007\u0001\"\u0011g\u0011\u0015Y\u0007\u0001\"\u0011g\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u001d9\bA1A\u0005\naDq!a\u0001\u0001A\u0003%\u0011\u0010C\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0003\u0002\b!I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\t\u0003G\u0001\u0001\u0015)\u0003\u0002\n!I\u0011Q\u0006\u0001A\u0002\u0013%\u0011q\u0006\u0005\n\u0003\u0003\u0002\u0001\u0019!C\u0005\u0003\u0007B\u0001\"a\u0012\u0001A\u0003&\u0011\u0011\u0007\u0005\u000b\u0003\u0017\u0002\u0001R1A\u0005\n\u00055\u0003BCA,\u0001!\u0015\r\u0011\"\u0003\u0002Z!9\u0011\u0011\u000e\u0001\u0005R\u0005-\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u00033\u0003A\u0011IAN\u0011\u001d\ti\n\u0001C)\u0003?C\u0011\"!+\u0001\u0003\u0003%\t!a+\t\u0013\u0005E\u0006!%A\u0005\u0002\u0005M\u0006\"CAe\u0001E\u0005I\u0011AAZ\u0011!\tY\rAA\u0001\n\u0003B\b\"CAg\u0001\u0005\u0005I\u0011AAh\u0011%\t\t\u000eAA\u0001\n\u0003\t\u0019\u000eC\u0005\u0002X\u0002\t\t\u0011\"\u0011\u0002Z\"I\u0011q\u001d\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0003[\u0004\u0011\u0011!C!\u0003_D\u0011\"a=\u0001\u0003\u0003%\t%!>\b\u0013\teA&!A\t\u0002\tma\u0001C\u0016-\u0003\u0003E\tA!\b\t\ry+C\u0011\u0001B\u001b\u0011%\u00119$JA\u0001\n\u000b\u0012I\u0004C\u0005\u0003<\u0015\n\t\u0011\"!\u0003>!I!1I\u0013\u0002\u0002\u0013\u0005%Q\t\u0005\n\u0005'*\u0013\u0011!C\u0005\u0005+\u0012ABR8s[\u0006$h*^7cKJT!!\f\u0018\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003_A\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003cI\n1a]9m\u0015\t\u0019D'A\u0003ta\u0006\u00148N\u0003\u00026m\u00051\u0011\r]1dQ\u0016T\u0011aN\u0001\u0004_J<7\u0001A\n\u0007\u0001ir\u0014\t\u0012&\u0011\u0005mbT\"\u0001\u0017\n\u0005ub#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tYt(\u0003\u0002AY\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005m\u0012\u0015BA\"-\u0005\u0001\"UMZ1vYR\u001cFO]5oOB\u0013x\u000eZ;dS:<W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\u000fA\u0013x\u000eZ;diB\u00111j\u0015\b\u0003\u0019Fs!!\u0014)\u000e\u00039S!a\u0014\u001d\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0015B\u0001*G\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005I3\u0015!\u0001=\u0016\u0003a\u0003\"aO-\n\u0005ic#AC#yaJ,7o]5p]\u0006\u0011\u0001\u0010I\u0001\u0002I\u0006\u0011A\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0001\f'\r\u0005\u0002<\u0001!)a+\u0002a\u00011\")A,\u0002a\u00011\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u0003!qW\u000f\u001c7bE2,W#A4\u0011\u0005\u0015C\u0017BA5G\u0005\u001d\u0011un\u001c7fC:\faB\\;mY&sGo\u001c7fe\u0006tG/\u0001\u000ed_:$X\r\u001f;J]\u0012,\u0007/\u001a8eK:$hi\u001c7eC\ndW-\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u001c\t\u0004\u0017>\f\u0018B\u00019V\u0005\r\u0019V-\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003iB\nQ\u0001^=qKNL!A^:\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017!\u00043fM\u0006,H\u000e\u001e$pe6\fG/F\u0001z!\tQx0D\u0001|\u0015\taX0\u0001\u0003mC:<'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003Y(AB*ue&tw-\u0001\beK\u001a\fW\u000f\u001c;G_Jl\u0017\r\u001e\u0011\u0002\u001b1\f7\u000f\u001e#J]R4\u0016\r\\;f+\t\tI\u0001E\u0003F\u0003\u0017\ty!C\u0002\u0002\u000e\u0019\u0013aa\u00149uS>t\u0007cA#\u0002\u0012%\u0019\u00111\u0003$\u0003\u0007%sG/A\tmCN$H)\u00138u-\u0006dW/Z0%KF$B!!\u0007\u0002 A\u0019Q)a\u0007\n\u0007\u0005uaI\u0001\u0003V]&$\b\"CA\u0011\u001f\u0005\u0005\t\u0019AA\u0005\u0003\rAH%M\u0001\u000fY\u0006\u001cH\u000fR%oiZ\u000bG.^3!Q\r\u0001\u0012q\u0005\t\u0004\u000b\u0006%\u0012bAA\u0016\r\nIAO]1og&,g\u000e^\u0001\u0011Y\u0006\u001cH\u000fR*ue&twMV1mk\u0016,\"!!\r\u0011\u000b\u0015\u000bY!a\r\u0011\t\u0005U\u0012Q\b\b\u0005\u0003o\tI\u0004\u0005\u0002N\r&\u0019\u00111\b$\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t!a\u0010\u000b\u0007\u0005mb)\u0001\u000bmCN$Hi\u0015;sS:<g+\u00197vK~#S-\u001d\u000b\u0005\u00033\t)\u0005C\u0005\u0002\"I\t\t\u00111\u0001\u00022\u0005\tB.Y:u\tN#(/\u001b8h-\u0006dW/\u001a\u0011)\u0007M\t9#A\u0004qCR$XM\u001d8\u0016\u0005\u0005=\u0003c\u0001>\u0002R%\u0019\u00111K>\u0003\u0019M#(/\u001b8h\u0005V4g-\u001a:)\u0007Q\t9#\u0001\u0007ok6\u0014WM\u001d$pe6\fG/\u0006\u0002\u0002\\A!\u0011QLA2\u001b\t\tyFC\u0002\u0002bu\fA\u0001^3yi&!\u0011QMA0\u00055!UmY5nC24uN]7bi\"\u001aQ#a\n\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\r\u00055\u00141OA<!\r)\u0015qN\u0005\u0004\u0003c2%aA!os\"9\u0011Q\u000f\fA\u0002\u00055\u0014a\u0002=PE*,7\r\u001e\u0005\b\u0003s2\u0002\u0019AA7\u0003\u001d!wJ\u00196fGR\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005}\u00141RAK!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAACY\u000591m\u001c3fO\u0016t\u0017\u0002BAE\u0003\u0007\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u001b;\u0002\u0019AAH\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0003\u000b\t*\u0003\u0003\u0002\u0014\u0006\r%AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003/;\u0002\u0019AA@\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\r\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u00021\u0002\"\u0006\u0015\u0006BBAR3\u0001\u0007\u0001,A\u0004oK^dUM\u001a;\t\r\u0005\u001d\u0016\u00041\u0001Y\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$R\u0001YAW\u0003_CqA\u0016\u000e\u0011\u0002\u0003\u0007\u0001\fC\u0004]5A\u0005\t\u0019\u0001-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0017\u0016\u00041\u0006]6FAA]!\u0011\tY,!2\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rg)\u0001\u0006b]:|G/\u0019;j_:LA!a2\u0002>\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0004\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QNAk\u0011%\t\tcHA\u0001\u0002\u0004\ty!A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u000e\u0005\u0004\u0002^\u0006\r\u0018QN\u0007\u0003\u0003?T1!!9G\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\fyN\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA4\u0002l\"I\u0011\u0011E\u0011\u0002\u0002\u0003\u0007\u0011QN\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\rF\u0002z\u0003cD\u0011\"!\t#\u0003\u0003\u0005\r!a\u0004\u0002\r\u0015\fX/\u00197t)\r9\u0017q\u001f\u0005\n\u0003C\u0019\u0013\u0011!a\u0001\u0003[B3\u0003AA~\u0005\u0003\u0011\u0019Aa\u0002\u0003\n\t5!q\u0002B\n\u0005+\u00012aOA\u007f\u0013\r\ty\u0010\f\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011)!\u0001B(\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJ\fD\u0006I3yaJ\u0014\u0014\u0006I\u0017!\r>\u0014X.\u0019;tAQDW\r\t8v[\n,'\u000f\t1fqB\u0014\u0018\u0007\u0019\u0011mS.,\u0007eJ\u0012-G\r\u001aCfI\u0012$]\r\u001as\u0005\f\u0011s_VtG-\u001a3!i>\u0004\u0003-\u001a=qeJ\u0002'\u0002\t\u0011!A\u0001\u0002C-Z2j[\u0006d\u0007\u0005\u001d7bG\u0016\u001ch\u0006I%gA\u0001,\u0007\u0010\u001d:3A\u0002J7\u000f\t\u0019-AQDW\r\t:fgVdG\u000f\t5bg\u0002rw\u000e\t3fG&l\u0017\r\u001c\u0011q_&tG\u000fI8sA\u0019\u0014\u0018m\u0019;j_:\fG\u000e\t9beRt#\u0002\t\u0011!A\u0001\u0002\u0003-\u001a=qeJ\u0002\u0007%\u00197t_\u0002\n7mY3qi\u0002\n\u0007%^:fe\u0002\u001a\b/Z2jM&,G\r\t4pe6\fGO\f\u0006!A\u0001\u0002\u0003\u0005\t+iSN\u0004\u0013n\u001d\u0011tkB\u0004xn]3eAQ|\u0007EZ;oGRLwN\u001c\u0011mS.,\u0007%T=T#2;3\u000f\t$P%6\u000bEK\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003\f\u0005\tID\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152eM\u001a$GL\u00193gQ*d\u0007\f\u00115SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\r\u00174gIr\u0013GM\u001a6\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n$gM\u001a3]E\u00124\u0007N\u001b7Y\u0001:3eI\u0012$G\r\u001a3eI\u0012$G\r\u001a3eI\u0012$]\r\u001a3eJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u00124g\r\u001a/cI\u001a$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\tE\u0011!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018E\u0001B\f\u00031\u0019HO]5oO~3WO\\2t\u000311uN]7bi:+XNY3s!\tYTeE\u0003&\u0005?\u0011Y\u0003E\u0004\u0003\"\t\u001d\u0002\f\u00171\u000e\u0005\t\r\"b\u0001B\u0013\r\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u0015\u0005G\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u0011iCa\r\u000e\u0005\t=\"b\u0001B\u0019{\u0006\u0011\u0011n\\\u0005\u0004)\n=BC\u0001B\u000e\u0003!!xn\u0015;sS:<G#A=\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0001\u0014yD!\u0011\t\u000bYC\u0003\u0019\u0001-\t\u000bqC\u0003\u0019\u0001-\u0002\u000fUt\u0017\r\u001d9msR!!q\tB(!\u0015)\u00151\u0002B%!\u0015)%1\n-Y\u0013\r\u0011iE\u0012\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\tE\u0013&!AA\u0002\u0001\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u00119\u0006E\u0002{\u00053J1Aa\u0017|\u0005\u0019y%M[3di\u0002")
public class FormatNumber
extends BinaryExpression
implements ExpectsInputTypes,
DefaultStringProducingExpression,
Serializable {
    private transient StringBuffer pattern;
    private transient DecimalFormat numberFormat;
    private final Expression x;
    private final Expression d;
    private final String defaultFormat;
    private transient Option<Object> lastDIntValue;
    private transient Option<String> lastDStringValue;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(FormatNumber x$0) {
        return FormatNumber$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, FormatNumber> tupled() {
        return FormatNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FormatNumber>> curried() {
        return FormatNumber$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression x() {
        return this.x;
    }

    public Expression d() {
        return this.d;
    }

    @Override
    public Expression left() {
        return this.x();
    }

    @Override
    public Expression right() {
        return this.d();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public boolean contextIndependentFoldable() {
        return super.contextIndependentFoldable();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)NumericType$.MODULE$, (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())})), (List)Nil$.MODULE$));
    }

    private String defaultFormat() {
        return this.defaultFormat;
    }

    private Option<Object> lastDIntValue() {
        return this.lastDIntValue;
    }

    private void lastDIntValue_$eq(Option<Object> x$1) {
        this.lastDIntValue = x$1;
    }

    private Option<String> lastDStringValue() {
        return this.lastDStringValue;
    }

    private void lastDStringValue_$eq(Option<String> x$1) {
        this.lastDStringValue = x$1;
    }

    private StringBuffer pattern$lzycompute() {
        FormatNumber formatNumber = this;
        synchronized (formatNumber) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.pattern = new StringBuffer();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.pattern;
    }

    private StringBuffer pattern() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.pattern$lzycompute();
        }
        return this.pattern;
    }

    private DecimalFormat numberFormat$lzycompute() {
        FormatNumber formatNumber = this;
        synchronized (formatNumber) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numberFormat = new DecimalFormat("", new DecimalFormatSymbols(Locale.US));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.numberFormat;
    }

    private DecimalFormat numberFormat() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.numberFormat$lzycompute();
        }
        return this.numberFormat;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object nullSafeEval(Object xObject, Object dObject) {
        block17: {
            block18: {
                block16: {
                    var7_3 = this.right().dataType();
                    if (!IntegerType$.MODULE$.equals(var7_3)) break block16;
                    dValue = BoxesRunTime.unboxToInt((Object)dObject);
                    if (dValue < 0) {
                        return null;
                    }
                    var9_5 = this.lastDIntValue();
                    if (var9_5 instanceof Some && (last = BoxesRunTime.unboxToInt((Object)(var10_6 = (Some)var9_5).value())) == dValue) {
                    } else {
                        this.pattern().delete(0, this.pattern().length());
                        this.pattern().append(this.defaultFormat());
                        if (dValue > 0) {
                            this.pattern().append(".");
                            for (i = 0; i < dValue; ++i) {
                                this.pattern().append("0");
                            }
                        }
                        this.lastDIntValue_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)dValue)));
                        this.numberFormat().applyLocalizedPattern(this.pattern().toString());
                    }
                    break block17;
                }
                if (!(var7_3 instanceof StringType)) break block18;
                dValue = ((UTF8String)dObject).toString();
                var14_10 = this.lastDStringValue();
                if (!(var14_10 instanceof Some)) ** GOTO lbl-1000
                var15_11 = (Some)var14_10;
                v0 = last = (String)var15_11.value();
                var17_13 = dValue;
                if (!(v0 != null ? v0.equals(var17_13) == false : var17_13 != null)) {
                } else lbl-1000:
                // 2 sources

                {
                    this.pattern().delete(0, this.pattern().length());
                    this.lastDStringValue_$eq((Option<String>)new Some((Object)dValue));
                    if (dValue.isEmpty()) {
                        this.numberFormat().applyLocalizedPattern(this.defaultFormat());
                    } else {
                        this.numberFormat().applyLocalizedPattern(dValue);
                    }
                }
                break block17;
            }
            throw new MatchError((Object)var7_3);
        }
        var18_14 = this.x().dataType();
        if (ByteType$.MODULE$.equals(var18_14)) {
            return UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToByte((Object)xObject)));
        }
        if (ShortType$.MODULE$.equals(var18_14)) {
            return UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToShort((Object)xObject)));
        }
        if (FloatType$.MODULE$.equals(var18_14)) {
            return UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToFloat((Object)xObject)));
        }
        if (IntegerType$.MODULE$.equals(var18_14)) {
            return UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToInt((Object)xObject)));
        }
        if (LongType$.MODULE$.equals(var18_14)) {
            return UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToLong((Object)xObject)));
        }
        if (DoubleType$.MODULE$.equals(var18_14)) {
            return UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToDouble((Object)xObject)));
        }
        if (var18_14 instanceof DecimalType) {
            return UTF8String.fromString((String)this.numberFormat().format(((Decimal)xObject).toJavaBigDecimal()));
        }
        throw new MatchError((Object)var18_14);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(num, d) -> {
            String sb = StringBuffer.class.getName();
            String df = DecimalFormat.class.getName();
            String dfs = DecimalFormatSymbols.class.getName();
            String l = Locale.class.getName();
            String usLocale = "US";
            String numberFormat = ctx.addMutableState(df, "numberFormat", (Function1<String, String>)(Function1 & Serializable)v -> v + " = new " + df + "(\"\", new " + dfs + "(" + l + "." + usLocale + "));", ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
            DataType dataType = this.right().dataType();
            if (IntegerType$.MODULE$.equals(dataType)) {
                String pattern = ctx.addMutableState(sb, "pattern", (Function1<String, String>)(Function1 & Serializable)v -> v + " = new " + sb + "();", ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String i = ctx.freshName("i");
                String lastDValue = ctx.addMutableState("int", "lastDValue", (Function1<String, String>)(Function1 & Serializable)v -> v + " = -100;", ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                return "\n            if (" + d + " >= 0) {\n              " + pattern + ".delete(0, " + pattern + ".length());\n              if (" + d + " != " + lastDValue + ") {\n                " + pattern + ".append(\"" + this.defaultFormat() + "\");\n\n                if (" + d + " > 0) {\n                  " + pattern + ".append(\".\");\n                  for (int " + i + " = 0; " + i + " < " + d + "; " + i + "++) {\n                    " + pattern + ".append(\"0\");\n                  }\n                }\n                " + lastDValue + " = " + d + ";\n                " + numberFormat + ".applyLocalizedPattern(" + pattern + ".toString());\n              }\n              " + ev.value() + " = UTF8String.fromString(" + numberFormat + ".format(" + this.typeHelper$1((String)num) + "));\n            } else {\n              " + ev.value() + " = null;\n              " + ev.isNull() + " = true;\n            }\n           ";
            }
            if (dataType instanceof StringType) {
                String lastDValue = ctx.addMutableState("String", "lastDValue", (Function1<String, String>)(Function1 & Serializable)v -> v + " = null;", ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String dValue = ctx.freshName("dValue");
                return "\n            String " + dValue + " = " + d + ".toString();\n            if (!" + dValue + ".equals(" + lastDValue + ")) {\n              " + lastDValue + " = " + dValue + ";\n              if (" + dValue + ".isEmpty()) {\n                " + numberFormat + ".applyLocalizedPattern(\"" + this.defaultFormat() + "\");\n              } else {\n                " + numberFormat + ".applyLocalizedPattern(" + dValue + ");\n              }\n            }\n            " + ev.value() + " = UTF8String.fromString(" + numberFormat + ".format(" + this.typeHelper$1((String)num) + "));\n           ";
            }
            throw new MatchError((Object)dataType);
        });
    }

    @Override
    public String prettyName() {
        return "format_number";
    }

    @Override
    public FormatNumber withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public FormatNumber copy(Expression x, Expression d) {
        return new FormatNumber(x, d);
    }

    public Expression copy$default$1() {
        return this.x();
    }

    public Expression copy$default$2() {
        return this.d();
    }

    @Override
    public String productPrefix() {
        return "FormatNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.x();
            }
            case 1: {
                return this.d();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FormatNumber;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "x";
            }
            case 1: {
                return "d";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FormatNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        FormatNumber formatNumber = (FormatNumber)x$1;
        Expression expression = this.x();
        Expression expression2 = formatNumber.x();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.d();
        Expression expression4 = formatNumber.d();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!formatNumber.canEqual(this)) return false;
        return true;
    }

    private final String typeHelper$1(String p) {
        DataType dataType = this.x().dataType();
        if (dataType instanceof DecimalType) {
            return p + ".toJavaBigDecimal()";
        }
        return String.valueOf(p);
    }

    public FormatNumber(Expression x, Expression d) {
        this.x = x;
        this.d = d;
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        this.defaultFormat = "#,###,###,###,###,###,##0";
        this.lastDIntValue = None$.MODULE$;
        this.lastDStringValue = None$.MODULE$;
    }
}

