/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasVarianceCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel$;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$NodeData$;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.DecisionTreeRegressorParams;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.Node$;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t%e\u0001\u0002\u0014(\u0001IB\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0005\u0018\u0005\tK\u0002\u0011\t\u0011)A\u0005;\"Aa\r\u0001BC\u0002\u0013\u0005s\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003i\u0011!a\u0007A!b\u0001\n\u0003j\u0007\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011\u00028\t\rM\u0004A\u0011A\u0015u\u0011\u0015A\b\u0001\"\u0001z\u0011\u0019\u0019\b\u0001\"\u0001*{\"91\u000f\u0001C\u0001S\u0005\u0005\u0001bBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\tY\u0002\u0001C\t\u0003;Aq!!\t\u0001\t\u0003\n\u0019\u0003C\u0004\u0002L\u0001!\t%!\u0014\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"9\u00111\u0016\u0001\u0005B\u00055\u0006BCAY\u0001!\u0015\r\u0011\"\u0001\u00024\"A\u0011q\u0017\u0001\u0005B-\nI\fC\u0004\u0002L\u0002!\t%!4\b\u000f\u0005ew\u0005#\u0001\u0002\\\u001a1ae\nE\u0001\u0003;Daa\u001d\f\u0005\u0002\u0005e\bbBA~-\u0011\u0005\u0013Q \u0005\b\u0005\u000f1B\u0011\tB\u0005\r\u001d\u0011\tB\u0006\u0001\u0017\u0005'A\u0011B!\u0006\u001b\u0005\u0003\u0005\u000b\u0011B\u001f\t\rMTB\u0011\u0001B\f\u0011\u001d\u0011yB\u0007C)\u0005C1aAa\u000b\u0017\t\t5\u0002BB:\u001f\t\u0003\u0011y\u0003C\u0005\u00034y\u0011\r\u0011\"\u0003\u00036!A!\u0011\t\u0010!\u0002\u0013\u00119\u0004C\u0004\u0003\by!\tEa\u0011\t\u0011\t\u001dc\u0003\"\u0001*\u0005\u0013B!B!\u001a\u0017#\u0003%\t!\u000bB4\u0011%\u0011YHFA\u0001\n\u0013\u0011iHA\u000eEK\u000eL7/[8o)J,WMU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u0006\u0003Q%\n!B]3he\u0016\u001c8/[8o\u0015\tQ3&\u0001\u0002nY*\u0011A&L\u0001\u0006gB\f'o\u001b\u0006\u0003]=\na!\u00199bG\",'\"\u0001\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0019d\bR$N!\u0011!TgN\u001f\u000e\u0003\u001dJ!AN\u0014\u0003\u001fI+wM]3tg&|g.T8eK2\u0004\"\u0001O\u001e\u000e\u0003eR!AO\u0015\u0002\r1Lg.\u00197h\u0013\ta\u0014H\u0001\u0004WK\u000e$xN\u001d\t\u0003i\u0001\u0001\"a\u0010\"\u000e\u0003\u0001S!!Q\u0015\u0002\tQ\u0014X-Z\u0005\u0003\u0007\u0002\u0013\u0011\u0003R3dSNLwN\u001c+sK\u0016lu\u000eZ3m!\tyT)\u0003\u0002G\u0001\nYB)Z2jg&|g\u000e\u0016:fKJ+wM]3tg>\u0014\b+\u0019:b[N\u0004\"\u0001S&\u000e\u0003%S!AS\u0015\u0002\tU$\u0018\u000e\\\u0005\u0003\u0019&\u0013!\"\u0014'Xe&$\u0018M\u00197f!\tq\u0005L\u0004\u0002P+:\u0011\u0001kU\u0007\u0002#*\u0011!+M\u0001\u0007yI|w\u000e\u001e \n\u0003Q\u000bQa]2bY\u0006L!AV,\u0002\u000fA\f7m[1hK*\tA+\u0003\u0002Z5\na1+\u001a:jC2L'0\u00192mK*\u0011akV\u0001\u0004k&$W#A/\u0011\u0005y\u0013gBA0a!\t\u0001v+\u0003\u0002b/\u00061\u0001K]3eK\u001aL!a\u00193\u0003\rM#(/\u001b8h\u0015\t\tw+\u0001\u0003vS\u0012\u0004\u0013\u0001\u0003:p_Rtu\u000eZ3\u0016\u0003!\u0004\"aP5\n\u0005)\u0004%\u0001\u0002(pI\u0016\f\u0011B]8pi:{G-\u001a\u0011\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002]B\u0011q\u000e]\u0007\u0002/&\u0011\u0011o\u0016\u0002\u0004\u0013:$\u0018\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003>kZ<\b\"B.\b\u0001\u0004i\u0006\"\u00024\b\u0001\u0004A\u0007\"\u00027\b\u0001\u0004q\u0017AD:fiZ\u000b'/[1oG\u0016\u001cu\u000e\u001c\u000b\u0003unl\u0011\u0001\u0001\u0005\u0006y\"\u0001\r!X\u0001\u0006m\u0006dW/\u001a\u000b\u0004{y|\b\"\u00024\n\u0001\u0004A\u0007\"\u00027\n\u0001\u0004qG#A\u001f\u0002\u001b\u0015\u001cH/[7bi\u0016$7+\u001b>f+\t\t9\u0001E\u0002p\u0003\u0013I1!a\u0003X\u0005\u0011auN\\4\u0002\u000fA\u0014X\rZ5diR!\u0011\u0011CA\f!\ry\u00171C\u0005\u0004\u0003+9&A\u0002#pk\ndW\r\u0003\u0004\u0002\u001a1\u0001\raN\u0001\tM\u0016\fG/\u001e:fg\u0006y\u0001O]3eS\u000e$h+\u0019:jC:\u001cW\r\u0006\u0003\u0002\u0012\u0005}\u0001BBA\r\u001b\u0001\u0007q'A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\t)#!\u000e\u0011\t\u0005\u001d\u0012\u0011G\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005)A/\u001f9fg*\u0019\u0011qF\u0016\u0002\u0007M\fH.\u0003\u0003\u00024\u0005%\"AC*ueV\u001cG\u000fV=qK\"9\u0011q\u0007\bA\u0002\u0005\u0015\u0012AB:dQ\u0016l\u0017\rK\u0003\u000f\u0003w\t9\u0005\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\teK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA#\u0003\u007f\u0011QaU5oG\u0016\f#!!\u0013\u0002\u000bErCG\f\u0019\u0002\u0013Q\u0014\u0018M\\:g_JlG\u0003BA(\u0003W\u0002B!!\u0015\u0002f9!\u00111KA2\u001d\u0011\t)&!\u0019\u000f\t\u0005]\u0013q\f\b\u0005\u00033\niFD\u0002Q\u00037J\u0011\u0001M\u0005\u0003]=J!\u0001L\u0017\n\u0007\u0005=2&C\u0002W\u0003[IA!a\u001a\u0002j\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004-\u00065\u0002bBA7\u001f\u0001\u0007\u0011qN\u0001\bI\u0006$\u0018m]3ua\u0011\t\t(! \u0011\r\u0005M\u0014QOA=\u001b\t\ti#\u0003\u0003\u0002x\u00055\"a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003w\ni\b\u0004\u0001\u0005\u0019\u0005}\u00141NA\u0001\u0002\u0003\u0015\t!!!\u0003\u0007}##'\u0005\u0003\u0002\u0004\u0006%\u0005cA8\u0002\u0006&\u0019\u0011qQ,\u0003\u000f9{G\u000f[5oOB\u0019q.a#\n\u0007\u00055uKA\u0002B]fDSaDA\u001e\u0003#\u000b#!a%\u0002\u000bIr\u0003G\f\u0019\u0002\t\r|\u0007/\u001f\u000b\u0004{\u0005e\u0005bBAN!\u0001\u0007\u0011QT\u0001\u0006Kb$(/\u0019\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*\u0019\u00111U\u0015\u0002\u000bA\f'/Y7\n\t\u0005\u001d\u0016\u0011\u0015\u0002\t!\u0006\u0014\u0018-\\'ba\"*\u0001#a\u000f\u0002H\u0005AAo\\*ue&tw\rF\u0001^Q\u0015\t\u00121HA$\u0003I1W-\u0019;ve\u0016LU\u000e]8si\u0006t7-Z:\u0016\u0003]BSAEA\u001e\u0003#\u000bQ\u0001^8PY\u0012,\"!a/\u0011\t\u0005u\u0016\u0011Z\u0007\u0003\u0003\u007fSA!!1\u0002D\u0006)Qn\u001c3fY*\u0019\u0011)!2\u000b\u0007\u0005\u001d7&A\u0003nY2L'-C\u0002D\u0003\u007f\u000bQa\u001e:ji\u0016,\"!a4\u0011\u0007!\u000b\t.C\u0002\u0002T&\u0013\u0001\"\u0014'Xe&$XM\u001d\u0015\u0006)\u0005m\u0012\u0011\u0013\u0015\u0006\u0001\u0005m\u0012qI\u0001\u001c\t\u0016\u001c\u0017n]5p]R\u0013X-\u001a*fOJ,7o]5p]6{G-\u001a7\u0011\u0005Q22c\u0002\f\u0002`\u0006\u0015\u00181\u001e\t\u0004_\u0006\u0005\u0018bAAr/\n1\u0011I\\=SK\u001a\u0004B\u0001SAt{%\u0019\u0011\u0011^%\u0003\u00155c%+Z1eC\ndW\r\u0005\u0003\u0002n\u0006]XBAAx\u0015\u0011\t\t0a=\u0002\u0005%|'BAA{\u0003\u0011Q\u0017M^1\n\u0007e\u000by\u000f\u0006\u0002\u0002\\\u0006!!/Z1e+\t\ty\u0010\u0005\u0003I\u0005\u0003i\u0014b\u0001B\u0002\u0013\nAQ\n\u0014*fC\u0012,'\u000fK\u0003\u0019\u0003w\t\t*\u0001\u0003m_\u0006$GcA\u001f\u0003\f!1!QB\rA\u0002u\u000bA\u0001]1uQ\"*\u0011$a\u000f\u0002\u0012\n\tC)Z2jg&|g\u000e\u0016:fKJ+wM]3tg&|g.T8eK2<&/\u001b;feN\u0019!$a4\u0002\u0011%t7\u000f^1oG\u0016$BA!\u0007\u0003\u001eA\u0019!1\u0004\u000e\u000e\u0003YAaA!\u0006\u001d\u0001\u0004i\u0014\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\t\r\"\u0011\u0006\t\u0004_\n\u0015\u0012b\u0001B\u0014/\n!QK\\5u\u0011\u0019\u0011i!\ba\u0001;\n\tC)Z2jg&|g\u000e\u0016:fKJ+wM]3tg&|g.T8eK2\u0014V-\u00193feN\u0019a$a@\u0015\u0005\tE\u0002c\u0001B\u000e=\u0005I1\r\\1tg:\u000bW.Z\u000b\u0003\u0005o\u0001BA!\u000f\u0003@5\u0011!1\b\u0006\u0005\u0005{\t\u00190\u0001\u0003mC:<\u0017bA2\u0003<\u0005Q1\r\\1tg:\u000bW.\u001a\u0011\u0015\u0007u\u0012)\u0005\u0003\u0004\u0003\u000e\t\u0002\r!X\u0001\bMJ|Wn\u00147e)%i$1\nB(\u00053\u0012\u0019\u0007C\u0004\u0003N\r\u0002\r!a/\u0002\u0011=dG-T8eK2DqA!\u0015$\u0001\u0004\u0011\u0019&\u0001\u0004qCJ,g\u000e\u001e\t\u0004i\tU\u0013b\u0001B,O\t)B)Z2jg&|g\u000e\u0016:fKJ+wM]3tg>\u0014\bb\u0002B.G\u0001\u0007!QL\u0001\u0014G\u0006$XmZ8sS\u000e\fGNR3biV\u0014Xm\u001d\t\u0006=\n}cN\\\u0005\u0004\u0005C\"'aA'ba\"9An\tI\u0001\u0002\u0004q\u0017!\u00054s_6|E\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u000e\u0016\u0004]\n-4F\u0001B7!\u0011\u0011yGa\u001e\u000e\u0005\tE$\u0002\u0002B:\u0005k\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005s+\u0003\u0003\u0003z\tE$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u0010\t\u0005\u0005s\u0011\t)\u0003\u0003\u0003\u0004\nm\"AB(cU\u0016\u001cG\u000fK\u0003\u0017\u0003w\t\t\nK\u0003\u0016\u0003w\t\t\n")
public class DecisionTreeRegressionModel
extends RegressionModel<Vector, DecisionTreeRegressionModel>
implements DecisionTreeModel,
DecisionTreeRegressorParams,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final Node rootNode;
    private final int numFeatures;
    private Param<String> varianceCol;
    private Param<String> impurity;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private int depth;
    private int numLeave;
    private NominalAttribute leafAttr;
    private transient Map<LeafNode, Object> org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static DecisionTreeRegressionModel load(String path) {
        return DecisionTreeRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<DecisionTreeRegressionModel> read() {
        return DecisionTreeRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$DecisionTreeRegressorParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return DecisionTreeRegressorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getVarianceCol() {
        return HasVarianceCol.getVarianceCol$(this);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public int numNodes() {
        return DecisionTreeModel.numNodes$(this);
    }

    @Override
    public String toDebugString() {
        return DecisionTreeModel.toDebugString$(this);
    }

    @Override
    public int maxSplitFeatureIndex() {
        return DecisionTreeModel.maxSplitFeatureIndex$(this);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return DecisionTreeModel.getLeafField$(this, leafCol);
    }

    @Override
    public double predictLeaf(Vector features) {
        return DecisionTreeModel.predictLeaf$(this, features);
    }

    @Override
    public long getEstimatedSize() {
        return DecisionTreeModel.getEstimatedSize$(this);
    }

    @Override
    public final Param<String> varianceCol() {
        return this.varianceCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasVarianceCol$_setter_$varianceCol_$eq(Param<String> x$1) {
        this.varianceCol = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    private int depth$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.depth = DecisionTreeModel.depth$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.depth;
    }

    @Override
    public int depth() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.depth$lzycompute();
        }
        return this.depth;
    }

    private int numLeave$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.numLeave = DecisionTreeModel.numLeave$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.numLeave;
    }

    @Override
    public int numLeave() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.numLeave$lzycompute();
        }
        return this.numLeave;
    }

    private NominalAttribute leafAttr$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.leafAttr = DecisionTreeModel.leafAttr$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.leafAttr;
    }

    @Override
    public NominalAttribute leafAttr() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.leafAttr$lzycompute();
        }
        return this.leafAttr;
    }

    private Map<LeafNode, Object> org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if (!this.bitmap$trans$0) {
                this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices = DecisionTreeModel.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices;
    }

    @Override
    public Map<LeafNode, Object> org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices() {
        if (!this.bitmap$trans$0) {
            return this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices$lzycompute();
        }
        return this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public Node rootNode() {
        return this.rootNode;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public DecisionTreeRegressionModel setVarianceCol(String value) {
        return (DecisionTreeRegressionModel)this.set(this.varianceCol(), value);
    }

    @Override
    public long estimatedSize() {
        return this.getEstimatedSize();
    }

    @Override
    public double predict(Vector features) {
        return this.rootNode().predictImpl(features).prediction();
    }

    public double predictVariance(Vector features) {
        return this.rootNode().predictImpl(features).impurityStats().calculate();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block1: {
            outputSchema = super.transformSchema(schema);
            if (this.isDefined(this.varianceCol()) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.varianceCol())))) {
                outputSchema = SchemaUtils$.MODULE$.updateNumeric(outputSchema, this.$(this.varianceCol()));
            }
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return outputSchema;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)scala.package$.MODULE$.Seq().empty();
        Seq predictionColumns = (Seq)scala.package$.MODULE$.Seq().empty();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator1$1(DecisionTreeRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator1$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.predictionCol()), outputSchema.apply(this.$(this.predictionCol())).metadata()));
        }
        if (this.isDefined(this.varianceCol()) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.varianceCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator2$1(DecisionTreeRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictVarianceUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)this.predictVariance(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator2$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.varianceCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictVarianceUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.varianceCol()), outputSchema.apply(this.$(this.varianceCol())).metadata()));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator3$1(DecisionTreeRegressionModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)this.predictLeaf(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator3$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.leafCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.leafCol()), outputSchema.apply(this.$(this.leafCol())).metadata()));
        }
        if (predictionColNames.nonEmpty()) {
            return dataset.withColumns(predictionColNames, predictionColumns);
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ": DecisionTreeRegressionModel.transform() "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.UUID, this.uid())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"does nothing because no output columns were set."}))).log((Seq)Nil$.MODULE$))));
        return dataset.toDF();
    }

    @Override
    public DecisionTreeRegressionModel copy(ParamMap extra) {
        return (DecisionTreeRegressionModel)((Model)this.copyValues(new DecisionTreeRegressionModel(this.uid(), this.rootNode(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return "DecisionTreeRegressionModel: uid=" + this.uid() + ", depth=" + this.depth() + ", numNodes=" + this.numNodes() + ", numFeatures=" + this.numFeatures();
    }

    private Vector featureImportances$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this, this.numFeatures(), ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.featureImportances$lzycompute();
        }
        return this.featureImportances;
    }

    @Override
    public org.apache.spark.mllib.tree.model.DecisionTreeModel toOld() {
        return new org.apache.spark.mllib.tree.model.DecisionTreeModel(this.rootNode().toOld(1), Algo$.MODULE$.Regression());
    }

    @Override
    public MLWriter write() {
        return new DecisionTreeRegressionModelWriter(this);
    }

    public DecisionTreeRegressionModel(String uid, Node rootNode, int numFeatures) {
        this.uid = uid;
        this.rootNode = rootNode;
        this.numFeatures = numFeatures;
        DecisionTreeModel.$init$(this);
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        HasVarianceCol.$init$(this);
        DecisionTreeRegressorParams.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(rootNode != null, (Function0 & Serializable)() -> "DecisionTreeRegressionModel given null rootNode, but it requires a non-null rootNode.");
        Statics.releaseFence();
    }

    public DecisionTreeRegressionModel(Node rootNode, int numFeatures) {
        this(Identifiable$.MODULE$.randomUID("dtr"), rootNode, numFeatures);
    }

    public DecisionTreeRegressionModel() {
        this("", Node$.MODULE$.dummyNode(), -1);
    }

    private static class DecisionTreeRegressionModelReader
    extends MLReader<DecisionTreeRegressionModel> {
        private final String className = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public DecisionTreeRegressionModel load(String path) {
            DefaultFormats$ format = DefaultFormats$.MODULE$;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            int numFeatures = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata.metadata()), "numFeatures")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            Node root = DecisionTreeModelReadWrite$.MODULE$.loadTreeNodes(path, metadata, this.sparkSession());
            DecisionTreeRegressionModel model = new DecisionTreeRegressionModel(metadata.uid(), root, numFeatures);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class DecisionTreeRegressionModelWriter
    extends MLWriter {
        private final DecisionTreeRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml.tree")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.ml.tree.DecisionTreeModelReadWrite")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.tree.DecisionTreeModelReadWrite.NodeData"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$$typecreator1$2(DecisionTreeRegressionModelWriter $outer) {
                }
            }
            JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession(), (Option<JObject>)new Some((Object)extraMetadata));
            Tuple2<Seq<DecisionTreeModelReadWrite.NodeData>, Object> tuple2 = DecisionTreeModelReadWrite$NodeData$.MODULE$.build(this.instance.rootNode(), 0);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq nodeData = (Seq)tuple2._1();
            Seq nodeData2 = nodeData;
            String dataPath = new Path(path, "data").toString();
            int numDataParts = DecisionTreeModelReadWrite$NodeData$.MODULE$.inferNumPartitions(this.instance.numNodes());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModelWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveArray(dataPath, nodeData2.toArray(ClassTag$.MODULE$.apply(DecisionTreeModelReadWrite.NodeData.class)), this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                DecisionTreeModelReadWrite$NodeData$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, numDataParts, ClassTag$.MODULE$.apply(DecisionTreeModelReadWrite.NodeData.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$$typecreator1$2(null)));
        }

        public DecisionTreeRegressionModelWriter(DecisionTreeRegressionModel instance) {
            this.instance = instance;
        }
    }
}

