/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableIdMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceIdMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.ObjectLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class JDOHelperGetObjectIdMethod
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression ignore, List<SQLExpression> args) {
        if (args == null || args.size() == 0) {
            throw new NucleusUserException("Cannot invoke JDOHelper.getObjectId without an argument");
        }
        SQLExpression expr = args.get(0);
        if (expr == null) {
            return new NullLiteral(this.stmt, null, null, null);
        }
        if (expr instanceof SQLLiteral) {
            RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
            ApiAdapter api = storeMgr.getApiAdapter();
            Object id = api.getIdForObject(((SQLLiteral)((Object)expr)).getValue());
            if (id == null) {
                return new NullLiteral(this.stmt, null, null, null);
            }
            JavaTypeMapping m = this.getMappingForClass(id.getClass());
            return new ObjectLiteral(this.stmt, m, id, null);
        }
        if (ObjectExpression.class.isAssignableFrom(expr.getClass())) {
            if (expr.getJavaTypeMapping() instanceof PersistableMapping) {
                PersistableIdMapping mapping = new PersistableIdMapping((PersistableMapping)expr.getJavaTypeMapping());
                return new ObjectExpression(this.stmt, expr.getSQLTable(), mapping);
            }
            if (expr.getJavaTypeMapping() instanceof ReferenceMapping) {
                ReferenceIdMapping mapping = new ReferenceIdMapping((ReferenceMapping)expr.getJavaTypeMapping());
                return new ObjectExpression(this.stmt, expr.getSQLTable(), mapping);
            }
            return expr;
        }
        throw new IllegalExpressionOperationException("JDOHelper.getObjectId", expr);
    }
}

