/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasLoss;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.LinearModelData;
import org.apache.spark.ml.regression.LinearModelData$;
import org.apache.spark.ml.regression.LinearRegressionModel$;
import org.apache.spark.ml.regression.LinearRegressionModel$LinearRegressionModelReader$;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionSummary;
import org.apache.spark.ml.regression.LinearRegressionSummary$;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.GeneralMLWritable;
import org.apache.spark.ml.util.GeneralMLWriter;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t-d\u0001\u0002\u0013&\u0001AB\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0005\u0014\u0005\tG\u0002\u0011\t\u0011)A\u0005\u001b\"AQ\r\u0001BC\u0002\u0013\u0005a\r\u0003\u0005k\u0001\t\u0005\t\u0015!\u00036\u0011!a\u0007A!b\u0001\n\u0003i\u0007\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011\u00028\t\u0011]\u0004!Q1A\u0005\u00025D\u0001b\u001f\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\u0007{\u0002!\ta\n@\t\u000fu\u0004A\u0011A\u0014\u0002\u0010!9Q\u0010\u0001C\u0001O\u0005]\u0001\"CA\r\u0001\t\u0007I\u0011IA\u000e\u0011!\t\u0019\u0003\u0001Q\u0001\n\u0005u\u0001bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011!\t\u0019\u0007\u0001C\u0001K\u0005\u0015\u0004bBA7\u0001\u0011\u0005\u0013q\u000e\u0005\b\u0003k\u0002A\u0011IA<\u0011!\tY\t\u0001C!S\u00055\u0005bBAK\u0001\u0011\u0005\u0013q\u0013\u0005\b\u0003K\u0003A\u0011IAT\u0011!\ty\u000b\u0001C\u0001S\u0005E\u0006\u0002CAl\u0001\u0011\u0005\u0013&!7\t\u0011\u0005}\u0007\u0001\"\u0011*\u0003C<qAa\u0002&\u0011\u0003\u0011IA\u0002\u0004%K!\u0005!1\u0002\u0005\u0007{j!\tA!\u000b\t\u000f\t-\"\u0004\"\u0011\u0003.!9!q\u0007\u000e\u0005B\tebA\u0002B 5\u0011\u0011\t\u0005\u0003\u0004~=\u0011\u0005!1\t\u0005\n\u0005\u0013r\"\u0019!C\u0005\u0005\u0017B\u0001Ba\u0016\u001fA\u0003%!Q\n\u0005\b\u0005oqB\u0011\tB-\u0011%\u0011iFGA\u0001\n\u0013\u0011yFA\u000bMS:,\u0017M\u001d*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\u0019:\u0013A\u0003:fOJ,7o]5p]*\u0011\u0001&K\u0001\u0003[2T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0011\u0007P F!\u0011\u00114'N\u001e\u000e\u0003\u0015J!\u0001N\u0013\u0003\u001fI+wM]3tg&|g.T8eK2\u0004\"AN\u001d\u000e\u0003]R!\u0001O\u0014\u0002\r1Lg.\u00197h\u0013\tQtG\u0001\u0004WK\u000e$xN\u001d\t\u0003e\u0001\u0001\"AM\u001f\n\u0005y*#A\u0006'j]\u0016\f'OU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t;\u0013\u0001B;uS2L!\u0001R!\u0003#\u001d+g.\u001a:bY6cuK]5uC\ndW\rE\u0002A\r\"K!aR!\u0003%!\u000b7\u000f\u0016:bS:LgnZ*v[6\f'/\u001f\t\u0003e%K!AS\u0013\u0003?1Kg.Z1s%\u0016<'/Z:tS>tGK]1j]&twmU;n[\u0006\u0014\u00180A\u0002vS\u0012,\u0012!\u0014\t\u0003\u001d^s!aT+\u0011\u0005A\u001bV\"A)\u000b\u0005I{\u0013A\u0002\u001fs_>$hHC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16+\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u0013aa\u0015;sS:<'B\u0001,TQ\r\t1,\u0019\t\u00039~k\u0011!\u0018\u0006\u0003=&\n!\"\u00198o_R\fG/[8o\u0013\t\u0001WLA\u0003TS:\u001cW-I\u0001c\u0003\u0015\td\u0006\u000e\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\tY\u0016-\u0001\u0007d_\u00164g-[2jK:$8/F\u00016Q\r\u00191\f[\u0011\u0002S\u0006)!G\f\u0019/a\u0005i1m\\3gM&\u001c\u0017.\u001a8ug\u0002B3\u0001B.i\u0003%Ig\u000e^3sG\u0016\u0004H/F\u0001o!\ty\u0007/D\u0001T\u0013\t\t8K\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u000bm\u001b\u0018%\u0001;\u0002\u000bEr3G\f\u0019\u0002\u0015%tG/\u001a:dKB$\b\u0005K\u0002\u00077N\fQa]2bY\u0016D3aB.zC\u0005Q\u0018!\u0002\u001a/g9\u0002\u0014AB:dC2,\u0007\u0005K\u0002\t7f\fa\u0001P5oSRtD\u0003C\u001e\u0000\u0003\u0007\t9!a\u0003\t\u000b-K\u0001\u0019A')\u0007}\\\u0016\rC\u0003f\u0013\u0001\u0007Q\u0007\u000b\u0003\u0002\u0004mC\u0007\"\u00027\n\u0001\u0004q\u0007\u0006BA\u00047NDQa^\u0005A\u00029DC!a\u0003\\sR91(!\u0005\u0002\u0014\u0005U\u0001\"B&\u000b\u0001\u0004i\u0005\"B3\u000b\u0001\u0004)\u0004\"\u00027\u000b\u0001\u0004qG#A\u001e\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0003\u0003;\u00012a\\A\u0010\u0013\r\t\tc\u0015\u0002\u0004\u0013:$\u0018\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0013aB:v[6\f'/_\u000b\u0002\u0011\"\"abWA\u0016C\t\ti#A\u00032]Ur\u0003'\u0001\u0005fm\u0006dW/\u0019;f)\u0011\t\u0019$!\u000f\u0011\u0007I\n)$C\u0002\u00028\u0015\u0012q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8Tk6l\u0017M]=\t\u000f\u0005mr\u00021\u0001\u0002>\u00059A-\u0019;bg\u0016$\b\u0007BA \u0003\u001f\u0002b!!\u0011\u0002H\u0005-SBAA\"\u0015\r\t)%K\u0001\u0004gFd\u0017\u0002BA%\u0003\u0007\u0012q\u0001R1uCN,G\u000f\u0005\u0003\u0002N\u0005=C\u0002\u0001\u0003\r\u0003#\nI$!A\u0001\u0002\u000b\u0005\u00111\u000b\u0002\u0004?\u0012*\u0014\u0003BA+\u00037\u00022a\\A,\u0013\r\tIf\u0015\u0002\b\u001d>$\b.\u001b8h!\ry\u0017QL\u0005\u0004\u0003?\u001a&aA!os\"\u001aqb\u00175\u0002A\u0019Lg\u000eZ*v[6\f'/_'pI\u0016d\u0017I\u001c3Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u000b\u0003\u0003O\u0002Ra\\A5w5K1!a\u001bT\u0005\u0019!V\u000f\u001d7fe\u00059\u0001O]3eS\u000e$Hc\u00018\u0002r!1\u00111O\tA\u0002U\n\u0001BZ3biV\u0014Xm]\u0001\u0005G>\u0004\u0018\u0010F\u0002<\u0003sBq!a\u001f\u0013\u0001\u0004\ti(A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019iJ\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003\u000f\u000b\tI\u0001\u0005QCJ\fW.T1qQ\r\u00112,Y\u0001\u000eKN$\u0018.\\1uK\u0012\u001c\u0016N_3\u0016\u0005\u0005=\u0005cA8\u0002\u0012&\u0019\u00111S*\u0003\t1{gnZ\u0001\u0006oJLG/Z\u000b\u0003\u00033\u00032\u0001QAN\u0013\r\ti*\u0011\u0002\u0010\u000f\u0016tWM]1m\u001b2;&/\u001b;fe\"\"AcWAQC\t\t\u0019+A\u00032]Yr\u0003'\u0001\u0005u_N#(/\u001b8h)\u0005i\u0005\u0006B\u000b\\\u0003W\u000b#!!,\u0002\u000bMr\u0003G\f\u0019\u0002\u001b\r\u0014X-\u0019;f'VlW.\u0019:z))\t\u0019,!/\u0002F\u0006=\u00171\u001b\t\u0004_\u0006U\u0016bAA\\'\n!QK\\5u\u0011\u001d\tYD\u0006a\u0001\u0003w\u0003D!!0\u0002BB1\u0011\u0011IA$\u0003\u007f\u0003B!!\u0014\u0002B\u0012a\u00111YA]\u0003\u0003\u0005\tQ!\u0001\u0002T\t\u0019q\f\n\u001c\t\u000f\u0005\u001dg\u00031\u0001\u0002J\u0006YA-[1h\u0013:4\u0018\t^,B!\u0011y\u00171\u001a8\n\u0007\u000557KA\u0003BeJ\f\u0017\u0010C\u0004\u0002RZ\u0001\r!!3\u0002!=\u0014'.Z2uSZ,\u0007*[:u_JL\bbBAk-\u0001\u0007\u0011\u0011Z\u0001\u0011G>,gMZ5dS\u0016tG/\u0011:sCf\f1b]1wKN+X.\\1ssR!\u00111WAn\u0011\u0019\tin\u0006a\u0001\u001b\u0006!\u0001/\u0019;i\u0003-aw.\u00193Tk6l\u0017M]=\u0015\r\u0005M\u00161]As\u0011\u0019\ti\u000e\u0007a\u0001\u001b\"9\u00111\b\rA\u0002\u0005\u001d\b\u0003BAu\u0003\u007ftA!a;\u0002|:!\u0011Q^A}\u001d\u0011\ty/a>\u000f\t\u0005E\u0018Q\u001f\b\u0004!\u0006M\u0018\"\u0001\u0018\n\u00051j\u0013B\u0001\u0016,\u0013\r\t)%K\u0005\u0005\u0003{\f\u0019%A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0005!1\u0001\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!!@\u0002D!\u001a\u0001aW:\u0002+1Kg.Z1s%\u0016<'/Z:tS>tWj\u001c3fYB\u0011!GG\n\b5\t5!1\u0003B\r!\ry'qB\u0005\u0004\u0005#\u0019&AB!osJ+g\r\u0005\u0003A\u0005+Y\u0014b\u0001B\f\u0003\nQQ\n\u0014*fC\u0012\f'\r\\3\u0011\t\tm!QE\u0007\u0003\u0005;QAAa\b\u0003\"\u0005\u0011\u0011n\u001c\u0006\u0003\u0005G\tAA[1wC&!!q\u0005B\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011I!\u0001\u0003sK\u0006$WC\u0001B\u0018!\u0011\u0001%\u0011G\u001e\n\u0007\tM\u0012I\u0001\u0005N\u0019J+\u0017\rZ3sQ\u0011a2,!)\u0002\t1|\u0017\r\u001a\u000b\u0004w\tm\u0002BBAo;\u0001\u0007Q\n\u000b\u0003\u001e7\u0006\u0005&a\u0007'j]\u0016\f'OU3he\u0016\u001c8/[8o\u001b>$W\r\u001c*fC\u0012,'oE\u0002\u001f\u0005_!\"A!\u0012\u0011\u0007\t\u001dc$D\u0001\u001b\u0003%\u0019G.Y:t\u001d\u0006lW-\u0006\u0002\u0003NA!!q\nB+\u001b\t\u0011\tF\u0003\u0003\u0003T\t\u0005\u0012\u0001\u00027b]\u001eL1\u0001\u0017B)\u0003)\u0019G.Y:t\u001d\u0006lW\r\t\u000b\u0004w\tm\u0003BBAoE\u0001\u0007Q*\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003bA!!q\nB2\u0013\u0011\u0011)G!\u0015\u0003\r=\u0013'.Z2uQ\u0011Q2,!))\teY\u0016\u0011\u0015")
public class LinearRegressionModel
extends RegressionModel<Vector, LinearRegressionModel>
implements LinearRegressionParams,
GeneralMLWritable,
HasTrainingSummary<LinearRegressionTrainingSummary> {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private final int numFeatures;
    private Option<LinearRegressionTrainingSummary> trainingSummary;
    private Param<String> solver;
    private Param<String> loss;
    private DoubleParam epsilon;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private BooleanParam fitIntercept;
    private DoubleParam tol;
    private IntParam maxIter;
    private DoubleParam elasticNetParam;
    private DoubleParam regParam;

    public static LinearRegressionModel load(String path) {
        return LinearRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<LinearRegressionModel> read() {
        return LinearRegressionModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<LinearRegressionTrainingSummary> setSummary(Option<LinearRegressionTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$LinearRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public double getEpsilon() {
        return LinearRegressionParams.getEpsilon$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LinearRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final String getLoss() {
        return HasLoss.getLoss$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Option<LinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<LinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final Param<String> loss() {
        return this.loss;
    }

    @Override
    public final DoubleParam epsilon() {
        return this.epsilon;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$loss_$eq(Param<String> x$1) {
        this.loss = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$epsilon_$eq(DoubleParam x$1) {
        this.epsilon = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasLoss$_setter_$loss_$eq(Param<String> x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public LinearRegressionTrainingSummary summary() {
        return (LinearRegressionTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public LinearRegressionSummary evaluate(Dataset<?> dataset) {
        Tuple2<LinearRegressionModel, String> tuple2 = this.findSummaryModelAndPredictionCol();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
        String predictionColName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
        LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple22._1();
        String predictionColName2 = (String)tuple22._2();
        return new LinearRegressionSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), (String)summaryModel2.get(summaryModel2.weightCol()).getOrElse((Function0 & Serializable)() -> ""), summaryModel2.numFeatures(), summaryModel2.getFitIntercept(), new double[]{0.0}, LinearRegressionSummary$.MODULE$.$lessinit$greater$default$9());
    }

    public Tuple2<LinearRegressionModel, String> findSummaryModelAndPredictionCol() {
        String string = this.$(this.predictionCol());
        switch (string == null ? 0 : string.hashCode()) {
            case 0: {
                if (!"".equals(string)) break;
                String predictionColName = "prediction_" + UUID.randomUUID().toString();
                return new Tuple2(this.copy(ParamMap$.MODULE$.empty()).setPredictionCol(predictionColName), (Object)predictionColName);
            }
        }
        return new Tuple2((Object)this, (Object)string);
    }

    @Override
    public double predict(Vector features) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept();
    }

    @Override
    public LinearRegressionModel copy(ParamMap extra) {
        LinearRegressionModel newModel = this.copyValues(new LinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        return (LinearRegressionModel)((Model)((Object)newModel.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public long estimatedSize() {
        long size;
        block0: {
            size = this.estimateMatadataSize();
            if (this.coefficients() == null) break block0;
            size += this.coefficients().getSizeInBytes();
        }
        return size;
    }

    @Override
    public GeneralMLWriter write() {
        return new GeneralMLWriter(this);
    }

    @Override
    public String toString() {
        return "LinearRegressionModel: uid=" + this.uid() + ", numFeatures=" + this.numFeatures();
    }

    public void createSummary(Dataset<?> dataset, double[] diagInvAtWA, double[] objectiveHistory, double[] coefficientArray) {
        Tuple2<LinearRegressionModel, String> tuple2 = this.findSummaryModelAndPredictionCol();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
        String predictionColName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
        LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple22._1();
        String predictionColName2 = (String)tuple22._2();
        LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), (String)summaryModel2.get(summaryModel2.weightCol()).getOrElse((Function0 & Serializable)() -> ""), summaryModel2.numFeatures(), summaryModel2.getFitIntercept(), diagInvAtWA, objectiveHistory, coefficientArray);
        this.setSummary((Option<LinearRegressionTrainingSummary>)new Some((Object)trainingSummary));
    }

    @Override
    public void saveSummary(String path) {
        public final class Org_apache_spark_ml_regression_LinearRegressionModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_regression_LinearRegressionModel$$typecreator1$1(LinearRegressionModel $outer) {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearRegressionModel.class.getClassLoader());
        ReadWriteUtils$.MODULE$.saveObjectToLocal(path, new Tuple3((Object)this.summary().diagInvAtWA(), (Object)this.summary().objectiveHistory(), (Object)this.summary().coefficientArray()), (Function2 & Serializable)(data, dos) -> {
            LinearRegressionModel.$anonfun$saveSummary$1(data, dos);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(Tuple3.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionModel$$typecreator1$1(null)));
    }

    @Override
    public void loadSummary(String path, Dataset<Row> dataset) {
        double[] dArray;
        double[] dArray2;
        double[] coefficientArray;
        block3: {
            Tuple3 tuple3;
            block2: {
                public final class Org_apache_spark_ml_regression_LinearRegressionModel$$typecreator1$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_ml_regression_LinearRegressionModel$$typecreator1$2(LinearRegressionModel $outer) {
                    }
                }
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearRegressionModel.class.getClassLoader());
                tuple3 = (Tuple3)ReadWriteUtils$.MODULE$.loadObjectFromLocal(path, (Function1 & Serializable)dis -> {
                    double[] diagInvAtWA = ReadWriteUtils$.MODULE$.deserializeDoubleArray((DataInputStream)dis);
                    double[] objectiveHistory = ReadWriteUtils$.MODULE$.deserializeDoubleArray((DataInputStream)dis);
                    double[] coefficientArray = ReadWriteUtils$.MODULE$.deserializeDoubleArray((DataInputStream)dis);
                    return new Tuple3((Object)diagInvAtWA, (Object)objectiveHistory, (Object)coefficientArray);
                }, ClassTag$.MODULE$.apply(Tuple3.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionModel$$typecreator1$2(null)));
                if (tuple3 == null) break block2;
                double[] diagInvAtWA = (double[])tuple3._1();
                double[] objectiveHistory = (double[])tuple3._2();
                coefficientArray = (double[])tuple3._3();
                if (diagInvAtWA == null) break block2;
                dArray2 = diagInvAtWA;
                if (objectiveHistory == null) break block2;
                dArray = objectiveHistory;
                if (coefficientArray != null) break block3;
            }
            throw new MatchError((Object)tuple3);
        }
        double[] dArray3 = coefficientArray;
        Tuple3 tuple3 = new Tuple3((Object)dArray2, (Object)dArray, (Object)dArray3);
        double[] diagInvAtWA = (double[])tuple3._1();
        double[] objectiveHistory = (double[])tuple3._2();
        double[] coefficientArray2 = (double[])tuple3._3();
        this.createSummary(dataset, diagInvAtWA, objectiveHistory, coefficientArray2);
    }

    public static final /* synthetic */ void $anonfun$saveSummary$1(Tuple3 data, DataOutputStream dos) {
        ReadWriteUtils$.MODULE$.serializeDoubleArray((double[])data._1(), dos);
        ReadWriteUtils$.MODULE$.serializeDoubleArray((double[])data._2(), dos);
        ReadWriteUtils$.MODULE$.serializeDoubleArray((double[])data._3(), dos);
    }

    public LinearRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        HasAggregationDepth.$init$(this);
        HasLoss.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LinearRegressionParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        this.numFeatures = coefficients.size();
        Statics.releaseFence();
    }

    public LinearRegressionModel(String uid, Vector coefficients, double intercept) {
        this(uid, coefficients, intercept, 1.0);
    }

    public LinearRegressionModel() {
        this("", (Vector)Vectors$.MODULE$.empty(), Double.NaN, Double.NaN);
    }

    private static class LinearRegressionModelReader
    extends MLReader<LinearRegressionModel> {
        private final String className = LinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LinearRegressionModel load(String path) {
            LinearRegressionModel linearRegressionModel;
            DefaultParamsReader.Metadata metadata;
            block7: {
                String dataPath;
                block4: {
                    double d;
                    Object coefficients;
                    block6: {
                        Row row;
                        block5: {
                            Some some;
                            metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
                            dataPath = new Path(path, "data").toString();
                            Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            int majorVersion = tuple2._1$mcI$sp();
                            int minorVersion = tuple2._2$mcI$sp();
                            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(majorVersion, minorVersion);
                            int majorVersion2 = sp2._1$mcI$sp();
                            int minorVersion2 = sp2._2$mcI$sp();
                            if (majorVersion2 >= 2 && (majorVersion2 != 2 || minorVersion2 > 2)) break block4;
                            Dataset data = this.sparkSession().read().format("parquet").load(dataPath);
                            row = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("intercept", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
                            if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(2) != 0) break block5;
                            Object intercept = ((SeqOps)some.get()).apply(0);
                            coefficients = ((SeqOps)some.get()).apply(1);
                            if (!(intercept instanceof Double)) break block5;
                            d = BoxesRunTime.unboxToDouble((Object)intercept);
                            if (coefficients instanceof Vector) break block6;
                        }
                        throw new MatchError((Object)row);
                    }
                    Vector vector = (Vector)coefficients;
                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)vector);
                    double intercept = tuple2._1$mcD$sp();
                    Vector coefficients2 = (Vector)tuple2._2();
                    linearRegressionModel = new LinearRegressionModel(metadata.uid(), coefficients2, intercept);
                    break block7;
                }
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearRegressionModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_LinearRegressionModel$LinearRegressionModelReader$$typecreator1$4
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.regression.LinearModelData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_LinearRegressionModel$LinearRegressionModelReader$$typecreator1$4(LinearRegressionModelReader $outer) {
                    }
                }
                LinearModelData data = (LinearModelData)ReadWriteUtils$.MODULE$.loadObject(dataPath, this.sparkSession(), (Function1 & Serializable)dis -> LinearModelData$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(LinearModelData.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionModel$LinearRegressionModelReader$$typecreator1$4(null)));
                linearRegressionModel = new LinearRegressionModel(metadata.uid(), data.coefficients(), data.intercept(), data.scale());
            }
            LinearRegressionModel model = linearRegressionModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }
}

