/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.VariantMetadata$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimeType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001B\u0011#\u0001EB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005s!AQ\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003:\u0011!y\u0004A!A!\u0002\u0013I\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u000b\u0005\u0003A\u0011\u0001\"\t\u000b\u0005\u0003A\u0011A&\t\u000b\u0005\u0003A\u0011\u0001+\t\u000bu\u0003A\u0011\u00010\t\u000b9\u0004A\u0011A8\t\u000fe\u0004\u0011\u0013!C\u0001u\"9\u00111\u0002\u0001\u0005\n\u00055\u0001\u0002CA\u0011\u0001E\u0005I\u0011\u0002>\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003\"CA.\u0001E\u0005I\u0011AA/\u0011\u001d\t\t\u0007\u0001C\u0005\u0003GB\u0011\"!\u001d\u0001#\u0003%I!!\u0018\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!I\u00111\u0010\u0001\u0012\u0002\u0013%\u0011Q\f\u0005\b\u0003{\u0002A\u0011BA@\u0011!\t\u0019\t\u0001C\u0001E\u0005\u0015u!CAKE\u0005\u0005\t\u0012AAL\r!\t#%!A\t\u0002\u0005e\u0005BB!\u001a\t\u0003\tY\nC\u0005\u0002\u001ef\t\n\u0011\"\u0001\u0002 \"I\u00111U\r\u0012\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003KK\u0012\u0013!C\u0001\u0003?C\u0011\"a*\u001a#\u0003%\t!a(\t\u0013\u0005%\u0016$%A\u0005\u0002\u0005}\u0005\"CAV3E\u0005I\u0011AAP\u0005u\u0001\u0016M]9vKR$vn\u00159be.\u001c6\r[3nC\u000e{gN^3si\u0016\u0014(BA\u0012%\u0003\u001d\u0001\u0018M]9vKRT!!\n\u0014\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003O!\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005%R\u0013aA:rY*\u00111\u0006L\u0001\u0006gB\f'o\u001b\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$AB!osJ+g-\u0001\u000bbgN,X.\u001a\"j]\u0006\u0014\u00180S:TiJLgn\u001a\t\u0003giJ!a\u000f\u001b\u0003\u000f\t{w\u000e\\3b]\u00061\u0012m]:v[\u0016Le\u000e^\u001d7\u0013N$\u0016.\\3ti\u0006l\u0007/A\u0007dCN,7+\u001a8tSRLg/Z\u0001\u0012S:4WM\u001d+j[\u0016\u001cH/Y7q\u001dRS\u0016a\u00038b]>\u001c\u0018i\u001d'p]\u001e\f!\"^:f\r&,G\u000eZ%e\u0003\u0019a\u0014N\\5u}Q91)\u0012$H\u0011&S\u0005C\u0001#\u0001\u001b\u0005\u0011\u0003b\u0002\u001d\b!\u0003\u0005\r!\u000f\u0005\by\u001d\u0001\n\u00111\u0001:\u0011\u001dit\u0001%AA\u0002eBqAP\u0004\u0011\u0002\u0003\u0007\u0011\bC\u0004@\u000fA\u0005\t\u0019A\u001d\t\u000f\u0001;\u0001\u0013!a\u0001sQ\u00111\t\u0014\u0005\u0006\u001b\"\u0001\rAT\u0001\u0005G>tg\r\u0005\u0002P%6\t\u0001K\u0003\u0002RQ\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002T!\n91+\u0015'D_:4GCA\"V\u0011\u0015i\u0015\u00021\u0001W!\t96,D\u0001Y\u0015\ti\u0015L\u0003\u0002[Y\u00051\u0001.\u00193p_BL!\u0001\u0018-\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u001d\u0019wN\u001c<feR$\"aX3\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\tD\u0013!\u0002;za\u0016\u001c\u0018B\u00013b\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006M*\u0001\raZ\u0001\u000ea\u0006\u0014\u0018/^3u'\u000eDW-\\1\u0011\u0005!dW\"A5\u000b\u0005)\\\u0017AB:dQ\u0016l\u0017M\u0003\u0002$Y%\u0011Q.\u001b\u0002\f\u001b\u0016\u001c8/Y4f)f\u0004X-\u0001\u000bd_:4XM\u001d;QCJ\fX/\u001a;D_2,XN\u001c\u000b\u0004aN$\bC\u0001#r\u0013\t\u0011(EA\u0007QCJ\fX/\u001a;D_2,XN\u001c\u0005\u0006M.\u0001\ra\u001a\u0005\bk.\u0001\n\u00111\u0001w\u0003=\u0019\b/\u0019:l%\u0016\fGmU2iK6\f\u0007cA\u001ax?&\u0011\u0001\u0010\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0002=\r|gN^3siB\u000b'/];fi\u000e{G.^7oI\u0011,g-Y;mi\u0012\u0012T#A>+\u0005Yd8&A?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0003i\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005%qPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqbY8om\u0016\u0014H/\u00138uKJt\u0017\r\u001c\u000b\u0006a\u0006=\u0011q\u0004\u0005\b\u0003#i\u0001\u0019AA\n\u0003-9'o\\;q\u0007>dW/\u001c8\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007l\u0003\tIw.\u0003\u0003\u0002\u001e\u0005]!!D$s_V\u00048i\u001c7v[:Lu\nC\u0004v\u001bA\u0005\t\u0019\u0001<\u00023\r|gN^3si&sG/\u001a:oC2$C-\u001a4bk2$HEM\u0001\u0013]>\u0014X.\u00197ju\u00164\u0015.\u001a7e\u001d\u0006lW\r\u0006\u0003\u0002(\u0005u\u0002\u0003BA\u0015\u0003oqA!a\u000b\u00024A\u0019\u0011Q\u0006\u001b\u000e\u0005\u0005=\"bAA\u0019a\u00051AH]8pizJ1!!\u000e5\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011HA\u001e\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0007\u001b\t\u000f\u0005}r\u00021\u0001\u0002(\u0005!a.Y7f\u00031\u0019wN\u001c<feR4\u0015.\u001a7e)\u0015\u0001\u0018QIA(\u0011\u001d\t9\u0005\u0005a\u0001\u0003\u0013\nQAZ5fY\u0012\u0004B!!\u0006\u0002L%!\u0011QJA\f\u0005!\u0019u\u000e\\;n]&{\u0005\"CA)!A\u0005\t\u0019AA*\u00035\u0019\b/\u0019:l%\u0016\fG\rV=qKB!1g^A+!\r\u0001\u0017qK\u0005\u0004\u00033\n'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002-\r|gN^3si\u001aKW\r\u001c3%I\u00164\u0017-\u001e7uII*\"!a\u0018+\u0007\u0005MC0A\u000bd_:4XM\u001d;Qe&l\u0017\u000e^5wK\u001aKW\r\u001c3\u0015\u000bA\f)'a\u001c\t\u000f\u0005\u001d$\u00031\u0001\u0002j\u0005y\u0001O]5nSRLg/Z\"pYVlg\u000e\u0005\u0003\u0002\u0016\u0005-\u0014\u0002BA7\u0003/\u0011\u0011\u0003\u0015:j[&$\u0018N^3D_2,XN\\%P\u0011%\t\tF\u0005I\u0001\u0002\u0004\t\u0019&A\u0010d_:4XM\u001d;Qe&l\u0017\u000e^5wK\u001aKW\r\u001c3%I\u00164\u0017-\u001e7uII\n\u0011cY8om\u0016\u0014Ho\u0012:pkB4\u0015.\u001a7e)\u0015\u0001\u0018qOA=\u0011\u001d\t\t\u0002\u0006a\u0001\u0003'A\u0011\"!\u0015\u0015!\u0003\u0005\r!a\u0015\u00027\r|gN^3si\u001e\u0013x.\u001e9GS\u0016dG\r\n3fM\u0006,H\u000e\u001e\u00133\u0003M\u0019wN\u001c<feR4\u0016M]5b]R4\u0015.\u001a7e)\r\u0001\u0018\u0011\u0011\u0005\b\u0003#1\u0002\u0019AA\n\u00035I7/\u00127f[\u0016tG\u000fV=qKR)\u0011(a\"\u0002\u0012\"9\u0011\u0011R\fA\u0002\u0005-\u0015\u0001\u0004:fa\u0016\fG/\u001a3UsB,\u0007c\u00015\u0002\u000e&\u0019\u0011qR5\u0003\tQK\b/\u001a\u0005\b\u0003';\u0002\u0019AA\u0014\u0003)\u0001\u0018M]3oi:\u000bW.Z\u0001\u001e!\u0006\u0014\u0018/^3u)>\u001c\u0006/\u0019:l'\u000eDW-\\1D_:4XM\u001d;feB\u0011A)G\n\u00033I\"\"!a&\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tK\u000b\u0002:y\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c")
public class ParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;
    private final boolean caseSensitive;
    private final boolean inferTimestampNTZ;
    private final boolean nanosAsLong;
    private final boolean useFieldId;

    public static boolean $lessinit$greater$default$6() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$5() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public StructType convert(MessageType parquetSchema) {
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(parquetSchema);
        ParquetColumn converted = this.convertInternal((GroupColumnIO)column, this.convertInternal$default$2());
        return (StructType)converted.sparkType();
    }

    public ParquetColumn convertParquetColumn(MessageType parquetSchema, Option<StructType> sparkReadSchema) {
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(parquetSchema);
        return this.convertInternal((GroupColumnIO)column, sparkReadSchema);
    }

    public Option<StructType> convertParquetColumn$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertInternal(GroupColumnIO groupColumn, Option<StructType> sparkReadSchema) {
        LazyRef schemaIdMapOpt$lzy = new LazyRef();
        Option schemaMapOpt = sparkReadSchema.map((Function1 & Serializable)schema -> ((IterableOnceOps)schema.map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.normalizeFieldName(f.name())), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        IndexedSeq converted = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), groupColumn.getChildrenCount()).map((Function1 & Serializable)i -> ParquetToSparkSchemaConverter.$anonfun$convertInternal$4(this, groupColumn, schemaMapOpt, schemaIdMapOpt$lzy, sparkReadSchema, BoxesRunTime.unboxToInt((Object)i)));
        return ParquetColumn$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)converted.map((Function1 & Serializable)x$4 -> (StructField)x$4._1())), groupColumn, (Seq<ParquetColumn>)((Seq)converted.map((Function1 & Serializable)x$5 -> (ParquetColumn)x$5._2())));
    }

    private Option<StructType> convertInternal$default$2() {
        return None$.MODULE$;
    }

    private String normalizeFieldName(String name) {
        if (this.caseSensitive) {
            return name;
        }
        return name.toLowerCase(Locale.ROOT);
    }

    public ParquetColumn convertField(ColumnIO field, Option<DataType> sparkReadType) {
        Option targetType = sparkReadType.map((Function1 & Serializable)x$6 -> x$6.transformRecursively((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends DataType, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof UserDefinedType) {
                    UserDefinedType userDefinedType = (UserDefinedType)A1;
                    return (B1)userDefinedType.sqlType();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(DataType x1) {
                DataType dataType = x1;
                return dataType instanceof UserDefinedType;
            }
        }));
        boolean bl = false;
        GroupColumnIO groupColumnIO = null;
        ColumnIO columnIO = field;
        if (columnIO instanceof PrimitiveColumnIO) {
            PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
            return this.convertPrimitiveField(primitiveColumnIO, (Option<DataType>)targetType);
        }
        if (columnIO instanceof GroupColumnIO) {
            bl = true;
            groupColumnIO = (GroupColumnIO)columnIO;
            if (targetType.contains((Object)VariantType$.MODULE$)) {
                if (BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.VARIANT_ALLOW_READING_SHREDDED()))) {
                    ParquetColumn col = this.convertGroupField(groupColumnIO, this.convertGroupField$default$2());
                    VariantType$ x$1 = VariantType$.MODULE$;
                    Some x$2 = new Some((Object)col);
                    Option<ColumnDescriptor> x$3 = col.copy$default$2();
                    int x$4 = col.copy$default$3();
                    int x$5 = col.copy$default$4();
                    boolean x$62 = col.copy$default$5();
                    Seq<String> x$7 = col.copy$default$6();
                    Seq<ParquetColumn> x$8 = col.copy$default$7();
                    return col.copy((DataType)x$1, x$3, x$4, x$5, x$62, x$7, x$8, (Option<ParquetColumn>)x$2);
                }
                return this.convertVariantField(groupColumnIO);
            }
        }
        if (bl && targetType.exists((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)VariantMetadata$.MODULE$.isVariantStruct(t)))) {
            ParquetColumn col = this.convertGroupField(groupColumnIO, this.convertGroupField$default$2());
            DataType x$9 = (DataType)targetType.get();
            Some x$10 = new Some((Object)col);
            Option<ColumnDescriptor> x$11 = col.copy$default$2();
            int x$12 = col.copy$default$3();
            int x$13 = col.copy$default$4();
            boolean x$14 = col.copy$default$5();
            Seq<String> x$15 = col.copy$default$6();
            Seq<ParquetColumn> x$16 = col.copy$default$7();
            return col.copy(x$9, x$11, x$12, x$13, x$14, x$15, x$16, (Option<ParquetColumn>)x$10);
        }
        if (bl) {
            return this.convertGroupField(groupColumnIO, (Option<DataType>)targetType);
        }
        throw new MatchError((Object)columnIO);
    }

    public Option<DataType> convertField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertPrimitiveField(PrimitiveColumnIO primitiveColumn, Option<DataType> sparkReadType) {
        PrimitiveType parquetType = primitiveColumn.getType().asPrimitiveType();
        LogicalTypeAnnotation typeAnnotation = primitiveColumn.getType().getLogicalTypeAnnotation();
        PrimitiveType.PrimitiveTypeName typeName = primitiveColumn.getPrimitive();
        DataType sparkType = (DataType)sparkReadType.getOrElse((Function0 & Serializable)() -> {
            PrimitiveType.PrimitiveTypeName primitiveTypeName;
            block53: {
                LogicalTypeAnnotation logicalTypeAnnotation;
                LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation;
                boolean bl;
                block54: {
                    block55: {
                        primitiveTypeName = typeName;
                        if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(primitiveTypeName)) {
                            return BooleanType$.MODULE$;
                        }
                        if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(primitiveTypeName)) {
                            return FloatType$.MODULE$;
                        }
                        if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(primitiveTypeName)) {
                            return DoubleType$.MODULE$;
                        }
                        if (PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) {
                            boolean bl2 = false;
                            LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalTypeAnnotation = null;
                            LogicalTypeAnnotation logicalTypeAnnotation2 = typeAnnotation;
                            if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                                bl2 = true;
                                intLogicalTypeAnnotation = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation2;
                                if (intLogicalTypeAnnotation.isSigned()) {
                                    int n = intLogicalTypeAnnotation.getBitWidth();
                                    switch (n) {
                                        case 8: {
                                            return ByteType$.MODULE$;
                                        }
                                        case 16: {
                                            return ShortType$.MODULE$;
                                        }
                                        case 32: {
                                            return IntegerType$.MODULE$;
                                        }
                                    }
                                    throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                                }
                            }
                            if (logicalTypeAnnotation2 == null) {
                                return IntegerType$.MODULE$;
                            }
                            if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                                return DateType$.MODULE$;
                            }
                            if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                                return ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), typeAnnotation, typeName);
                            }
                            if (bl2 && !intLogicalTypeAnnotation.isSigned()) {
                                int n = intLogicalTypeAnnotation.getBitWidth();
                                switch (n) {
                                    case 8: {
                                        return ShortType$.MODULE$;
                                    }
                                    case 16: {
                                        return IntegerType$.MODULE$;
                                    }
                                    case 32: {
                                        return LongType$.MODULE$;
                                    }
                                }
                                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                            }
                            if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                                LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation2 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation2;
                                LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalTypeAnnotation2.getUnit();
                                LogicalTypeAnnotation.TimeUnit timeUnit2 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                                if (!(timeUnit != null ? !timeUnit.equals(timeUnit2) : timeUnit2 != null)) {
                                    throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation, typeName);
                                }
                            }
                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                        }
                        if (!PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) break block53;
                        boolean bl3 = false;
                        LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalTypeAnnotation = null;
                        bl = false;
                        timestampLogicalTypeAnnotation = null;
                        logicalTypeAnnotation = typeAnnotation;
                        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                            bl3 = true;
                            intLogicalTypeAnnotation = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation;
                            if (intLogicalTypeAnnotation.isSigned()) {
                                int n = intLogicalTypeAnnotation.getBitWidth();
                                switch (n) {
                                    case 64: {
                                        return LongType$.MODULE$;
                                    }
                                }
                                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                            }
                        }
                        if (logicalTypeAnnotation == null) {
                            return LongType$.MODULE$;
                        }
                        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                            return ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), typeAnnotation, typeName);
                        }
                        if (bl3 && !intLogicalTypeAnnotation.isSigned()) {
                            int n = intLogicalTypeAnnotation.getBitWidth();
                            switch (n) {
                                case 64: {
                                    return new DecimalType(20, 0);
                                }
                            }
                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                        }
                        if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) break block54;
                        bl = true;
                        timestampLogicalTypeAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
                        LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalTypeAnnotation.getUnit();
                        LogicalTypeAnnotation.TimeUnit timeUnit3 = LogicalTypeAnnotation.TimeUnit.MICROS;
                        if (!(timeUnit == null ? timeUnit3 != null : !timeUnit.equals(timeUnit3))) break block55;
                        LogicalTypeAnnotation.TimeUnit timeUnit4 = timestampLogicalTypeAnnotation.getUnit();
                        LogicalTypeAnnotation.TimeUnit timeUnit5 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                        if (timeUnit4 != null ? !timeUnit4.equals(timeUnit5) : timeUnit5 != null) break block54;
                    }
                    if (timestampLogicalTypeAnnotation.isAdjustedToUTC() || !$this.inferTimestampNTZ) {
                        return TimestampType$.MODULE$;
                    }
                    return TimestampNTZType$.MODULE$;
                }
                if (bl) {
                    LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalTypeAnnotation.getUnit();
                    LogicalTypeAnnotation.TimeUnit timeUnit6 = LogicalTypeAnnotation.TimeUnit.NANOS;
                    if (!(timeUnit != null ? !timeUnit.equals(timeUnit6) : timeUnit6 != null) && $this.nanosAsLong) {
                        return LongType$.MODULE$;
                    }
                }
                if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
                    LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalTypeAnnotation = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)logicalTypeAnnotation;
                    LogicalTypeAnnotation.TimeUnit timeUnit = timeLogicalTypeAnnotation.getUnit();
                    LogicalTypeAnnotation.TimeUnit timeUnit7 = LogicalTypeAnnotation.TimeUnit.MICROS;
                    if (!(timeUnit != null ? !timeUnit.equals(timeUnit7) : timeUnit7 != null) && !timeLogicalTypeAnnotation.isAdjustedToUTC()) {
                        return new TimeType(TimeType$.MODULE$.MICROS_PRECISION());
                    }
                }
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
            if (PrimitiveType.PrimitiveTypeName.INT96.equals(primitiveTypeName)) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> $this.assumeInt96IsTimestamp, "INT96 is not supported unless it's interpreted as timestamp. Please try to set " + SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key() + " to true.");
                return TimestampType$.MODULE$;
            }
            if (PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) {
                boolean bl = false;
                LogicalTypeAnnotation logicalTypeAnnotation = null;
                LogicalTypeAnnotation logicalTypeAnnotation3 = typeAnnotation;
                if (logicalTypeAnnotation3 instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation ? true : (logicalTypeAnnotation3 instanceof LogicalTypeAnnotation.EnumLogicalTypeAnnotation ? true : logicalTypeAnnotation3 instanceof LogicalTypeAnnotation.JsonLogicalTypeAnnotation)) {
                    return StringType$.MODULE$;
                }
                if (logicalTypeAnnotation3 == null) {
                    bl = true;
                    logicalTypeAnnotation = logicalTypeAnnotation3;
                    if ($this.assumeBinaryIsString) {
                        return StringType$.MODULE$;
                    }
                }
                if (bl) {
                    return BinaryType$.MODULE$;
                }
                if (logicalTypeAnnotation3 instanceof LogicalTypeAnnotation.BsonLogicalTypeAnnotation) {
                    return BinaryType$.MODULE$;
                }
                if (logicalTypeAnnotation3 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    return ParquetToSparkSchemaConverter.makeDecimalType$1(ParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), typeAnnotation, typeName);
                }
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName)) {
                LogicalTypeAnnotation logicalTypeAnnotation = typeAnnotation;
                if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    return ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(parquetType.getTypeLength()), typeAnnotation, typeName);
                }
                if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntervalLogicalTypeAnnotation) {
                    throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation, typeName);
                }
                if (logicalTypeAnnotation == null) {
                    return BinaryType$.MODULE$;
                }
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
        });
        return ParquetColumn$.MODULE$.apply(sparkType, primitiveColumn);
    }

    private Option<DataType> convertPrimitiveField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertGroupField(GroupColumnIO groupColumn, Option<DataType> sparkReadType) {
        GroupType field = groupColumn.getType().asGroupType();
        return (ParquetColumn)Option$.MODULE$.apply((Object)field.getLogicalTypeAnnotation()).fold((Function0 & Serializable)() -> this.convertInternal(groupColumn, (Option<StructType>)sparkReadType.map((Function1 & Serializable)x$7 -> (StructType)x$7)), (Function1 & Serializable)x0$1 -> {
            LogicalTypeAnnotation logicalTypeAnnotation = x0$1;
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> field.getFieldCount() == 1, "Invalid list type " + field);
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> sparkReadType.forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ParquetToSparkSchemaConverter.$anonfun$convertGroupField$8(x$8))), "Invalid Spark read type: expected " + field + " to be list type but found " + sparkReadType);
                ColumnIO repeated = groupColumn.getChild(0);
                Type repeatedType = repeated.getType();
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), "Invalid list type " + field);
                Option sparkReadElementType = sparkReadType.map((Function1 & Serializable)x$9 -> ((ArrayType)x$9).elementType());
                if (this.isElementType(repeatedType, field.getName())) {
                    ParquetColumn converted = this.convertField(repeated, (Option<DataType>)sparkReadElementType);
                    DataType convertedType = ParquetToSparkSchemaConverter.getSparkTypeIfApplicable$1(sparkReadElementType, converted);
                    if (repeatedType.isPrimitive()) {
                        ParquetColumn qual$1 = converted;
                        boolean x$1 = true;
                        DataType x$2 = qual$1.copy$default$1();
                        Option<ColumnDescriptor> x$3 = qual$1.copy$default$2();
                        int x$4 = qual$1.copy$default$3();
                        int x$5 = qual$1.copy$default$4();
                        Seq<String> x$6 = qual$1.copy$default$6();
                        Seq<ParquetColumn> x$7 = qual$1.copy$default$7();
                        Option<ParquetColumn> x$8 = qual$1.copy$default$8();
                        converted = qual$1.copy(x$2, x$3, x$4, x$5, true, x$6, x$7, x$8);
                    }
                    return ParquetColumn$.MODULE$.apply((DataType)new ArrayType(convertedType, false), groupColumn, (Seq<ParquetColumn>)new .colon.colon((Object)converted, (List)Nil$.MODULE$));
                }
                ColumnIO element = ((GroupColumnIO)repeated).getChild(0);
                ParquetColumn converted = this.convertField(element, (Option<DataType>)sparkReadElementType);
                DataType convertedType = ParquetToSparkSchemaConverter.getSparkTypeIfApplicable$1(sparkReadElementType, converted);
                boolean optional = element.getType().isRepetition(Type.Repetition.OPTIONAL);
                return ParquetColumn$.MODULE$.apply((DataType)new ArrayType(convertedType, optional), groupColumn, (Seq<ParquetColumn>)new .colon.colon((Object)converted, (List)Nil$.MODULE$));
            }
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation ? true : logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapKeyValueTypeAnnotation) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), "Invalid map type: " + field);
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> sparkReadType.forall((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ParquetToSparkSchemaConverter.$anonfun$convertGroupField$13(x$10))), "Invalid Spark read type: expected " + field + " to be map type but found " + sparkReadType);
                GroupColumnIO keyValue = (GroupColumnIO)groupColumn.getChild(0);
                GroupType keyValueType = keyValue.getType().asGroupType();
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, "Invalid map type: " + field);
                ColumnIO key = keyValue.getChild(0);
                ColumnIO value = keyValue.getChild(1);
                Option sparkReadKeyType = sparkReadType.map((Function1 & Serializable)x$11 -> ((MapType)x$11).keyType());
                Option sparkReadValueType = sparkReadType.map((Function1 & Serializable)x$12 -> ((MapType)x$12).valueType());
                ParquetColumn convertedKey = this.convertField(key, (Option<DataType>)sparkReadKeyType);
                ParquetColumn convertedValue = this.convertField(value, (Option<DataType>)sparkReadValueType);
                DataType convertedKeyType = ParquetToSparkSchemaConverter.getSparkTypeIfApplicable$1(sparkReadKeyType, convertedKey);
                DataType convertedValueType = ParquetToSparkSchemaConverter.getSparkTypeIfApplicable$1(sparkReadValueType, convertedValue);
                boolean valueOptional = value.getType().isRepetition(Type.Repetition.OPTIONAL);
                return ParquetColumn$.MODULE$.apply((DataType)new MapType(convertedKeyType, convertedValueType, valueOptional), groupColumn, (Seq<ParquetColumn>)new .colon.colon((Object)convertedKey, (List)new .colon.colon((Object)convertedValue, (List)Nil$.MODULE$)));
            }
            throw QueryCompilationErrors$.MODULE$.unrecognizedParquetTypeError(field.toString());
        });
    }

    private Option<DataType> convertGroupField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertVariantField(GroupColumnIO groupColumn) {
        if (groupColumn.getChildrenCount() != 2) {
            throw QueryCompilationErrors$.MODULE$.invalidVariantWrongNumFieldsError();
        }
        Seq valueAndMetadata = (Seq)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"metadata", (List)Nil$.MODULE$)).map((Function1 & Serializable)colName -> {
            ColumnIO child;
            block5: {
                block4: {
                    Option idx = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), groupColumn.getChildrenCount()).find((Function1)(JFunction1.mcZI.sp & Serializable)x$13 -> {
                        String string = groupColumn.getChild(x$13).getName();
                        String string2 = colName;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    });
                    if (idx.isEmpty()) {
                        throw QueryCompilationErrors$.MODULE$.invalidVariantMissingFieldError(colName);
                    }
                    child = groupColumn.getChild(BoxesRunTime.unboxToInt((Object)idx.get()));
                    Type.Repetition repetition = child.getType().getRepetition();
                    Type.Repetition repetition2 = Type.Repetition.REQUIRED;
                    if ((repetition != null ? !repetition.equals(repetition2) : repetition2 != null) || !(child instanceof PrimitiveColumnIO)) break block4;
                    PrimitiveType.PrimitiveTypeName primitiveTypeName = ((PrimitiveColumnIO)child).getPrimitive();
                    PrimitiveType.PrimitiveTypeName primitiveTypeName2 = PrimitiveType.PrimitiveTypeName.BINARY;
                    if (!(primitiveTypeName == null ? primitiveTypeName2 != null : !primitiveTypeName.equals(primitiveTypeName2))) break block5;
                }
                throw QueryCompilationErrors$.MODULE$.invalidVariantNullableOrNotBinaryFieldError(colName);
            }
            return child;
        });
        return ParquetColumn$.MODULE$.apply((DataType)VariantType$.MODULE$, groupColumn, (Seq<ParquetColumn>)new .colon.colon((Object)this.convertField((ColumnIO)valueAndMetadata.apply(0), (Option<DataType>)new Some((Object)BinaryType$.MODULE$)), (List)new .colon.colon((Object)this.convertField((ColumnIO)valueAndMetadata.apply(1), (Option<DataType>)new Some((Object)BinaryType$.MODULE$)), (List)Nil$.MODULE$)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isElementType(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = parentName + "_tuple";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ Option $anonfun$convertInternal$3(StructField f) {
        if (ParquetUtils$.MODULE$.hasFieldId(f)) {
            return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)ParquetUtils$.MODULE$.getFieldId(f)), (Object)f));
        }
        return None$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ Option schemaIdMapOpt$lzycompute$1(LazyRef schemaIdMapOpt$lzy$1, Option sparkReadSchema$1) {
        var4_3 = schemaIdMapOpt$lzy$1;
        synchronized (var4_3) {
            block6: {
                block5: {
                    if (!schemaIdMapOpt$lzy$1.initialized()) break block5;
                    v0 = (Option)schemaIdMapOpt$lzy$1.value();
                    break block6;
                }
                var6_4 = sparkReadSchema$1;
                if (!(var6_4 instanceof Some)) ** GOTO lbl-1000
                var7_5 = (Some)var6_4;
                schema = (StructType)var7_5.value();
                if (this.useFieldId) {
                    v1 = new Some((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$convertInternal$3(org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Lscala/Option;)(), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                } else lbl-1000:
                // 2 sources

                {
                    v1 = None$.MODULE$;
                }
                v0 = (Option)schemaIdMapOpt$lzy$1.initialize((Object)v1);
            }
            var5_7 = v0;
        }
        return var5_7;
    }

    private final Option schemaIdMapOpt$1(LazyRef schemaIdMapOpt$lzy$1, Option sparkReadSchema$1) {
        if (schemaIdMapOpt$lzy$1.initialized()) {
            return (Option)schemaIdMapOpt$lzy$1.value();
        }
        return this.schemaIdMapOpt$lzycompute$1(schemaIdMapOpt$lzy$1, sparkReadSchema$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$convertInternal$4(ParquetToSparkSchemaConverter $this, GroupColumnIO groupColumn$1, Option schemaMapOpt$1, LazyRef schemaIdMapOpt$lzy$1, Option sparkReadSchema$1, int i) {
        ColumnIO field = groupColumn$1.getChild(i);
        Option fieldFromReadSchema = schemaMapOpt$1.flatMap((Function1 & Serializable)schemaMap -> schemaMap.get((Object)$this.normalizeFieldName(field.getName()))).orElse((Function0 & Serializable)() -> {
            Option parquetFieldId = Option$.MODULE$.apply((Object)field.getType().getId()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.intValue()));
            Tuple2 tuple2 = new Tuple2((Object)parquetFieldId, (Object)$this.schemaIdMapOpt$1(schemaIdMapOpt$lzy$1, sparkReadSchema$1));
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int id = BoxesRunTime.unboxToInt((Object)some.value());
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Map map = (Map)some2.value();
                        return map.get((Object)BoxesRunTime.boxToInteger((int)id));
                    }
                }
            }
            return None$.MODULE$;
        });
        Option fieldReadType = fieldFromReadSchema.map((Function1 & Serializable)x$2 -> x$2.dataType());
        Type.Repetition repetition = field.getType().getRepetition();
        Type.Repetition repetition2 = Type.Repetition.REPEATED;
        if (!(repetition != null ? !repetition.equals(repetition2) : repetition2 != null)) {
            fieldReadType = fieldReadType.flatMap((Function1 & Serializable)x0$1 -> {
                DataType dataType = x0$1;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    return new Some((Object)arrayType.elementType());
                }
                throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(groupColumn$1.toString());
            });
        }
        ParquetColumn convertedField = $this.convertField(field, (Option<DataType>)fieldReadType);
        String fieldName = (String)fieldFromReadSchema.map((Function1 & Serializable)x$3 -> x$3.name()).getOrElse((Function0 & Serializable)() -> field.getType().getName());
        Type.Repetition repetition3 = field.getType().getRepetition();
        if (Type.Repetition.OPTIONAL.equals(repetition3) ? true : Type.Repetition.REQUIRED.equals(repetition3)) {
            Type.Repetition repetition4 = field.getType().getRepetition();
            Type.Repetition repetition5 = Type.Repetition.OPTIONAL;
            boolean nullable = !(repetition4 != null ? !repetition4.equals(repetition5) : repetition5 != null);
            return new Tuple2((Object)new StructField(fieldName, convertedField.sparkType(), nullable, StructField$.MODULE$.apply$default$4()), (Object)convertedField);
        }
        if (Type.Repetition.REPEATED.equals(repetition3)) {
            ArrayType arrayType = new ArrayType(convertedField.sparkType(), false);
            boolean x$1 = true;
            DataType x$22 = convertedField.copy$default$1();
            Option<ColumnDescriptor> x$32 = convertedField.copy$default$2();
            int x$4 = convertedField.copy$default$3();
            int x$5 = convertedField.copy$default$4();
            Seq<String> x$6 = convertedField.copy$default$6();
            Seq<ParquetColumn> x$7 = convertedField.copy$default$7();
            Option<ParquetColumn> x$8 = convertedField.copy$default$8();
            return new Tuple2((Object)new StructField(fieldName, (DataType)arrayType, false, StructField$.MODULE$.apply$default$4()), (Object)new ParquetColumn((DataType)arrayType, (Option<ColumnDescriptor>)None$.MODULE$, convertedField.repetitionLevel() - 1, convertedField.definitionLevel() - 1, true, convertedField.path(), (Seq<ParquetColumn>)new .colon.colon((Object)convertedField.copy(x$22, x$32, x$4, x$5, true, x$6, x$7, x$8), (List)Nil$.MODULE$), ParquetColumn$.MODULE$.apply$default$8()));
        }
        throw new MatchError((Object)repetition3);
    }

    private static final String typeString$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        if (typeAnnotation$1 == null) {
            return String.valueOf(typeName$1);
        }
        return typeName$1 + " (" + typeAnnotation$1 + ")";
    }

    private static final Nothing$ typeNotImplemented$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.parquetTypeUnsupportedYetError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final Nothing$ illegalType$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation$1;
        int precision = decimalLogicalTypeAnnotation.getPrecision();
        int scale = decimalLogicalTypeAnnotation.getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, "Invalid decimal precision: " + typeName$1 + " cannot store " + precision + " digits (max " + maxPrecision + ")");
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    private static final DataType getSparkTypeIfApplicable$1(Option sparkReadType, ParquetColumn converted) {
        return (DataType)sparkReadType.filterNot((Function1 & Serializable)dataType -> BoxesRunTime.boxToBoolean((boolean)ParquetSchemaConverter$.MODULE$.isComplexType(dataType))).getOrElse((Function0 & Serializable)() -> converted.sparkType());
    }

    public static final /* synthetic */ boolean $anonfun$convertGroupField$8(DataType x$8) {
        return x$8 instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$convertGroupField$13(DataType x$10) {
        return x$10 instanceof MapType;
    }

    public ParquetToSparkSchemaConverter(boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp, boolean caseSensitive, boolean inferTimestampNTZ, boolean nanosAsLong, boolean useFieldId) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
        this.caseSensitive = caseSensitive;
        this.inferTimestampNTZ = inferTimestampNTZ;
        this.nanosAsLong = nanosAsLong;
        this.useFieldId = useFieldId;
    }

    public ParquetToSparkSchemaConverter(SQLConf conf) {
        this(conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp(), conf.caseSensitiveAnalysis(), conf.parquetInferTimestampNTZEnabled(), conf.legacyParquetNanosAsLong(), conf.parquetFieldIdReadEnabled());
    }

    public ParquetToSparkSchemaConverter(Configuration conf) {
        this(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.CASE_SENSITIVE().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key()))), conf.getBoolean(SQLConf$.MODULE$.PARQUET_FIELD_ID_READ_ENABLED().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.PARQUET_FIELD_ID_READ_ENABLED().defaultValue().get())));
    }
}

