/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.GeometryType$;
import org.json4s.JString;
import org.json4s.JValue;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001\u0002\u0011\"\u00011B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0003\")!\n\u0001C\u0005\u0017\"9a\n\u0001b\u0001\n\u0003y\u0005B\u0002+\u0001A\u0003%\u0001\u000bC\u0003V\u0001\u0011\u0005s\nC\u0003W\u0001\u0011\u0005q\u000bC\u0003\\\u0001\u0011\u0005\u0003\tC\u0003]\u0001\u0011\u0005S\fC\u0003_\u0001\u0011\u0005s\f\u0003\u0004n\u0001\u0011\u0005SE\u001c\u0005\u0006_\u0002!\t\u0005\u001d\u0005\u0006m\u0002!\te\u001e\u0005\u0007q\u0002!\teI=\t\r}\u0004A\u0011AA\u0001\u000f\u001d\t)\"\tE\u0001\u0003/1a\u0001I\u0011\t\u0002\u0005e\u0001B\u0002&\u0012\t\u0003\t)\u0004C\u0005\u00028E\u0011\r\u0011\"\u0002\u0002:!A\u0011qH\t!\u0002\u001b\tY\u0004C\u0005\u0002BE\u0011\r\u0011\"\u0002\u0002D!A\u00111J\t!\u0002\u001b\t)\u0005\u0003\u0005\u0002NE\u0011\r\u0011\"\u0004o\u0011\u001d\ty%\u0005Q\u0001\u000e1Cq!!\u0015\u0012\t\u0003\t\u0019\u0006C\u0004\u0002RE!\t!a\u0016\t\u0011\u0005m\u0013\u0003\"\u0011$\u0003;Bq\u0001_\t\u0005B\r\ny\u0006C\u0004\u0002dE!\te\t!\t\u0011\u0005\u0015\u0014\u0003\"\u0001\"\u0003OB\u0011\"a\u001b\u0012\u0003\u0003%I!!\u001c\u0003\u0019\u001d+w.\\3uef$\u0016\u0010]3\u000b\u0005\t\u001a\u0013!\u0002;za\u0016\u001c(B\u0001\u0013&\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003M\u001d\nQa\u001d9be.T!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO\u000e\u00011c\u0001\u0001.cA\u0011afL\u0007\u0002C%\u0011\u0001'\t\u0002\u000b\u0003R|W.[2UsB,\u0007C\u0001\u001a=\u001d\t\u0019\u0014H\u0004\u00025o5\tQG\u0003\u00027W\u00051AH]8pizJ\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003um\nq\u0001]1dW\u0006<WMC\u00019\u0013\tidH\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002;w\u0005\u00191M]:\u0016\u0003\u0005\u0003\"A\u0011$\u000f\u0005\r#\u0005C\u0001\u001b<\u0013\t)5(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000f\"\u0013aa\u0015;sS:<'BA#<\u0003\u0011\u0019'o\u001d\u0011\u0002\rqJg.\u001b;?)\taU\n\u0005\u0002/\u0001!)qh\u0001a\u0001\u0003\u0006!1O]5e+\u0005\u0001\u0006CA)S\u001b\u0005Y\u0014BA*<\u0005\rIe\u000e^\u0001\u0006gJLG\rI\u0001\fI\u00164\u0017-\u001e7u'&TX-A\u0006jg6K\u00070\u001a3Te&$W#\u0001-\u0011\u0005EK\u0016B\u0001.<\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0002^=qK:\u000bW.Z\u0001\ti>\u001cFO]5oOR\t\u0011)A\u0005kg>tg+\u00197vKV\t\u0001\r\u0005\u0002bU:\u0011!m\u001a\b\u0003G\u0016t!\u0001\u000e3\n\u0003)J!AZ\u0015\u0002\r)\u001cxN\u001c\u001bt\u0013\tA\u0017.A\u0004Kg>t\u0017i\u0015+\u000b\u0005\u0019L\u0013BA6m\u0005\u0019Qe+\u00197vK*\u0011\u0001.[\u0001\u000bCNtU\u000f\u001c7bE2,W#\u0001'\u0002\r\u0015\fX/\u00197t)\tA\u0016\u000fC\u0003s\u0019\u0001\u00071/A\u0002pE*\u0004\"!\u0015;\n\u0005U\\$aA!os\u0006A\u0001.Y:i\u0007>$W\rF\u0001Q\u0003-\t7mY3qiN$\u0016\u0010]3\u0015\u0005aS\b\"B>\u000f\u0001\u0004a\u0018!B8uQ\u0016\u0014\bC\u0001\u0018~\u0013\tq\u0018E\u0001\u0005ECR\fG+\u001f9f\u0003M\t7mY3qiN<Um\\7fiJLH+\u001f9f)\rA\u00161\u0001\u0005\u0007\u0003\u000by\u0001\u0019\u0001'\u0002\u0005\u001d$\bf\u0001\u0001\u0002\nA!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010\u0015\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019\"!\u0004\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\u0002\u0019\u001d+w.\\3uef$\u0016\u0010]3\u0011\u00059\n2cB\t\u0002\u001c\u0005\u0005\u0012q\u0005\t\u0004]\u0005u\u0011bAA\u0010C\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/\u001a\t\u0004]\u0005\r\u0012bAA\u0013C\tY1\u000b]1uS\u0006dG+\u001f9f!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t!![8\u000b\u0005\u0005E\u0012\u0001\u00026bm\u0006L1!PA\u0016)\t\t9\"A\u000bH\u000b>kU\t\u0016*Z?\u0012+e)Q+M)~\u001b&+\u0013#\u0016\u0005\u0005mrBAA\u001f;\t\u0001b=\u0001\fH\u000b>kU\t\u0016*Z?\u0012+e)Q+M)~\u001b&+\u0013#!\u0003Q9UiT'F)JKv\fR#G\u0003VcEkX\"S'V\u0011\u0011QI\b\u0003\u0003\u000f\n#!!\u0013\u0002\u0013=;5IO\"S'b\"\u0014!F$F\u001f6+EKU-`\t\u00163\u0015)\u0016'U?\u000e\u00136\u000bI\u0001\u0014\u000f\u0016{U*\u0012+S3~k\u0015\nW#E?RK\u0006+R\u0001\u0015\u000f\u0016{U*\u0012+S3~k\u0015\nW#E?RK\u0006+\u0012\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00071\u000b)\u0006C\u0003O3\u0001\u0007\u0001\u000bF\u0002M\u00033BQa\u0010\u000eA\u0002\u0005\u000b1\u0003Z3gCVdGoQ8oGJ,G/\u001a+za\u0016,\u0012\u0001 \u000b\u00041\u0006\u0005\u0004\"B>\u001d\u0001\u0004a\u0018\u0001D:j[BdWm\u0015;sS:<\u0017A\u0002;p'JLG\rF\u0002Q\u0003SBQa\u0010\u0010A\u0002\u0005\u000bAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a\u001c\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gRA!!\u001e\u00020\u0005!A.\u00198h\u0013\u0011\tI(a\u001d\u0003\r=\u0013'.Z2uQ\r\t\u0012\u0011\u0002\u0015\u0004!\u0005%\u0001")
public class GeometryType
extends AtomicType
implements Serializable {
    private final String crs;
    private final int srid;

    public static GeometryType apply(String crs) {
        return GeometryType$.MODULE$.apply(crs);
    }

    public static GeometryType apply(int srid) {
        return GeometryType$.MODULE$.apply(srid);
    }

    public static String GEOMETRY_DEFAULT_CRS() {
        return GeometryType$.MODULE$.GEOMETRY_DEFAULT_CRS();
    }

    public static int GEOMETRY_DEFAULT_SRID() {
        return GeometryType$.MODULE$.GEOMETRY_DEFAULT_SRID();
    }

    public static String MIXED_CRS() {
        return GeometryType$.MODULE$.MIXED_CRS();
    }

    public static int MIXED_SRID() {
        return GeometryType$.MODULE$.MIXED_SRID();
    }

    public String crs() {
        return this.crs;
    }

    public int srid() {
        return this.srid;
    }

    @Override
    public int defaultSize() {
        return 2048;
    }

    public boolean isMixedSrid() {
        return this.srid() == GeometryType$.MODULE$.MIXED_SRID();
    }

    @Override
    public String typeName() {
        if (this.isMixedSrid()) {
            return "geometry(any)";
        }
        return "geometry(" + this.srid() + ")";
    }

    public String toString() {
        if (this.isMixedSrid()) {
            return "GeometryType(ANY)";
        }
        return "GeometryType(" + this.srid() + ")";
    }

    @Override
    public JValue jsonValue() {
        return new JString("geometry(" + this.crs() + ")");
    }

    @Override
    public GeometryType asNullable() {
        return this;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof GeometryType) {
            GeometryType geometryType = (GeometryType)object;
            return geometryType.srid() == this.srid();
        }
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.srid());
    }

    @Override
    public boolean acceptsType(DataType other) {
        DataType dataType = other;
        if (dataType instanceof GeometryType) {
            GeometryType geometryType = (GeometryType)dataType;
            return this.acceptsGeometryType(geometryType);
        }
        return false;
    }

    public boolean acceptsGeometryType(GeometryType gt) {
        return this.isMixedSrid() || gt.srid() == this.srid();
    }

    public GeometryType(String crs) {
        this.crs = crs;
        this.srid = GeometryType$.MODULE$.toSrid(crs);
    }
}

