/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is greater than or equal to `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       true\n      > SELECT 2.0 _FUNC_ '2.1';\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       false\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001B\u000e\u001d\u0001&B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\"Aa\t\u0001BK\u0002\u0013\u0005\u0011\t\u0003\u0005H\u0001\tE\t\u0015!\u0003C\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015a\u0006\u0001\"\u0015^\u0011\u0015)\u0007\u0001\"\u0015g\u0011\u001dY\u0007!!A\u0005\u00021Dqa\u001c\u0001\u0012\u0002\u0013\u0005\u0001\u000fC\u0004|\u0001E\u0005I\u0011\u00019\t\u000fq\u0004\u0011\u0011!C!{\"I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/A\u0011\"!\b\u0001\u0003\u0003%\t%a\b\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0002\"CA\u001a\u0001\u0005\u0005I\u0011IA\u001b\u0011%\tI\u0004AA\u0001\n\u0003\nYdB\u0005\u0002fq\t\t\u0011#\u0001\u0002h\u0019A1\u0004HA\u0001\u0012\u0003\tI\u0007\u0003\u0004I+\u0011\u0005\u0011\u0011\u0011\u0005\n\u0003\u0007+\u0012\u0011!C#\u0003\u000bC\u0011\"a\"\u0016\u0003\u0003%\t)!#\t\u0013\u0005=U#!A\u0005\u0002\u0006E\u0005\"CAR+\u0005\u0005I\u0011BAS\u0005I9%/Z1uKJ$\u0006.\u00198Pe\u0016\u000bX/\u00197\u000b\u0005uq\u0012aC3yaJ,7o]5p]NT!a\b\u0011\u0002\u0011\r\fG/\u00197zgRT!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0016/iA\u00111\u0006L\u0007\u00029%\u0011Q\u0006\b\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:\u0004\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00026{9\u0011ag\u000f\b\u0003oij\u0011\u0001\u000f\u0006\u0003s!\na\u0001\u0010:p_Rt\u0014\"A\u0019\n\u0005q\u0002\u0014a\u00029bG.\fw-Z\u0005\u0003}}\u0012AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0010\u0019\u0002\t1,g\r^\u000b\u0002\u0005B\u00111fQ\u0005\u0003\tr\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2AS&M!\tY\u0003\u0001C\u0003A\u000b\u0001\u0007!\tC\u0003G\u000b\u0001\u0007!)\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0016\u0003=\u0003\"a\f)\n\u0005E\u0003$a\u0002\"p_2,\u0017M\\\u0001\u0007gfl'm\u001c7\u0016\u0003Q\u0003\"!V-\u000f\u0005Y;\u0006CA\u001c1\u0013\tA\u0006'\u0001\u0004Qe\u0016$WMZ\u0005\u00035n\u0013aa\u0015;sS:<'B\u0001-1\u00031qW\u000f\u001c7TC\u001a,WI^1m)\rq\u0016m\u0019\t\u0003_}K!\u0001\u0019\u0019\u0003\u0007\u0005s\u0017\u0010C\u0003c\u0011\u0001\u0007a,\u0001\u0004j]B,H/\r\u0005\u0006I\"\u0001\rAX\u0001\u0007S:\u0004X\u000f\u001e\u001a\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u0001&hS\")\u0001.\u0003a\u0001\u0005\u00069a.Z<MK\u001a$\b\"\u00026\n\u0001\u0004\u0011\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0004\u00156t\u0007b\u0002!\u000b!\u0003\u0005\rA\u0011\u0005\b\r*\u0001\n\u00111\u0001C\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u001d\u0016\u0003\u0005J\\\u0013a\u001d\t\u0003ifl\u0011!\u001e\u0006\u0003m^\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005a\u0004\u0014AC1o]>$\u0018\r^5p]&\u0011!0\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003y\u00042a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001\u00027b]\u001eT!!a\u0002\u0002\t)\fg/Y\u0005\u00045\u0006\u0005\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\b!\ry\u0013\u0011C\u0005\u0004\u0003'\u0001$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00010\u0002\u001a!I\u00111D\b\u0002\u0002\u0003\u0007\u0011qB\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0002#BA\u0012\u0003SqVBAA\u0013\u0015\r\t9\u0003M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0016\u0003K\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019q*!\r\t\u0011\u0005m\u0011#!AA\u0002y\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u0019a0a\u000e\t\u0013\u0005m!#!AA\u0002\u0005=\u0011AB3rk\u0006d7\u000fF\u0002P\u0003{A\u0001\"a\u0007\u0014\u0003\u0003\u0005\rA\u0018\u0015\u0018\u0001\u0005\u0005\u0013qIA%\u0003\u001b\ny%a\u0015\u0002V\u0005e\u00131LA0\u0003C\u00022aKA\"\u0013\r\t)\u0005\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tY%A)fqB\u0014\u0018\u0007I0G+:\u001bu\fI3yaJ\u0014\u0004%\f\u0011SKR,(O\\:!iJ,X\rI5gA\u0001,\u0007\u0010\u001d:2A\u0002J7\u000fI4sK\u0006$XM\u001d\u0011uQ\u0006t\u0007e\u001c:!KF,\u0018\r\u001c\u0011u_\u0002\u0002W\r\u001f9se\u0001t\u0013!C1sOVlWM\u001c;tC\t\t\t&\u0001BJ\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002S\r\u001f9sc1\u0002S\r\u001f9se\u0001j\u0003\u0005\u001e5fAQ<x\u000eI3yaJ,7o]5p]N\u0004S.^:uA\t,\u0007e]1nK\u0002\"\u0018\u0010]3!_J\u00043-\u00198!E\u0016\u00043-Y:uK\u0012\u0004Co\u001c\u0011bA\r|W.\\8oAQL\b/\u001a\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013M\u001c3![V\u001cH\u000f\t2fA\u0005\u0004C/\u001f9fAQD\u0017\r\u001e\u0011dC:\u0004#-\u001a\u0011pe\u0012,'/\u001a3/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017![\u0006\u0004\b\u0005^=qK\u0002J7\u000f\t8pi\u0002z'\u000fZ3sC\ndW\r\f\u0011t_\u0002JGO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A%\u001c\bE\\8uAM,\b\u000f]8si\u0016$g\u0006\t$pe\u0002\u001aw.\u001c9mKb\u0004C/\u001f9fg\u0002\u001aXo\u00195!CJ\u0014\u0018-_\u0018tiJ,8\r\u001e\u0017!i\",\u0007\u0005Z1uC\u0002\"\u0018\u0010]3tA=4\u0007EZ5fY\u0012\u001c\b%\\;ti*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t2fA=\u0014H-\u001a:bE2,gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA,\u0003\t\u001d&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t\u001a!?\u001a+fjQ0!cmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012d\u0006\r\u0011`\rVs5i\u0018\u0011(e9\nte\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011gC2\u001cXM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011u_~#\u0017\r^3)OI\u0002\u0004'O\u00171o5\u001a\u0004\u0007\t\u00195uE:$(\u000e\u001a(S\u0001zf)\u0016(D?\u0002\"xn\u00183bi\u0016DsE\r\u00191s5\u0002t'L\u001a1AA\"$(M\u001c;kI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t;p?\u0012\fG/\u001a\u0015(eA\u0002\u0014(\f\u00198[M\u0002\u0004\u0005\r\u001b;c]RTGM\u0014*A}3UKT\"`AQ|w\fZ1uK\":#\u0007\r\u0019:[ABT\u0006M\u0019!aQR\u0014g\u000e\u001e6e\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t4bYN,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0019!?\u001a+fjQ0!\u001dVcEj\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005u\u0013!B\u0019/a9\u0002\u0014!B4s_V\u0004\u0018EAA2\u0003=\u0001(/\u001a3jG\u0006$Xm\u00184v]\u000e\u001c\u0018AE$sK\u0006$XM\u001d+iC:|%/R9vC2\u0004\"aK\u000b\u0014\u000bU\tY'a\u001e\u0011\u000f\u00055\u00141\u000f\"C\u00156\u0011\u0011q\u000e\u0006\u0004\u0003c\u0002\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003k\nyGA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0005\u0003{\n)!\u0001\u0002j_&\u0019a(a\u001f\u0015\u0005\u0005\u001d\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003y\fQ!\u00199qYf$RASAF\u0003\u001bCQ\u0001\u0011\rA\u0002\tCQA\u0012\rA\u0002\t\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0014\u0006}\u0005#B\u0018\u0002\u0016\u0006e\u0015bAALa\t1q\n\u001d;j_:\u0004RaLAN\u0005\nK1!!(1\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011U\r\u0002\u0002\u0003\u0007!*A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a*\u0011\u0007}\fI+\u0003\u0003\u0002,\u0006\u0005!AB(cU\u0016\u001cG\u000f")
public class GreaterThanOrEqual
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(GreaterThanOrEqual x$0) {
        return GreaterThanOrEqual$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, GreaterThanOrEqual> tupled() {
        return GreaterThanOrEqual$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GreaterThanOrEqual>> curried() {
        return GreaterThanOrEqual$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public String symbol() {
        return ">=";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().gteq(input1, input2));
    }

    @Override
    public GreaterThanOrEqual withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public GreaterThanOrEqual copy(Expression left, Expression right) {
        return new GreaterThanOrEqual(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "GreaterThanOrEqual";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GreaterThanOrEqual;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GreaterThanOrEqual)) return false;
        boolean bl = true;
        if (!bl) return false;
        GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)x$1;
        Expression expression = this.left();
        Expression expression2 = greaterThanOrEqual.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = greaterThanOrEqual.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!greaterThanOrEqual.canEqual(this)) return false;
        return true;
    }

    public GreaterThanOrEqual(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

