/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.KllSketchGetQuantileBase;
import org.apache.spark.sql.catalyst.expressions.KllSketchGetQuantileBigint$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="\n    _FUNC_(left, right) - Extracts a single value from the quantiles sketch representing the\n    desired quantile given the input rank. The desired quantile can either be a single value\n    or an array. In the latter case, the function will return an array of results of equal\n    length to the input array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(kll_sketch_agg_bigint(col), 0.5) > 1 FROM VALUES (1), (2), (3), (4), (5) tab(col);\n       true\n  ", group="misc_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001\u0002\u000f\u001e\u0001*B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015I\b\u0001\"\u0011{\u0011%\t)\u0001AA\u0001\n\u0003\t9\u0001C\u0005\u0002\u000e\u0001\t\n\u0011\"\u0001\u0002\u0010!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003O\u0001\u0011\u0011!C!\u0003SA\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0003\"CA&\u0001\u0005\u0005I\u0011IA'\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j!I\u0011Q\u000e\u0001\u0002\u0002\u0013\u0005\u0013qN\u0004\n\u0003'k\u0012\u0011!E\u0001\u0003+3\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011q\u0013\u0005\u0007\u0013Z!\t!a,\t\u0013\u0005Ef#!A\u0005F\u0005M\u0006\"CA[-\u0005\u0005I\u0011QA\\\u0011%\tiLFA\u0001\n\u0003\u000by\fC\u0005\u0002RZ\t\t\u0011\"\u0003\u0002T\nQ2\n\u001c7TW\u0016$8\r[$fiF+\u0018M\u001c;jY\u0016\u0014\u0015nZ5oi*\u0011adH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002!C\u0005A1-\u0019;bYf\u001cHO\u0003\u0002#G\u0005\u00191/\u001d7\u000b\u0005\u0011*\u0013!B:qCJ\\'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001W=*\u0004C\u0001\u0017.\u001b\u0005i\u0012B\u0001\u0018\u001e\u0005aYE\u000e\\*lKR\u001c\u0007nR3u#V\fg\u000e^5mK\n\u000b7/\u001a\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\b!J|G-^2u!\t1dH\u0004\u00028y9\u0011\u0001hO\u0007\u0002s)\u0011!(K\u0001\u0007yI|w\u000e\u001e \n\u0003IJ!!P\u0019\u0002\u000fA\f7m[1hK&\u0011q\b\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003{E\nA\u0001\\3giV\t1\t\u0005\u0002-\t&\u0011Q)\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u00172k\u0005C\u0001\u0017\u0001\u0011\u0015\tU\u00011\u0001D\u0011\u00159U\u00011\u0001D\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002D!JCQ!\u0015\u0004A\u0002\r\u000bqA\\3x\u0019\u00164G\u000fC\u0003T\r\u0001\u00071)\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002-B\u0011qk\u0017\b\u00031f\u0003\"\u0001O\u0019\n\u0005i\u000b\u0014A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!AW\u0019\u0002\u001d=,H\u000f];u\t\u0006$\u0018\rV=qKV\t\u0001\r\u0005\u0002bI6\t!M\u0003\u0002dC\u0005)A/\u001f9fg&\u0011QM\u0019\u0002\t\t\u0006$\u0018\rV=qK\u0006!2\u000e\u001c7TW\u0016$8\r[$fiF+\u0018M\u001c;jY\u0016$2\u0001[6u!\t\u0001\u0014.\u0003\u0002kc\t\u0019\u0011I\\=\t\u000b1L\u0001\u0019A7\u0002\r5,Wn\u001c:z!\tq'/D\u0001p\u0015\ta\u0007O\u0003\u0002rK\u0005aA-\u0019;bg.,Go\u00195fg&\u00111o\u001c\u0002\u0007\u001b\u0016lwN]=\t\u000bUL\u0001\u0019\u0001<\u0002\tI\fgn\u001b\t\u0003a]L!\u0001_\u0019\u0003\r\u0011{WO\u00197f\u0003UYG\u000e\\*lKR\u001c\u0007nR3u#V\fg\u000e^5mKN$2a\u001f@\u0000!\r\u0001D\u0010[\u0005\u0003{F\u0012Q!\u0011:sCfDQ\u0001\u001c\u0006A\u00025Dq!!\u0001\u000b\u0001\u0004\t\u0019!A\u0003sC:\\7\u000fE\u00021yZ\fAaY8qsR)1*!\u0003\u0002\f!9\u0011i\u0003I\u0001\u0002\u0004\u0019\u0005bB$\f!\u0003\u0005\raQ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tBK\u0002D\u0003'Y#!!\u0006\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?\t\u0014AC1o]>$\u0018\r^5p]&!\u00111EA\r\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0012\u0001\u00026bm\u0006L1\u0001XA\u0018\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0004E\u00021\u0003\u007fI1!!\u00112\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rA\u0017q\t\u0005\n\u0003\u0013\u0002\u0012\u0011!a\u0001\u0003{\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA(!\u0015\t\t&a\u0016i\u001b\t\t\u0019FC\u0002\u0002VE\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI&a\u0015\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003?\n)\u0007E\u00021\u0003CJ1!a\u00192\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0013\u0013\u0003\u0003\u0005\r\u0001[\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002,\u0005-\u0004\"CA%'\u0005\u0005\t\u0019AA\u001f\u0003\u0019)\u0017/^1mgR!\u0011qLA9\u0011!\tI\u0005FA\u0001\u0002\u0004A\u0007f\u0005\u0001\u0002v\u0005m\u0014QPAA\u0003\u0007\u000b9)!#\u0002\u000e\u0006=\u0005c\u0001\u0017\u0002x%\u0019\u0011\u0011P\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qP\u0001\u0003p)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015mK\u001a$H\u0006\t:jO\"$\u0018\u0006I\u0017!\u000bb$(/Y2ug\u0002\n\u0007e]5oO2,\u0007E^1mk\u0016\u0004cM]8nAQDW\rI9vC:$\u0018\u000e\\3tAM\\W\r^2iAI,\u0007O]3tK:$\u0018N\\4!i\",'\u0002\t\u0011!A\u0011,7/\u001b:fI\u0002\nX/\u00198uS2,\u0007eZ5wK:\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011sC:\\g\u0006\t+iK\u0002\"Wm]5sK\u0012\u0004\u0013/^1oi&dW\rI2b]\u0002*\u0017\u000e\u001e5fe\u0002\u0012W\rI1!g&tw\r\\3!m\u0006dW/\u001a\u0006!A\u0001\u0002sN\u001d\u0011b]\u0002\n'O]1z]\u0001Je\u000e\t;iK\u0002b\u0017\r\u001e;fe\u0002\u001a\u0017m]3-AQDW\r\t4v]\u000e$\u0018n\u001c8!o&dG\u000e\t:fiV\u0014h\u000eI1oA\u0005\u0014(/Y=!_\u001a\u0004#/Z:vYR\u001c\be\u001c4!KF,\u0018\r\u001c\u0006!A\u0001\u0002C.\u001a8hi\"\u0004Co\u001c\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002\n'O]1z])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t))AA\u0007\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"ZG\u000e\\0tW\u0016$8\r[0bO\u001e|&-[4j]RD3m\u001c7*Y\u0001\u0002d&N\u0015!}\u0001\n\u0004E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013'\u000b\u0017!QIJC\u0006\t\u00154S1\u0002\u0003\u0006N\u0015-A!*\u0014\u0006\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0005)qM]8va\u0006\u0012\u00111R\u0001\u000b[&\u001c8m\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAI\u0003\u0015!d&\r\u00181\u0003iYE\u000e\\*lKR\u001c\u0007nR3u#V\fg\u000e^5mK\nKw-\u001b8u!\taccE\u0003\u0017\u00033\u000b)\u000bE\u0004\u0002\u001c\u0006\u00056iQ&\u000e\u0005\u0005u%bAAPc\u00059!/\u001e8uS6,\u0017\u0002BAR\u0003;\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\t9+!,\u000e\u0005\u0005%&\u0002BAV\u0003g\t!![8\n\u0007}\nI\u000b\u0006\u0002\u0002\u0016\u0006AAo\\*ue&tw\r\u0006\u0002\u0002,\u0005)\u0011\r\u001d9msR)1*!/\u0002<\")\u0011)\u0007a\u0001\u0007\")q)\u0007a\u0001\u0007\u00069QO\\1qa2LH\u0003BAa\u0003\u001b\u0004R\u0001MAb\u0003\u000fL1!!22\u0005\u0019y\u0005\u000f^5p]B)\u0001'!3D\u0007&\u0019\u00111Z\u0019\u0003\rQ+\b\u000f\\33\u0011!\tyMGA\u0001\u0002\u0004Y\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q\u001b\t\u0005\u0003[\t9.\u0003\u0003\u0002Z\u0006=\"AB(cU\u0016\u001cG\u000f")
public class KllSketchGetQuantileBigint
extends KllSketchGetQuantileBase
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(KllSketchGetQuantileBigint x$0) {
        return KllSketchGetQuantileBigint$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, KllSketchGetQuantileBigint> tupled() {
        return KllSketchGetQuantileBigint$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, KllSketchGetQuantileBigint>> curried() {
        return KllSketchGetQuantileBigint$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public String prettyName() {
        return "kll_sketch_get_quantile_bigint";
    }

    @Override
    public DataType outputDataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Object kllSketchGetQuantile(Memory memory, double rank) {
        return this.withQuantileErrorHandling(rank, (JFunction0.mcJ.sp & Serializable)() -> KllLongsSketch.wrap((Memory)memory).getQuantile(rank));
    }

    @Override
    public Object[] kllSketchGetQuantiles(Memory memory, double[] ranks) {
        return (Object[])this.withQuantileErrorHandling(ranks.length > 0 ? ranks[0] : 0.0, (Function0 & Serializable)() -> (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(KllLongsSketch.wrap((Memory)memory).getQuantiles(ranks)), (Function1 & Serializable)x$1 -> KllSketchGetQuantileBigint.$anonfun$kllSketchGetQuantiles$2(BoxesRunTime.unboxToLong((Object)x$1)), ClassTag$.MODULE$.Any()));
    }

    public KllSketchGetQuantileBigint copy(Expression left, Expression right) {
        return new KllSketchGetQuantileBigint(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "KllSketchGetQuantileBigint";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KllSketchGetQuantileBigint;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KllSketchGetQuantileBigint)) return false;
        boolean bl = true;
        if (!bl) return false;
        KllSketchGetQuantileBigint kllSketchGetQuantileBigint = (KllSketchGetQuantileBigint)x$1;
        Expression expression = this.left();
        Expression expression2 = kllSketchGetQuantileBigint.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = kllSketchGetQuantileBigint.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!kllSketchGetQuantileBigint.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ Object $anonfun$kllSketchGetQuantiles$2(long x$1) {
        return BoxesRunTime.boxToLong((long)x$1);
    }

    public KllSketchGetQuantileBigint(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

