/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.PadExpressionBuilderBase;
import org.apache.spark.sql.catalyst.expressions.StringLPad;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;

@ExpressionDescription(usage="\n    _FUNC_(str, len[, pad]) - Returns `str`, left-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters or bytes.\n      If `pad` is not specified, `str` will be padded to the left with space characters if it is\n      a character string, and with zeros if it is a byte sequence.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       ???hi\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n      > SELECT _FUNC_('hi', 5);\n          hi\n      > SELECT hex(_FUNC_(unhex('aabb'), 5));\n       000000AABB\n      > SELECT hex(_FUNC_(unhex('aabb'), 5, unhex('1122')));\n       112211AABB\n  ", since="1.5.0", group="string_funcs")
public final class LPadExpressionBuilder$
implements PadExpressionBuilderBase {
    public static final LPadExpressionBuilder$ MODULE$ = new LPadExpressionBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
        PadExpressionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        return PadExpressionBuilderBase.build$(this, funcName, expressions);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName, resolver);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public Expression createStringPad(Expression str, Expression len, Expression pad) {
        return new StringLPad(str, len, pad);
    }

    private LPadExpressionBuilder$() {
    }
}

