/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryBoundsException;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.spark.sql.errors.QueryExecutionErrors$;

public final class ThetaSketchUtils$ {
    public static final ThetaSketchUtils$ MODULE$ = new ThetaSketchUtils$();

    public final int MIN_LG_NOM_LONGS() {
        return 4;
    }

    public final int MAX_LG_NOM_LONGS() {
        return 26;
    }

    public final int DEFAULT_LG_NOM_LONGS() {
        return 12;
    }

    public void checkLgNomLongs(int lgNomLongs, String prettyName) {
        if (lgNomLongs < 4 || lgNomLongs > 26) {
            throw QueryExecutionErrors$.MODULE$.thetaInvalidLgNomEntries(prettyName, 4, 26, lgNomLongs);
        }
    }

    public CompactSketch wrapCompactSketch(byte[] bytes, String prettyName) {
        CompactSketch compactSketch;
        Memory memory;
        try {
            memory = Memory.wrap((byte[])bytes);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NullPointerException ? true : throwable2 instanceof MemoryBoundsException) {
                throw QueryExecutionErrors$.MODULE$.thetaInvalidInputSketchBuffer(prettyName);
            }
            throw throwable;
        }
        Memory memory2 = memory;
        try {
            compactSketch = CompactSketch.wrap((Memory)memory2);
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (throwable3 instanceof SketchesArgumentException ? true : throwable3 instanceof MemoryBoundsException) {
                throw QueryExecutionErrors$.MODULE$.thetaInvalidInputSketchBuffer(prettyName);
            }
            throw throwable;
        }
        return compactSketch;
    }

    private ThetaSketchUtils$() {
    }
}

