/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.LogBlockId;
import org.apache.spark.storage.LogBlockIdGenerator;
import org.apache.spark.storage.LogBlockWriter;
import org.apache.spark.storage.LogLine;
import org.apache.spark.storage.RollingLogWriter$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db!\u0002\r\u001a\u0001m\t\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011Q\u0002!\u0011!Q\u0001\nUB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\u0006y\u0001!\t!\u0010\u0005\b\u0005\u0002\u0001\r\u0011\"\u0003D\u0011\u001dQ\u0005\u00011A\u0005\n-Ca!\u0015\u0001!B\u0013!\u0005b\u0002*\u0001\u0001\u0004%Ia\u0015\u0005\b)\u0002\u0001\r\u0011\"\u0003V\u0011\u00199\u0006\u0001)Q\u0005s!9\u0001\f\u0001b\u0001\n\u0013I\u0006B\u00027\u0001A\u0003%!\fC\u0003n\u0001\u0011%a\u000eC\u0003s\u0001\u0011\u00051\u000fC\u0004|\u0001E\u0005I\u0011\u0001?\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u00111\u0003\u0001\u0005\u0002\u0005E\u0001\u0002CA\u000b\u0001\u0011\u0005\u0011$!\u0005\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u0012\u001dQ\u0011\u0011D\r\u0002\u0002#\u00051$a\u0007\u0007\u0013aI\u0012\u0011!E\u00017\u0005u\u0001B\u0002\u001f\u0016\t\u0003\ty\u0002C\u0005\u0002\"U\t\n\u0011\"\u0001\u0002$\t\u0001\"k\u001c7mS:<Gj\\4Xe&$XM\u001d\u0006\u00035m\tqa\u001d;pe\u0006<WM\u0003\u0002\u001d;\u0005)1\u000f]1sW*\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h'\r\u0001!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-Z\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u00055R#a\u0002'pO\u001eLgnZ\u0001\rE2|7m['b]\u0006<WM]\u0002\u0001!\t\t$'D\u0001\u001a\u0013\t\u0019\u0014D\u0001\u0007CY>\u001c7.T1oC\u001e,'/\u0001\tcY>\u001c7.\u00133HK:,'/\u0019;peB\u0011\u0011GN\u0005\u0003oe\u00111\u0003T8h\u00052|7m[%e\u000f\u0016tWM]1u_J\f1B]8mY&twmU5{KB\u00111EO\u0005\u0003w\u0011\u0012A\u0001T8oO\u00061A(\u001b8jiz\"BAP A\u0003B\u0011\u0011\u0007\u0001\u0005\u0006]\u0011\u0001\r\u0001\r\u0005\u0006i\u0011\u0001\r!\u000e\u0005\bq\u0011\u0001\n\u00111\u0001:\u0003I\u0019WO\u001d:f]R\u0014En\\2l/JLG/\u001a:\u0016\u0003\u0011\u00032aI#H\u0013\t1EE\u0001\u0004PaRLwN\u001c\t\u0003c!K!!S\r\u0003\u001d1{wM\u00117pG.<&/\u001b;fe\u000612-\u001e:sK:$(\t\\8dW^\u0013\u0018\u000e^3s?\u0012*\u0017\u000f\u0006\u0002M\u001fB\u00111%T\u0005\u0003\u001d\u0012\u0012A!\u00168ji\"9\u0001KBA\u0001\u0002\u0004!\u0015a\u0001=%c\u0005\u00192-\u001e:sK:$(\t\\8dW^\u0013\u0018\u000e^3sA\u0005YA.Y:u\u0019><G+[7f+\u0005I\u0014a\u00047bgRdun\u001a+j[\u0016|F%Z9\u0015\u000513\u0006b\u0002)\n\u0003\u0003\u0005\r!O\u0001\rY\u0006\u001cH\u000fT8h)&lW\rI\u0001\rY><'\t\\8dWRK\b/Z\u000b\u00025B\u00111,\u001b\b\u00039\u001et!!\u00184\u000f\u0005y+gBA0e\u001d\t\u00017-D\u0001b\u0015\t\u0011w&\u0001\u0004=e>|GOP\u0005\u0002A%\u0011adH\u0005\u00039uI!AG\u000e\n\u0005!L\u0012\u0001\u0004'pO\ncwnY6UsB,\u0017B\u00016l\u00051aun\u001a\"m_\u000e\\G+\u001f9f\u0015\tA\u0017$A\u0007m_\u001e\u0014En\\2l)f\u0004X\rI\u0001\u000fg\"|W\u000f\u001c3S_2dwJ^3s+\u0005y\u0007CA\u0012q\u0013\t\tHEA\u0004C_>dW-\u00198\u0002\u0011]\u0014\u0018\u000e^3M_\u001e$2\u0001\u0014;z\u0011\u0015)h\u00021\u0001w\u0003!awnZ#oiJL\bCA\u0019x\u0013\tA\u0018DA\u0004M_\u001ed\u0015N\\3\t\u000fit\u0001\u0013!a\u0001_\u00061\"/Z7pm\u0016\u0014En\\2l\u001f:,\u0005pY3qi&|g.\u0001\nxe&$X\rT8hI\u0011,g-Y;mi\u0012\u0012T#A?+\u0005=t8&A@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013!\u0013AC1o]>$\u0018\r^5p]&!\u0011QBA\u0002\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\te>dGn\u0014<feR\tA*A\u0003dY>\u001cX-A\u0003gYV\u001c\b.\u0001\ttCZ,7)\u001e:sK:$(\t\\8dW\u0006\u0001\"k\u001c7mS:<Gj\\4Xe&$XM\u001d\t\u0003cU\u0019\"!\u0006\u0012\u0015\u0005\u0005m\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002&)\u0012\u0011H ")
public class RollingLogWriter
implements Logging {
    private final BlockManager blockManager;
    private final LogBlockIdGenerator blockIdGenerator;
    private final long rollingSize;
    private Option<LogBlockWriter> currentBlockWriter;
    private long lastLogTime;
    private final Enumeration.Value logBlockType;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long $lessinit$greater$default$3() {
        return RollingLogWriter$.MODULE$.$lessinit$greater$default$3();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<LogBlockWriter> currentBlockWriter() {
        return this.currentBlockWriter;
    }

    private void currentBlockWriter_$eq(Option<LogBlockWriter> x$1) {
        this.currentBlockWriter = x$1;
    }

    private long lastLogTime() {
        return this.lastLogTime;
    }

    private void lastLogTime_$eq(long x$1) {
        this.lastLogTime = x$1;
    }

    private Enumeration.Value logBlockType() {
        return this.logBlockType;
    }

    private boolean shouldRollOver() {
        Option<LogBlockWriter> option = this.currentBlockWriter();
        if (option instanceof Some) {
            Some some = (Some)option;
            LogBlockWriter writer = (LogBlockWriter)some.value();
            return (long)writer.bytesWritten() >= this.rollingSize;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    public void writeLog(LogLine logEntry, boolean removeBlockOnException) {
        if (this.currentBlockWriter().isEmpty()) {
            this.currentBlockWriter_$eq((Option<LogBlockWriter>)new Some((Object)this.blockManager.getLogBlockWriter(this.logBlockType())));
        }
        try {
            this.currentBlockWriter().foreach((Function1 & Serializable)writer -> {
                RollingLogWriter.$anonfun$writeLog$1(this, logEntry, writer);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            if (removeBlockOnException) {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write log, closing block without saving."}))).log((Seq)Nil$.MODULE$)), (Throwable)e);
                this.currentBlockWriter().foreach((Function1 & Serializable)x$1 -> {
                    x$1.close();
                    return BoxedUnit.UNIT;
                });
                this.currentBlockWriter_$eq((Option<LogBlockWriter>)None$.MODULE$);
            }
            throw e;
        }
        if (this.shouldRollOver()) {
            this.rollOver();
            return;
        }
    }

    public boolean writeLog$default$2() {
        return false;
    }

    public void rollOver() {
        try {
            this.saveCurrentBlock();
        }
        finally {
            this.currentBlockWriter_$eq((Option<LogBlockWriter>)None$.MODULE$);
        }
    }

    public void close() {
        try {
            this.saveCurrentBlock();
        }
        finally {
            this.currentBlockWriter_$eq((Option<LogBlockWriter>)None$.MODULE$);
            this.lastLogTime_$eq(0L);
        }
    }

    public void flush() {
        this.currentBlockWriter().foreach((Function1 & Serializable)x$2 -> {
            x$2.flush();
            return BoxedUnit.UNIT;
        });
    }

    private void saveCurrentBlock() {
        this.currentBlockWriter().foreach((Function1 & Serializable)writer -> {
            RollingLogWriter.$anonfun$saveCurrentBlock$1(this, writer);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeLog$1(RollingLogWriter $this, LogLine logEntry$1, LogBlockWriter writer) {
        writer.writeLog(logEntry$1);
        $this.lastLogTime_$eq(logEntry$1.eventTime());
    }

    public static final /* synthetic */ void $anonfun$saveCurrentBlock$1(RollingLogWriter $this, LogBlockWriter writer) {
        LogBlockId blockId = $this.blockIdGenerator.nextBlockId($this.lastLogTime(), $this.blockManager.executorId());
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Saving log block ", " with "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.BLOCK_ID, blockId)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"approximate size: ", " bytes."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.BYTE_SIZE, BoxesRunTime.boxToInteger((int)writer.bytesWritten()))})))));
        writer.save(blockId);
    }

    public RollingLogWriter(BlockManager blockManager, LogBlockIdGenerator blockIdGenerator, long rollingSize) {
        this.blockManager = blockManager;
        this.blockIdGenerator = blockIdGenerator;
        this.rollingSize = rollingSize;
        Logging.$init$((Logging)this);
        this.currentBlockWriter = None$.MODULE$;
        this.lastLogTime = 0L;
        this.logBlockType = blockIdGenerator.logBlockType();
    }
}

