/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CuckooSetBytes;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IStringInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class FilterStringColumnInList
extends VectorExpression
implements IStringInExpr {
    private static final long serialVersionUID = 1L;
    private int inputCol;
    private byte[][] inListValues;
    private transient CuckooSetBytes inSet;

    public FilterStringColumnInList() {
        this.inSet = null;
    }

    public FilterStringColumnInList(int colNum) {
        this.inputCol = colNum;
        this.inSet = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        if (this.inSet == null) {
            this.inSet = new CuckooSetBytes(this.inListValues.length);
            this.inSet.load(this.inListValues);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.inputCol];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] start = inputColVector.start;
        int[] len = inputColVector.length;
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (!this.inSet.lookup(vector[0], start[0], len[0])) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!this.inSet.lookup(vector[i], start[i], len[i])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (!this.inSet.lookup(vector[i], start[i], len[i])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (!this.inSet.lookup(vector[0], start[0], len[0])) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos[i] || !this.inSet.lookup(vector[i], start[i], len[i])) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || !this.inSet.lookup(vector[i], start[i], len[i])) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    public void setInputColumn(int inputCol) {
        this.inputCol = inputCol;
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    public byte[][] getInListValues() {
        return this.inListValues;
    }

    @Override
    public void setInListValues(byte[][] a) {
        this.inListValues = a;
    }

    @Override
    public String vectorExpressionParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append("col ");
        sb.append(this.inputCol);
        sb.append(", values ");
        sb.append(FilterStringColumnInList.displayArrayOfUtf8ByteArrays(this.inListValues));
        return sb.toString();
    }
}

