/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.util.HashSet;
import java.util.List;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.GeographyType;
import org.apache.spark.sql.types.GeographyType$;
import org.apache.spark.sql.types.GeometryType;
import org.apache.spark.sql.types.GeometryType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;

@Stable
public class DataTypes {
    public static final DataType StringType = StringType$.MODULE$;
    public static final DataType BinaryType = BinaryType$.MODULE$;
    public static final DataType BooleanType = BooleanType$.MODULE$;
    public static final DataType DateType = DateType$.MODULE$;
    public static final DataType TimestampType = TimestampType$.MODULE$;
    public static final DataType TimestampNTZType = TimestampNTZType$.MODULE$;
    public static final DataType CalendarIntervalType = CalendarIntervalType$.MODULE$;
    public static final DataType DoubleType = DoubleType$.MODULE$;
    public static final DataType FloatType = FloatType$.MODULE$;
    public static final DataType ByteType = ByteType$.MODULE$;
    public static final DataType IntegerType = IntegerType$.MODULE$;
    public static final DataType LongType = LongType$.MODULE$;
    public static final DataType ShortType = ShortType$.MODULE$;
    public static final DataType NullType = NullType$.MODULE$;
    public static final DataType VariantType = VariantType$.MODULE$;

    public static GeographyType createGeographyType(int srid) {
        return GeographyType$.MODULE$.apply(srid);
    }

    public static GeographyType createGeographyType(String crs) {
        return GeographyType$.MODULE$.apply(crs);
    }

    public static GeometryType createGeometryType(int srid) {
        return GeometryType$.MODULE$.apply(srid);
    }

    public static GeometryType createGeometryType(String crs) {
        return GeometryType$.MODULE$.apply(crs);
    }

    public static ArrayType createArrayType(DataType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException("elementType should not be null.");
        }
        return new ArrayType(elementType, true);
    }

    public static ArrayType createArrayType(DataType elementType, boolean containsNull) {
        if (elementType == null) {
            throw new IllegalArgumentException("elementType should not be null.");
        }
        return new ArrayType(elementType, containsNull);
    }

    public static DecimalType createDecimalType(int precision, int scale) {
        return DecimalType$.MODULE$.apply(precision, scale);
    }

    public static DecimalType createDecimalType() {
        return DecimalType$.MODULE$.USER_DEFAULT();
    }

    public static DayTimeIntervalType createDayTimeIntervalType(byte startField, byte endField) {
        return DayTimeIntervalType$.MODULE$.apply(startField, endField);
    }

    public static DayTimeIntervalType createDayTimeIntervalType() {
        return DayTimeIntervalType$.MODULE$.DEFAULT();
    }

    public static YearMonthIntervalType createYearMonthIntervalType(byte startField, byte endField) {
        return YearMonthIntervalType$.MODULE$.apply(startField, endField);
    }

    public static YearMonthIntervalType createYearMonthIntervalType() {
        return YearMonthIntervalType$.MODULE$.DEFAULT();
    }

    public static MapType createMapType(DataType keyType, DataType valueType) {
        if (keyType == null) {
            throw new IllegalArgumentException("keyType should not be null.");
        }
        if (valueType == null) {
            throw new IllegalArgumentException("valueType should not be null.");
        }
        return new MapType(keyType, valueType, true);
    }

    public static MapType createMapType(DataType keyType, DataType valueType, boolean valueContainsNull) {
        if (keyType == null) {
            throw new IllegalArgumentException("keyType should not be null.");
        }
        if (valueType == null) {
            throw new IllegalArgumentException("valueType should not be null.");
        }
        return new MapType(keyType, valueType, valueContainsNull);
    }

    public static StructField createStructField(String name, DataType dataType, boolean nullable, Metadata metadata) {
        if (name == null) {
            throw new IllegalArgumentException("name should not be null.");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("dataType should not be null.");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("metadata should not be null.");
        }
        return new StructField(name, dataType, nullable, metadata);
    }

    public static StructField createStructField(String name, DataType dataType, boolean nullable) {
        return DataTypes.createStructField(name, dataType, nullable, new MetadataBuilder().build());
    }

    public static StructType createStructType(List<StructField> fields) {
        return DataTypes.createStructType(fields.toArray(new StructField[fields.size()]));
    }

    public static StructType createStructType(StructField[] fields) {
        if (fields == null) {
            throw new IllegalArgumentException("fields should not be null.");
        }
        HashSet<String> distinctNames = new HashSet<String>();
        for (StructField field : fields) {
            if (field == null) {
                throw new IllegalArgumentException("fields should not contain any null.");
            }
            distinctNames.add(field.name());
        }
        if (distinctNames.size() != fields.length) {
            throw new IllegalArgumentException("fields should have distinct names.");
        }
        return StructType$.MODULE$.apply(fields);
    }

    public static CharType createCharType(int length) {
        return new CharType(length);
    }

    public static VarcharType createVarcharType(int length) {
        return new VarcharType(length);
    }
}

