/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.Serializable;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.python.BaseSliceArrowOutputProcessor;
import scala.Function1;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0005E3Aa\u0002\u0005\u0001+!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!a\u0004A!A!\u0002\u0013i\u0004\"B!\u0001\t\u0003\u0011\u0005\"B$\u0001\t#B\u0005\"B'\u0001\t\u0013q%AI*mS\u000e,')\u001f;fg\u0006\u0013(o\\<PkR\u0004X\u000f\u001e)s_\u000e,7o]8s\u00136\u0004HN\u0003\u0002\n\u0015\u00051\u0001/\u001f;i_:T!a\u0003\u0007\u0002\u0013\u0015DXmY;uS>t'BA\u0007\u000f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001fA\tQa\u001d9be.T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\u0002$D\u0001\t\u0013\tI\u0002BA\u000fCCN,7\u000b\\5dK\u0006\u0013(o\\<PkR\u0004X\u000f\u001e)s_\u000e,7o]8s\u0003\u0019\u0011X-\u00193feB\u0011AdI\u0007\u0002;)\u0011adH\u0001\u0004SB\u001c'B\u0001\u0011\"\u0003\u00191Xm\u0019;pe*\u0011!\u0005E\u0001\u0006CJ\u0014xn^\u0005\u0003Iu\u0011\u0011#\u0011:s_^\u001cFO]3b[J+\u0017\rZ3s\u00035\u0001\u0018\u0010\u001e5p]6+GO]5dgB!q\u0005M\u001a7\u001d\tAc\u0006\u0005\u0002*Y5\t!F\u0003\u0002,)\u00051AH]8pizR\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\na\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\ri\u0015\r\u001d\u0006\u0003_1\u0002\"a\n\u001b\n\u0005U\u0012$AB*ue&tw\r\u0005\u00028u5\t\u0001H\u0003\u0002:\u0015\u00051Q.\u001a;sS\u000eL!a\u000f\u001d\u0003\u0013M\u000bF*T3ue&\u001c\u0017aG1se><X*\u0019=CsR,7\u000fU3s\u001fV$\b/\u001e;CCR\u001c\u0007\u000e\u0005\u0002?\u007f5\tA&\u0003\u0002AY\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\u0011\u0019E)\u0012$\u0011\u0005]\u0001\u0001\"\u0002\u000e\u0005\u0001\u0004Y\u0002\"B\u0013\u0005\u0001\u00041\u0003\"\u0002\u001f\u0005\u0001\u0004i\u0014aB4fiJ{w\u000e^\u000b\u0002\u0013B\u0011!jS\u0007\u0002?%\u0011Aj\b\u0002\u0011-\u0016\u001cGo\u001c:TG\",W.\u0019*p_R\fQbZ3u\u0005\u0006$8\r\u001b\"zi\u0016\u001cHCA\u001fP\u0011\u0015\u0001f\u00011\u0001J\u0003\u0011\u0011xn\u001c;")
public class SliceBytesArrowOutputProcessorImpl
extends BaseSliceArrowOutputProcessor {
    private final int arrowMaxBytesPerOutputBatch;

    @Override
    public VectorSchemaRoot getRoot() {
        if (this.getBatchBytes(this.root()) < this.arrowMaxBytesPerOutputBatch) {
            this.currentRowIdx_$eq(this.currentRowIdx() + this.root().getRowCount());
            return this.root();
        }
        VectorSchemaRoot rootSlice = this.root();
        double stepRatio = 0.9;
        int sliceBatchCount = this.rowCount() - this.currentRowIdx();
        while (sliceBatchCount > 0) {
            rootSlice = this.root().slice(this.currentRowIdx(), sliceBatchCount);
            int batchBytes = this.getBatchBytes(rootSlice);
            if (batchBytes < this.arrowMaxBytesPerOutputBatch) {
                this.currentRowIdx_$eq(this.currentRowIdx() + rootSlice.getRowCount());
                return rootSlice;
            }
            rootSlice.close();
            sliceBatchCount = (int)((double)sliceBatchCount * stepRatio);
        }
        if (sliceBatchCount == 0) {
            sliceBatchCount = 1;
        }
        rootSlice = this.root().slice(this.currentRowIdx(), sliceBatchCount);
        this.currentRowIdx_$eq(this.currentRowIdx() + rootSlice.getRowCount());
        return rootSlice;
    }

    private int getBatchBytes(VectorSchemaRoot root) {
        IntRef batchBytes = IntRef.create((int)0);
        CollectionConverters$.MODULE$.ListHasAsScala(root.getFieldVectors()).asScala().foreach((Function1 & Serializable)vector -> {
            SliceBytesArrowOutputProcessorImpl.$anonfun$getBatchBytes$1(batchBytes, vector);
            return BoxedUnit.UNIT;
        });
        return batchBytes.elem;
    }

    public static final /* synthetic */ void $anonfun$getBatchBytes$1(IntRef batchBytes$1, FieldVector vector) {
        batchBytes$1.elem += vector.getBufferSize();
    }

    public SliceBytesArrowOutputProcessorImpl(ArrowStreamReader reader, Map<String, SQLMetric> pythonMetrics, int arrowMaxBytesPerOutputBatch) {
        this.arrowMaxBytesPerOutputBatch = arrowMaxBytesPerOutputBatch;
        super(reader, pythonMetrics);
    }
}

