/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileNameSpec;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.sinks.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.sinks.SinkFileStatus;
import org.apache.spark.sql.execution.streaming.sinks.SinkFileStatus$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u000e\u001c\u0001!B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\t\")Q\n\u0001C\u0001\u001d\"I1\u000b\u0001a\u0001\u0002\u0004%I\u0001\u0016\u0005\n;\u0002\u0001\r\u00111A\u0005\nyC\u0011\"\u001a\u0001A\u0002\u0003\u0005\u000b\u0015B+\t\u0013)\u0004\u0001\u0019!a\u0001\n\u0013Y\u0007\"\u0003:\u0001\u0001\u0004\u0005\r\u0011\"\u0003t\u0011%)\b\u00011A\u0001B\u0003&A\u000eC\u0005x\u0001\u0001\u0007\t\u0019!C\u0005q\"IA\u0010\u0001a\u0001\u0002\u0004%I! \u0005\n\u007f\u0002\u0001\r\u0011!Q!\neD1\"!\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0004!Y\u0011q\u0003\u0001A\u0002\u0003\u0007I\u0011BA\r\u0011-\ti\u0002\u0001a\u0001\u0002\u0003\u0006K!!\u0002\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\t)\b\u0001C!\u0003oBq!! \u0001\t\u0003\ny\bC\u0004\u0002\f\u0002!\t%!$\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u0011\u0011\u0017\u0001\u0005B\u0005M\u0006bBA\\\u0001\u0011\u0005\u0013\u0011\u0018\u0002\u001b\u001b\u0006t\u0017NZ3ti\u001aKG.Z\"p[6LG\u000f\u0015:pi>\u001cw\u000e\u001c\u0006\u00039u\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005yy\u0012!C3yK\u000e,H/[8o\u0015\t\u0001\u0013%A\u0002tc2T!AI\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011&M \u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013AA5p\u0015\tq\u0013%\u0001\u0005j]R,'O\\1m\u0013\t\u00014F\u0001\nGS2,7i\\7nSR\u0004&o\u001c;pG>d\u0007C\u0001\u001a=\u001d\t\u0019\u0014H\u0004\u00025o5\tQG\u0003\u00027O\u00051AH]8pizJ\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003um\nq\u0001]1dW\u0006<WMC\u00019\u0013\tidH\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002;wA\u0011\u0001)Q\u0007\u0002[%\u0011!)\f\u0002\b\u0019><w-\u001b8h\u0003\u0015QwNY%e!\t)\u0015J\u0004\u0002G\u000fB\u0011AgO\u0005\u0003\u0011n\na\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001jO\u0001\u0005a\u0006$\b.\u0001\u0004=S:LGO\u0010\u000b\u0004\u001fF\u0013\u0006C\u0001)\u0001\u001b\u0005Y\u0002\"B\"\u0004\u0001\u0004!\u0005\"\u0002'\u0004\u0001\u0004!\u0015AC1eI\u0016$g)\u001b7fgV\tQ\u000bE\u0002W7\u0012k\u0011a\u0016\u0006\u00031f\u000bq!\\;uC\ndWM\u0003\u0002[w\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005q;&aC!se\u0006L()\u001e4gKJ\fa\"\u00193eK\u00124\u0015\u000e\\3t?\u0012*\u0017\u000f\u0006\u0002`GB\u0011\u0001-Y\u0007\u0002w%\u0011!m\u000f\u0002\u0005+:LG\u000fC\u0004e\u000b\u0005\u0005\t\u0019A+\u0002\u0007a$\u0013'A\u0006bI\u0012,GMR5mKN\u0004\u0003F\u0001\u0004h!\t\u0001\u0007.\u0003\u0002jw\tIAO]1og&,g\u000e^\u0001\bM&dW\rT8h+\u0005a\u0007CA7q\u001b\u0005q'BA8\u001c\u0003\u0015\u0019\u0018N\\6t\u0013\t\thNA\tGS2,7\u000b\u001e:fC6\u001c\u0016N\\6M_\u001e\f1BZ5mK2{wm\u0018\u0013fcR\u0011q\f\u001e\u0005\bI\"\t\t\u00111\u0001m\u0003!1\u0017\u000e\\3M_\u001e\u0004\u0003FA\u0005h\u0003\u001d\u0011\u0017\r^2i\u0013\u0012,\u0012!\u001f\t\u0003AjL!a_\u001e\u0003\t1{gnZ\u0001\fE\u0006$8\r[%e?\u0012*\u0017\u000f\u0006\u0002`}\"9AmCA\u0001\u0002\u0004I\u0018\u0001\u00032bi\u000eD\u0017\n\u001a\u0011\u0002%A,g\u000eZ5oO\u000e{W.\\5u\r&dWm]\u000b\u0003\u0003\u000b\u0001BAV.\u0002\bA!\u0011\u0011BA\n\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011A\u00014t\u0015\r\t\tbI\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005U\u00111\u0002\u0002\u0005!\u0006$\b.\u0001\fqK:$\u0017N\\4D_6l\u0017\u000e\u001e$jY\u0016\u001cx\fJ3r)\ry\u00161\u0004\u0005\tI:\t\t\u00111\u0001\u0002\u0006\u0005\u0019\u0002/\u001a8eS:<7i\\7nSR4\u0015\u000e\\3tA!\u0012qbZ\u0001\u0015g\u0016$X\u000f]'b]&4Wm\u001d;PaRLwN\\:\u0015\u000b}\u000b)#a\n\t\u000b)\u0004\u0002\u0019\u00017\t\u000b]\u0004\u0002\u0019A=\u0002\u0011M,G/\u001e9K_\n$2aXA\u0017\u0011\u001d\ty#\u0005a\u0001\u0003c\t!B[8c\u0007>tG/\u001a=u!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"\u0002BA\u001c\u0003\u001f\t\u0011\"\\1qe\u0016$WoY3\n\t\u0005m\u0012Q\u0007\u0002\u000b\u0015>\u00147i\u001c8uKb$\u0018!C2p[6LGOS8c)\u0015y\u0016\u0011IA\"\u0011\u001d\tyC\u0005a\u0001\u0003cAq!!\u0012\u0013\u0001\u0004\t9%A\u0006uCN\\7i\\7nSR\u001c\b#\u0002\u001a\u0002J\u00055\u0013bAA&}\t\u00191+Z9\u0011\t\u0005=\u0013\u0011\u000e\b\u0005\u0003#\n)G\u0004\u0003\u0002T\u0005\rd\u0002BA+\u0003CrA!a\u0016\u0002`9!\u0011\u0011LA/\u001d\r!\u00141L\u0005\u0002M%\u0011A%J\u0005\u0003E\rJ!AL\u0011\n\u00051j\u0013bAA4W\u0005\u0011b)\u001b7f\u0007>lW.\u001b;Qe>$xnY8m\u0013\u0011\tY'!\u001c\u0003#Q\u000b7o[\"p[6LG/T3tg\u0006<WMC\u0002\u0002h-\n\u0001\"\u00192peRTuN\u0019\u000b\u0004?\u0006M\u0004bBA\u0018'\u0001\u0007\u0011\u0011G\u0001\r_:$\u0016m]6D_6l\u0017\u000e\u001e\u000b\u0004?\u0006e\u0004bBA>)\u0001\u0007\u0011QJ\u0001\u000bi\u0006\u001c8nQ8n[&$\u0018!C:fiV\u0004H+Y:l)\ry\u0016\u0011\u0011\u0005\b\u0003\u0007+\u0002\u0019AAC\u0003-!\u0018m]6D_:$X\r\u001f;\u0011\t\u0005M\u0012qQ\u0005\u0005\u0003\u0013\u000b)D\u0001\nUCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$\u0018a\u00048foR\u000b7o\u001b+f[B4\u0015\u000e\\3\u0015\u000f\u0011\u000by)!%\u0002\u001c\"9\u00111\u0011\fA\u0002\u0005\u0015\u0005bBAJ-\u0001\u0007\u0011QS\u0001\u0004I&\u0014\b\u0003\u00021\u0002\u0018\u0012K1!!'<\u0005\u0019y\u0005\u000f^5p]\"9\u0011Q\u0014\fA\u0002\u0005}\u0015\u0001B:qK\u000e\u00042AKAQ\u0013\r\t\u0019k\u000b\u0002\r\r&dWMT1nKN\u0003XmY\u0001\u0017]\u0016<H+Y:l)\u0016l\u0007OR5mK\u0006\u00137\u000fU1uQR9A)!+\u0002,\u0006=\u0006bBAB/\u0001\u0007\u0011Q\u0011\u0005\u0007\u0003[;\u0002\u0019\u0001#\u0002\u0017\u0005\u00147o\u001c7vi\u0016$\u0015N\u001d\u0005\b\u0003;;\u0002\u0019AAP\u0003)\u0019w.\\7jiR\u000b7o\u001b\u000b\u0005\u0003\u001b\n)\fC\u0004\u0002\u0004b\u0001\r!!\"\u0002\u0013\u0005\u0014wN\u001d;UCN\\GcA0\u0002<\"9\u00111Q\rA\u0002\u0005\u0015\u0005")
public class ManifestFileCommitProtocol
extends FileCommitProtocol
implements Serializable {
    private final String path;
    private transient ArrayBuffer<String> addedFiles;
    private transient FileStreamSinkLog fileLog;
    private long batchId;
    private transient ArrayBuffer<Path> pendingCommitFiles;

    private ArrayBuffer<String> addedFiles() {
        return this.addedFiles;
    }

    private void addedFiles_$eq(ArrayBuffer<String> x$1) {
        this.addedFiles = x$1;
    }

    private FileStreamSinkLog fileLog() {
        return this.fileLog;
    }

    private void fileLog_$eq(FileStreamSinkLog x$1) {
        this.fileLog = x$1;
    }

    private long batchId() {
        return this.batchId;
    }

    private void batchId_$eq(long x$1) {
        this.batchId = x$1;
    }

    private ArrayBuffer<Path> pendingCommitFiles() {
        return this.pendingCommitFiles;
    }

    private void pendingCommitFiles_$eq(ArrayBuffer<Path> x$1) {
        this.pendingCommitFiles = x$1;
    }

    public void setupManifestOptions(FileStreamSinkLog fileLog, long batchId) {
        this.fileLog_$eq(fileLog);
        this.batchId_$eq(batchId);
    }

    public void setupJob(JobContext jobContext) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable)() -> "setupManifestOptions must be called before this function");
        this.pendingCommitFiles_$eq((ArrayBuffer<Path>)new ArrayBuffer());
    }

    public void commitJob(JobContext jobContext, Seq<FileCommitProtocol.TaskCommitMessage> taskCommits) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable)() -> "setupManifestOptions must be called before this function");
        SinkFileStatus[] fileStatuses = (SinkFileStatus[])((IterableOnceOps)taskCommits.flatMap((Function1 & Serializable)x$5 -> (Seq)x$5.obj())).toArray(ClassTag$.MODULE$.apply(SinkFileStatus.class));
        this.pendingCommitFiles().clear();
        if (this.fileLog().add(this.batchId(), (Object[])fileStatuses)) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Committed batch ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)this.batchId()))}))));
            return;
        }
        throw new IllegalStateException("Race while writing batch " + this.batchId());
    }

    public void abortJob(JobContext jobContext) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable)() -> "setupManifestOptions must be called before this function");
        if (this.pendingCommitFiles().nonEmpty()) {
            this.pendingCommitFiles().foreach((Function1 & Serializable)path -> {
                Object object;
                block3: {
                    try {
                        FileSystem fs = path.getFileSystem(jobContext.getConfiguration());
                        if (fs.exists(path)) {
                            object = BoxesRunTime.boxToBoolean((boolean)fs.delete(path, false));
                            break block3;
                        }
                        object = BoxedUnit.UNIT;
                    }
                    catch (IOException e) {
                        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to remove temporary file ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, path)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"continue removing next."}))).log((Seq)Nil$.MODULE$))), e);
                        object = BoxedUnit.UNIT;
                    }
                }
                return object;
            });
            this.pendingCommitFiles().clear();
            return;
        }
    }

    public void onTaskCommit(FileCommitProtocol.TaskCommitMessage taskCommit) {
        this.pendingCommitFiles().$plus$plus$eq((IterableOnce)((Seq)taskCommit.obj()).map((Function1 & Serializable)x$6 -> x$6.toFileStatus().getPath()));
    }

    public void setupTask(TaskAttemptContext taskContext) {
        this.addedFiles_$eq((ArrayBuffer<String>)new ArrayBuffer());
    }

    public String newTaskTempFile(TaskAttemptContext taskContext, Option<String> dir, FileNameSpec spec) {
        int split = taskContext.getTaskAttemptID().getTaskID().getId();
        String uuid = UUID.randomUUID().toString();
        String filename = StringOps$.MODULE$.format$extension("part-%05d-%s%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)split), uuid, spec.suffix()}));
        String file = (String)dir.map((Function1 & Serializable)d -> new Path(new Path($this.path, d), filename).toString()).getOrElse((Function0 & Serializable)() -> new Path($this.path, filename).toString());
        this.addedFiles().$plus$eq((Object)file);
        return file;
    }

    public String newTaskTempFileAbsPath(TaskAttemptContext taskContext, String absoluteDir, FileNameSpec spec) {
        throw QueryExecutionErrors$.MODULE$.addFilesWithAbsolutePathUnsupportedError(this.toString());
    }

    public FileCommitProtocol.TaskCommitMessage commitTask(TaskAttemptContext taskContext) {
        if (this.addedFiles().nonEmpty()) {
            FileSystem fs = new Path((String)this.addedFiles().head()).getFileSystem(taskContext.getConfiguration());
            Seq statuses = ((IterableOnceOps)this.addedFiles().map((Function1 & Serializable)f -> SinkFileStatus$.MODULE$.apply(fs.getFileStatus(new Path(f))))).toSeq();
            return new FileCommitProtocol.TaskCommitMessage((Object)statuses);
        }
        return new FileCommitProtocol.TaskCommitMessage((Object)package$.MODULE$.Seq().empty());
    }

    public void abortTask(TaskAttemptContext taskContext) {
        if (this.addedFiles().nonEmpty()) {
            FileSystem fs = new Path((String)this.addedFiles().head()).getFileSystem(taskContext.getConfiguration());
            this.addedFiles().foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)fs.delete(new Path(file), false)));
            return;
        }
    }

    public ManifestFileCommitProtocol(String jobId, String path) {
        this.path = path;
    }
}

