/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.execution.arrow.ArrowConverters$;
import org.apache.spark.sql.util.ArrowUtils$;
import scala.Function1;
import scala.collection.Iterator;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005=4Qa\u0003\u0007\u0001!aA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006]\u0001!\ta\f\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0011\u0019a\u0004\u0001)A\u0005k!9Q\b\u0001b\u0001\n#q\u0004BB$\u0001A\u0003%q\bC\u0003I\u0001\u0011\u0005\u0013\nC\u0004Q\u0001\t\u0007I\u0011A)\t\ri\u0003\u0001\u0015!\u0003S\u0011\u0015Y\u0006\u0001\"\u0001]\u0005Q\u0019\u0006/\u0019:l\u0003J\u0014xn\u001e$jY\u0016\u0014V-\u00193fe*\u0011QBD\u0001\u0006CJ\u0014xn\u001e\u0006\u0003\u001fA\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005E\u0011\u0012aA:rY*\u00111\u0003F\u0001\u0006gB\f'o\u001b\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xmE\u0002\u00013\u0005\u0002\"AG\u0010\u000e\u0003mQ!\u0001H\u000f\u0002\t1\fgn\u001a\u0006\u0002=\u0005!!.\u0019<b\u0013\t\u00013D\u0001\u0004PE*,7\r\u001e\t\u00035\tJ!aI\u000e\u0003\u001b\u0005+Ho\\\"m_N,\u0017M\u00197f\u0003\u0011\u0001\u0018\r\u001e5\u0004\u0001A\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\u0005M&dWM\u0003\u0002,;\u0005\u0019a.[8\n\u00055B#\u0001\u0002)bi\"\fa\u0001P5oSRtDC\u0001\u00193!\t\t\u0004!D\u0001\r\u0011\u0015!#\u00011\u0001'\u0003%\tG\u000e\\8dCR|'/F\u00016!\t1$(D\u00018\u0015\tA\u0014(\u0001\u0004nK6|'/\u001f\u0006\u0003\u001bQI!aO\u001c\u0003\u001f\t+hMZ3s\u00032dwnY1u_J\f!\"\u00197m_\u000e\fGo\u001c:!\u0003)1\u0017\u000e\\3SK\u0006$WM]\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0004SB\u001c'B\u0001#:\u0003\u00191Xm\u0019;pe&\u0011a)\u0011\u0002\u0010\u0003J\u0014xn\u001e$jY\u0016\u0014V-\u00193fe\u0006Ya-\u001b7f%\u0016\fG-\u001a:!\u0003\u0015\u0019Gn\\:f)\u0005Q\u0005CA&O\u001b\u0005a%\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c%\u0001B+oSR\faa]2iK6\fW#\u0001*\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016\u0001\u00029pU>T!aV\"\u0002\u000bQL\b/Z:\n\u0005e#&AB*dQ\u0016l\u0017-A\u0004tG\",W.\u0019\u0011\u0002\tI,\u0017\r\u001a\u000b\u0002;B\u0019aLZ5\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012&\u0003\u0019a$o\\8u}%\tQ*\u0003\u0002f\u0019\u00069\u0001/Y2lC\u001e,\u0017BA4i\u0005!IE/\u001a:bi>\u0014(BA3M!\rY%\u000e\\\u0005\u0003W2\u0013Q!\u0011:sCf\u0004\"aS7\n\u00059d%\u0001\u0002\"zi\u0016\u0004")
public class SparkArrowFileReader
implements AutoCloseable {
    private final BufferAllocator allocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator("to" + this.getClass().getSimpleName(), 0L, Long.MAX_VALUE);
    private final ArrowFileReader fileReader;
    private final Schema schema;

    private BufferAllocator allocator() {
        return this.allocator;
    }

    public ArrowFileReader fileReader() {
        return this.fileReader;
    }

    @Override
    public void close() {
        this.fileReader().close();
        this.allocator().close();
    }

    public Schema schema() {
        return this.schema;
    }

    public Iterator<byte[]> read() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.fileReader().getRecordBlocks().iterator()).asScala().map((Function1 & Serializable)block -> {
            this.fileReader().loadRecordBatch(block);
            VectorSchemaRoot root = this.fileReader().getVectorSchemaRoot();
            VectorUnloader unloader = new VectorUnloader(root);
            ArrowRecordBatch batch = unloader.getRecordBatch();
            byte[] bytes = ArrowConverters$.MODULE$.serializeBatch(batch);
            batch.close();
            return bytes;
        });
    }

    public SparkArrowFileReader(Path path) {
        this.fileReader = new ArrowFileReader(Files.newByteChannel(path, new OpenOption[0]), this.allocator());
        this.schema = this.fileReader().getVectorSchemaRoot().getSchema();
    }
}

