/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.tuple.AnotB;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TupleDifferenceBase;
import org.apache.spark.sql.catalyst.expressions.TupleDifferenceDouble$;
import org.apache.spark.sql.catalyst.util.TupleSketchUtils$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(tupleSketch1, tupleSketch2) - Subtracts two binary representations of Datasketches\n    TupleSketch objects with double summary data type using a TupleSketch AnotB object.\n    Returns elements in the first sketch that are not in the second sketch. ", examples="\n    Examples:\n      > SELECT tuple_sketch_estimate_double(_FUNC_(tuple_sketch_agg_double(col1, val1), tuple_sketch_agg_double(col2, val2))) FROM VALUES (5, 5.0D, 4, 4.0D), (1, 1.0D, 4, 4.0D), (2, 2.0D, 5, 5.0D), (3, 3.0D, 1, 1.0D) tab(col1, val1, col2, val2);\n       2.0\n  ", group="sketch_funcs", since="4.2.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u00151\u0007\u0001\"\u0015h\u0011\u001dY\b!!A\u0005\u0002qD\u0001b \u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0001\u0005\n\u0003/\u0001\u0011\u0013!C\u0001\u0003\u0003A\u0011\"!\u0007\u0001\u0003\u0003%\t%a\u0007\t\u0013\u0005-\u0002!!A\u0005\u0002\u00055\u0002\"CA\u001b\u0001\u0005\u0005I\u0011AA\u001c\u0011%\t\u0019\u0005AA\u0001\n\u0003\n)\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0001\u0002V!I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0013\u0011\r\u0005\n\u0003K\u0002\u0011\u0011!C!\u0003O:\u0011\"a#\u001c\u0003\u0003E\t!!$\u0007\u0011iY\u0012\u0011!E\u0001\u0003\u001fCa!\u0015\u000b\u0005\u0002\u0005\u001d\u0006\"CAU)\u0005\u0005IQIAV\u0011%\ti\u000bFA\u0001\n\u0003\u000by\u000bC\u0005\u00026R\t\t\u0011\"!\u00028\"I\u0011\u0011\u001a\u000b\u0002\u0002\u0013%\u00111\u001a\u0002\u0016)V\u0004H.\u001a#jM\u001a,'/\u001a8dK\u0012{WO\u00197f\u0015\taR$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0010 \u0003!\u0019\u0017\r^1msN$(B\u0001\u0011\"\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003E\r\nQa\u001d9be.T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO\u000e\u00011\u0003\u0002\u0001*ou\u00022AK\u0016.\u001b\u0005Y\u0012B\u0001\u0017\u001c\u0005M!V\u000f\u001d7f\t&4g-\u001a:f]\u000e,')Y:f!\tqS'D\u00010\u0015\t\u0001\u0014'A\u0004bI>,(\r\\3\u000b\u0005I\u001a\u0014!\u0002;va2,'B\u0001\u001b$\u00031!\u0017\r^1tW\u0016$8\r[3t\u0013\t1tFA\u0007E_V\u0014G.Z*v[6\f'/\u001f\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\b!J|G-^2u!\tqdI\u0004\u0002@\t:\u0011\u0001iQ\u0007\u0002\u0003*\u0011!iJ\u0001\u0007yI|w\u000e\u001e \n\u0003iJ!!R\u001d\u0002\u000fA\f7m[1hK&\u0011q\t\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u000bf\nA\u0001\\3giV\t1\n\u0005\u0002+\u0019&\u0011Qj\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004'R+\u0006C\u0001\u0016\u0001\u0011\u0015IU\u00011\u0001L\u0011\u0015yU\u00011\u0001L\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002T1jCQ!\u0017\u0004A\u0002-\u000bqA\\3x\u0019\u00164G\u000fC\u0003\\\r\u0001\u00071*\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002=B\u0011ql\u0019\b\u0003A\u0006\u0004\"\u0001Q\u001d\n\u0005\tL\u0014A\u0002)sK\u0012,g-\u0003\u0002eK\n11\u000b\u001e:j]\u001eT!AY\u001d\u0002%\u0011LgMZ3sK:\u001cWmU6fi\u000eDWm\u001d\u000b\u0005Q.\u001cX\u000f\u0005\u00029S&\u0011!.\u000f\u0002\u0005+:LG\u000fC\u0003m\u0011\u0001\u0007Q.\u0001\u0007tW\u0016$8\r[\u0019CsR,7\u000fE\u00029]BL!a\\\u001d\u0003\u000b\u0005\u0013(/Y=\u0011\u0005a\n\u0018B\u0001::\u0005\u0011\u0011\u0015\u0010^3\t\u000bQD\u0001\u0019A7\u0002\u0019M\\W\r^2ie\tKH/Z:\t\u000bYD\u0001\u0019A<\u0002\u000b\u0005tu\u000e\u001e\"\u0011\u0007aLX&D\u00012\u0013\tQ\u0018GA\u0003B]>$()\u0001\u0003d_BLHcA*~}\"9\u0011*\u0003I\u0001\u0002\u0004Y\u0005bB(\n!\u0003\u0005\raS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019AK\u0002L\u0003\u000bY#!a\u0002\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003#I\u0014AC1o]>$\u0018\r^5p]&!\u0011QCA\u0006\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0004\t\u0005\u0003?\tI#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0012\u0001\u00026bm\u0006L1\u0001ZA\u0011\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0003E\u00029\u0003cI1!a\r:\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI$a\u0010\u0011\u0007a\nY$C\u0002\u0002>e\u00121!\u00118z\u0011%\t\tEDA\u0001\u0002\u0004\ty#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u000f\u0002b!!\u0013\u0002P\u0005eRBAA&\u0015\r\ti%O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA)\u0003\u0017\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qKA/!\rA\u0014\u0011L\u0005\u0004\u00037J$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0003\u0002\u0012\u0011!a\u0001\u0003s\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QDA2\u0011%\t\t%EA\u0001\u0002\u0004\ty#\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003/\nI\u0007C\u0005\u0002BI\t\t\u00111\u0001\u0002:!\u001a\u0002!!\u001c\u0002t\u0005U\u0014\u0011PA>\u0003\u007f\n\t)!\"\u0002\bB\u0019!&a\u001c\n\u0007\u0005E4DA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005]\u0014Aa\u0002\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006^;qY\u0016\u001c6.\u001a;dQFb\u0003\u0005^;qY\u0016\u001c6.\u001a;dQJJ\u0003%\f\u0011Tk\n$(/Y2ug\u0002\"xo\u001c\u0011cS:\f'/\u001f\u0011sKB\u0014Xm]3oi\u0006$\u0018n\u001c8tA=4\u0007\u0005R1uCN\\W\r^2iKNT\u0001\u0005\t\u0011!)V\u0004H.Z*lKR\u001c\u0007\u000eI8cU\u0016\u001cGo\u001d\u0011xSRD\u0007\u0005Z8vE2,\u0007e];n[\u0006\u0014\u0018\u0010\t3bi\u0006\u0004C/\u001f9fAU\u001c\u0018N\\4!C\u0002\"V\u000f\u001d7f'.,Go\u00195!\u0003:|GO\u0011\u0011pE*,7\r\u001e\u0018\u000bA\u0001\u0002\u0003EU3ukJt7\u000fI3mK6,g\u000e^:!S:\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011tW\u0016$8\r\u001b\u0011uQ\u0006$\b%\u0019:fA9|G\u000fI5oAQDW\rI:fG>tG\rI:lKR\u001c\u0007N\f\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!! \u0002\u0005KQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006\u0005^;qY\u0016|6o[3uG\"|Vm\u001d;j[\u0006$Xm\u00183pk\ndW\rK0G+:\u001bu\f\u000b;va2,wl]6fi\u000eDw,Y4h?\u0012|WO\u00197fQ\r|G.\r\u0017!m\u0006d\u0017'\u000b\u0017!iV\u0004H.Z0tW\u0016$8\r[0bO\u001e|Fm\\;cY\u0016D3m\u001c73Y\u00012\u0018\r\u001c\u001a*S%\u0002cIU(NAY\u000bE*V#TA!*D\u0006I\u001b/a\u0011c\u0003\u0005\u000e\u0017!i9\u0002D)\u000b\u0017!QEb\u0003%\r\u00181\t2\u0002C\u0007\f\u00115]A\"\u0015\u0006\f\u0011)e1\u0002#G\f\u0019EY\u0001*D\u0006I\u001b/a\u0011KC\u0006\t\u00154Y\u0001\u001ad\u0006\r#-AEb\u0003%\r\u00181\t&\u0002C/\u00192)G>d\u0017\u0007\f\u0011wC2\fD\u0006I2pYJb\u0003E^1me%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00181\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAB\u00031\u00198.\u001a;dQ~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\tI)A\u00035]Ir\u0003'A\u000bUkBdW\rR5gM\u0016\u0014XM\\2f\t>,(\r\\3\u0011\u0005)\"2#\u0002\u000b\u0002\u0012\u0006u\u0005cBAJ\u00033[5jU\u0007\u0003\u0003+S1!a&:\u0003\u001d\u0011XO\u001c;j[\u0016LA!a'\u0002\u0016\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005}\u0015QU\u0007\u0003\u0003CSA!a)\u0002&\u0005\u0011\u0011n\\\u0005\u0004\u000f\u0006\u0005FCAAG\u0003!!xn\u0015;sS:<GCAA\u000f\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0019\u0016\u0011WAZ\u0011\u0015Iu\u00031\u0001L\u0011\u0015yu\u00031\u0001L\u0003\u001d)h.\u00199qYf$B!!/\u0002FB)\u0001(a/\u0002@&\u0019\u0011QX\u001d\u0003\r=\u0003H/[8o!\u0015A\u0014\u0011Y&L\u0013\r\t\u0019-\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005\u001d\u0007$!AA\u0002M\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ti\r\u0005\u0003\u0002 \u0005=\u0017\u0002BAi\u0003C\u0011aa\u00142kK\u000e$\b")
public class TupleDifferenceDouble
extends TupleDifferenceBase<DoubleSummary>
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(TupleDifferenceDouble x$0) {
        return TupleDifferenceDouble$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, TupleDifferenceDouble> tupled() {
        return TupleDifferenceDouble$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TupleDifferenceDouble>> curried() {
        return TupleDifferenceDouble$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public TupleDifferenceDouble withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public String prettyName() {
        return "tuple_difference_double";
    }

    @Override
    public void differenceSketches(byte[] sketch1Bytes, byte[] sketch2Bytes, AnotB<DoubleSummary> aNotB) {
        Sketch<DoubleSummary> tupleSketch1 = TupleSketchUtils$.MODULE$.heapifyDoubleSketch(sketch1Bytes, this.prettyName());
        Sketch<DoubleSummary> tupleSketch2 = TupleSketchUtils$.MODULE$.heapifyDoubleSketch(sketch2Bytes, this.prettyName());
        aNotB.setA(tupleSketch1);
        aNotB.notB(tupleSketch2);
    }

    public TupleDifferenceDouble copy(Expression left, Expression right) {
        return new TupleDifferenceDouble(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "TupleDifferenceDouble";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TupleDifferenceDouble;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TupleDifferenceDouble)) return false;
        boolean bl = true;
        if (!bl) return false;
        TupleDifferenceDouble tupleDifferenceDouble = (TupleDifferenceDouble)x$1;
        Expression expression = this.left();
        Expression expression2 = tupleDifferenceDouble.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = tupleDifferenceDouble.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!tupleDifferenceDouble.canEqual(this)) return false;
        return true;
    }

    public TupleDifferenceDouble(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

