/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.NodeSelectorRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NodeSelectorRequirementFluent<A extends NodeSelectorRequirementFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String key;
    private String operator;
    private List<String> values = new ArrayList<String>();

    public NodeSelectorRequirementFluent() {
    }

    public NodeSelectorRequirementFluent(NodeSelectorRequirement instance) {
        this.copyInstance(instance);
    }

    public A addAllToValues(Collection<String> items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToValues(String ... items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)((Object)this);
    }

    public A addToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(NodeSelectorRequirement instance) {
        NodeSelectorRequirement nodeSelectorRequirement = instance = instance != null ? instance : new NodeSelectorRequirement();
        if (instance != null) {
            this.withKey(instance.getKey());
            this.withOperator(instance.getOperator());
            this.withValues(instance.getValues());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSelectorRequirementFluent that = (NodeSelectorRequirementFluent)((Object)o);
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals(this.operator, that.operator)) {
            return false;
        }
        if (!Objects.equals(this.values, that.values)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstValue() {
        return this.values.get(0);
    }

    public String getKey() {
        return this.key;
    }

    public String getLastValue() {
        return this.values.get(this.values.size() - 1);
    }

    public String getMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getValue(int index) {
        return this.values.get(index);
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public boolean hasMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOperator() {
        return this.operator != null;
    }

    public boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.key, this.operator, this.values, this.additionalProperties);
    }

    public A removeAllFromValues(Collection<String> items) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.values.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromValues(String ... items) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.values.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.key != null) {
            sb.append("key:");
            sb.append(this.key);
            sb.append(",");
        }
        if (this.operator != null) {
            sb.append("operator:");
            sb.append(this.operator);
            sb.append(",");
        }
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(this.values);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withKey(String key) {
        this.key = key;
        return (A)((Object)this);
    }

    public A withOperator(String operator) {
        this.operator = operator;
        return (A)((Object)this);
    }

    public A withValues(List<String> values) {
        if (values != null) {
            this.values = new ArrayList<String>();
            for (String item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)((Object)this);
    }

    public A withValues(String ... values) {
        if (this.values != null) {
            this.values.clear();
            this._visitables.remove((Object)"values");
        }
        if (values != null) {
            for (String item : values) {
                this.addToValues(item);
            }
        }
        return (A)((Object)this);
    }
}

