/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml.bayesian_network;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.LocalTransformations;
import org.sparkproject.dmg.pmml.MathContext;
import org.sparkproject.dmg.pmml.MiningFunction;
import org.sparkproject.dmg.pmml.MiningSchema;
import org.sparkproject.dmg.pmml.Model;
import org.sparkproject.dmg.pmml.ModelExplanation;
import org.sparkproject.dmg.pmml.ModelStats;
import org.sparkproject.dmg.pmml.ModelVerification;
import org.sparkproject.dmg.pmml.Output;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.Targets;
import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.bayesian_network.BayesianNetworkNodes;
import org.sparkproject.dmg.pmml.bayesian_network.PMMLAttributes;
import org.sparkproject.dmg.pmml.bayesian_network.PMMLElements;
import org.sparkproject.jpmml.model.MissingAttributeException;
import org.sparkproject.jpmml.model.MissingElementException;
import org.sparkproject.jpmml.model.annotations.Added;
import org.sparkproject.jpmml.model.annotations.CollectionElementType;
import org.sparkproject.jpmml.model.annotations.Property;
import org.sparkproject.jpmml.model.annotations.Since;
import org.sparkproject.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="BayesianNetworkModel", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "bayesianNetworkNodes", "modelVerification"})
@JsonRootName(value="BayesianNetworkModel")
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "modelType", "inferenceMethod", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "bayesianNetworkNodes", "modelVerification"})
@Added(value=Version.PMML_4_3)
public class BayesianNetworkModel
extends Model
implements HasExtensions<BayesianNetworkModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="modelType")
    @JsonProperty(value="modelType")
    @Added(value=Version.PMML_4_4)
    private String modelType;
    @XmlAttribute(name="inferenceMethod")
    @JsonProperty(value="inferenceMethod")
    @Added(value=Version.PMML_4_4)
    private String inferenceMethod;
    @XmlAttribute(name="isScorable")
    @JsonProperty(value="isScorable")
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @JsonProperty(value="x-mathContext")
    @Added(value=Version.XPMML, removable=true)
    @Since(value="1.3.7")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="BayesianNetworkNodes", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="BayesianNetworkNodes")
    private BayesianNetworkNodes bayesianNetworkNodes;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371272L;

    public BayesianNetworkModel() {
    }

    @ValueConstructor
    public BayesianNetworkModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="bayesianNetworkNodes") BayesianNetworkNodes bayesianNetworkNodes) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.bayesianNetworkNodes = bayesianNetworkNodes;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public BayesianNetworkModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.BAYESIANNETWORKMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public BayesianNetworkModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public BayesianNetworkModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public String getModelType() {
        if (this.modelType == null) {
            return "General";
        }
        return this.modelType;
    }

    public BayesianNetworkModel setModelType(@Property(value="modelType") String modelType) {
        this.modelType = modelType;
        return this;
    }

    public String getInferenceMethod() {
        if (this.inferenceMethod == null) {
            return "Other";
        }
        return this.inferenceMethod;
    }

    public BayesianNetworkModel setInferenceMethod(@Property(value="inferenceMethod") String inferenceMethod) {
        this.inferenceMethod = inferenceMethod;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public BayesianNetworkModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public BayesianNetworkModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public BayesianNetworkModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.BAYESIANNETWORKMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public BayesianNetworkModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public BayesianNetworkModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public BayesianNetworkModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public BayesianNetworkModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public BayesianNetworkModel setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public BayesianNetworkModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public BayesianNetworkNodes requireBayesianNetworkNodes() {
        if (this.bayesianNetworkNodes == null) {
            throw new MissingElementException(this, PMMLElements.BAYESIANNETWORKMODEL_BAYESIANNETWORKNODES);
        }
        return this.bayesianNetworkNodes;
    }

    public BayesianNetworkNodes getBayesianNetworkNodes() {
        return this.bayesianNetworkNodes;
    }

    public BayesianNetworkModel setBayesianNetworkNodes(@Property(value="bayesianNetworkNodes") BayesianNetworkNodes bayesianNetworkNodes) {
        this.bayesianNetworkNodes = bayesianNetworkNodes;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public BayesianNetworkModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getBayesianNetworkNodes(), this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

