/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import coursierapi.Artifact;
import coursierapi.Dependency;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class FetchResult
implements Serializable {
    private List<Map.Entry<Artifact, File>> artifacts;
    private List<Dependency> dependencies;

    private FetchResult(List<Map.Entry<Artifact, File>> list, List<Dependency> list2) {
        this.artifacts = Collections.unmodifiableList(new ArrayList<Map.Entry<Artifact, File>>(list));
        this.dependencies = Collections.unmodifiableList(new ArrayList<Dependency>(list2));
    }

    public static FetchResult of(List<Map.Entry<Artifact, File>> list) {
        return new FetchResult(list, Collections.emptyList());
    }

    public static FetchResult of(List<Map.Entry<Artifact, File>> list, List<Dependency> list2) {
        return new FetchResult(list, list2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FetchResult) {
            FetchResult fetchResult = (FetchResult)object;
            return this.artifacts.equals(fetchResult.artifacts) && this.dependencies.equals(fetchResult.dependencies);
        }
        return false;
    }

    public int hashCode() {
        return 37 * (37 * (17 + this.artifacts.hashCode())) + this.dependencies.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("FetchResult(artifacts=[");
        boolean bl = true;
        for (Map.Entry<Artifact, File> object : this.artifacts) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(object.getKey().toString());
            stringBuilder.append(": ");
            stringBuilder.append(object.getValue().toString());
        }
        stringBuilder.append("], dependencies=[");
        bl = true;
        for (Dependency dependency : this.dependencies) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(dependency.toString());
        }
        stringBuilder.append("])");
        return stringBuilder.toString();
    }

    public List<Map.Entry<Artifact, File>> getArtifacts() {
        return this.artifacts;
    }

    public List<File> getFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Map.Entry<Artifact, File> entry : this.artifacts) {
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }
}

