/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server;

import java.util.Objects;
import org.sparkproject.jetty.server.AliasCheck;
import org.sparkproject.jetty.util.component.AbstractLifeCycle;
import org.sparkproject.jetty.util.resource.Resource;

public class TrailingSlashAliasChecker
extends AbstractLifeCycle
implements AliasCheck {
    @Override
    public boolean checkAlias(String pathInContext, Resource resource) {
        String uri = resource.getURI().toString();
        if (uri.isEmpty()) {
            return false;
        }
        String realUri = resource.getRealURI().toString();
        if (uri.endsWith("/") && !realUri.endsWith("/")) {
            return Objects.equals(uri.substring(0, uri.length() - 1), realUri);
        }
        return false;
    }
}

