/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.util.thread.strategy;

import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.util.IO;
import org.sparkproject.jetty.util.TypeUtil;
import org.sparkproject.jetty.util.VirtualThreads;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;
import org.sparkproject.jetty.util.annotation.ManagedObject;
import org.sparkproject.jetty.util.annotation.ManagedOperation;
import org.sparkproject.jetty.util.component.ContainerLifeCycle;
import org.sparkproject.jetty.util.thread.ExecutionStrategy;
import org.sparkproject.jetty.util.thread.Invocable;
import org.sparkproject.jetty.util.thread.TryExecutor;

@ManagedObject(value="Adaptive execution strategy")
public class AdaptiveExecutionStrategy
extends ContainerLifeCycle
implements ExecutionStrategy,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AdaptiveExecutionStrategy.class);
    private final LongAdder _pcMode = new LongAdder();
    private final LongAdder _picMode = new LongAdder();
    private final LongAdder _pecMode = new LongAdder();
    private final LongAdder _epcMode = new LongAdder();
    private final LongAdder _epcProduce = new LongAdder();
    private final ExecutionStrategy.Producer _producer;
    private final TryExecutor _tryExecutor;
    private final Executor _executor;
    private final boolean _isUseVirtualThreads;
    private final AtomicReference<State> _state = new AtomicReference<State>(State.IDLE);

    public AdaptiveExecutionStrategy(ExecutionStrategy.Producer producer, Executor executor) {
        this._producer = producer;
        this._executor = VirtualThreads.getExecutor(executor);
        this._tryExecutor = TryExecutor.asTryExecutor(executor);
        this._isUseVirtualThreads = VirtualThreads.isUseVirtualThreads(executor);
        this.installBean(this._producer);
        this.installBean(this._executor);
        this.installBean(this._tryExecutor);
        if (LOG.isDebugEnabled()) {
            LOG.debug("created {}", (Object)this);
        }
    }

    @Override
    public void dispatch() {
        boolean execute = false;
        block4: while (true) {
            State state = this._state.get();
            switch (state.ordinal()) {
                case 0: {
                    execute = true;
                    break block4;
                }
                case 1: {
                    if (this._state.compareAndSet(State.PRODUCING, State.REPRODUCING)) break block4;
                    continue block4;
                }
            }
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("dispatch {} {}", (Object)execute, (Object)this);
        }
        if (execute && !this._tryExecutor.tryExecute(this)) {
            this._executor.execute(this);
        }
    }

    @Override
    public void produce() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("produce() producing {}", (Object)this);
        }
        this.tryProduce();
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("dispatch() producing {}", (Object)this);
        }
        this.tryProduce();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryProduce() {
        block11: while (true) {
            State state = this._state.get();
            switch (state.ordinal()) {
                case 0: {
                    if (this._state.compareAndSet(state, State.PRODUCING)) break block11;
                    continue block11;
                }
                case 1: {
                    if (this._state.compareAndSet(state, State.REPRODUCING)) return;
                    continue block11;
                }
                case 2: {
                    return;
                }
                default: {
                    throw new IllegalStateException(this.toString(state));
                }
            }
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("producing {}", (Object)this);
        }
        boolean nonBlocking = Invocable.isNonBlockingInvocation();
        block12: while (this.isRunning()) {
            try {
                State state;
                Runnable task = this.produceTask();
                if (task != null) {
                    if (this.consumeTask(task, this.selectSubStrategy(task, nonBlocking))) continue;
                    return;
                }
                block13: while (true) {
                    state = this._state.get();
                    switch (state.ordinal()) {
                        case 1: {
                            if (!this._state.compareAndSet(state, State.IDLE)) continue block13;
                            return;
                        }
                        case 2: {
                            if (this._state.compareAndSet(state, State.PRODUCING)) continue block12;
                            continue block13;
                        }
                    }
                    break;
                }
                throw new IllegalStateException(this.toString(state));
            }
            catch (Throwable th) {
                LOG.warn("Unable to produce", th);
            }
        }
    }

    private SubStrategy selectSubStrategy(Runnable task, boolean nonBlocking) {
        Invocable.InvocationType taskType = Invocable.getInvocationType(task);
        switch (taskType) {
            case NON_BLOCKING: {
                return SubStrategy.PRODUCE_CONSUME;
            }
            case EITHER: {
                if (nonBlocking) {
                    return SubStrategy.PRODUCE_CONSUME;
                }
                if (this.tryExecuteProduceConsume()) {
                    return SubStrategy.EXECUTE_PRODUCE_CONSUME;
                }
                return SubStrategy.PRODUCE_INVOKE_CONSUME;
            }
            case BLOCKING: {
                if (nonBlocking) {
                    return SubStrategy.PRODUCE_EXECUTE_CONSUME;
                }
                if (this.tryExecuteProduceConsume()) {
                    return SubStrategy.EXECUTE_PRODUCE_CONSUME;
                }
                return SubStrategy.PRODUCE_EXECUTE_CONSUME;
            }
        }
        throw new IllegalStateException(String.format("taskType=%s %s", new Object[]{taskType, this}));
    }

    private boolean tryExecuteProduceConsume() {
        State state = this._state.get();
        if (!this._state.compareAndSet(state, State.IDLE)) {
            return false;
        }
        if (this._tryExecutor.tryExecute(this)) {
            return true;
        }
        block5: while (true) {
            state = this._state.get();
            switch (state.ordinal()) {
                case 0: {
                    if (!this._state.compareAndSet(state, State.PRODUCING)) continue block5;
                    return false;
                }
                case 1: {
                    if (!this._state.compareAndSet(state, State.REPRODUCING)) continue block5;
                    return true;
                }
                case 2: {
                    return true;
                }
            }
        }
    }

    private boolean consumeTask(Runnable task, SubStrategy subStrategy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("consumeTask ss={}/{}/{} t={} {}", new Object[]{subStrategy, Invocable.isNonBlockingInvocation(), Invocable.getInvocationType(task), task, this});
        }
        return switch (subStrategy.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.pcRunTask(task);
            case 1 -> this.picRunTask(task);
            case 2 -> this.pecRunTask(task);
            case 3 -> this.epcRunTask(task);
        };
    }

    private boolean pcRunTask(Runnable task) {
        this._pcMode.increment();
        this.runTask(task);
        return true;
    }

    private boolean epcRunTask(Runnable task) {
        State state;
        this._epcMode.increment();
        this.runTask(task);
        do {
            if ((state = this._state.get()) == State.IDLE) continue;
            return false;
        } while (!this._state.compareAndSet(state, State.PRODUCING));
        this._epcProduce.increment();
        return true;
    }

    private boolean pecRunTask(Runnable task) {
        this._pecMode.increment();
        this.execute(task);
        return true;
    }

    private boolean picRunTask(Runnable task) {
        try {
            this._picMode.increment();
            Invocable.invokeNonBlocking(task);
            return true;
        }
        catch (Throwable x) {
            LOG.warn("Task invoke failed", x);
            return true;
        }
    }

    private void runTask(Runnable task) {
        try {
            task.run();
        }
        catch (Throwable x) {
            LOG.warn("Task run failed", x);
        }
    }

    private Runnable produceTask() {
        try {
            return this._producer.produce();
        }
        catch (Throwable e) {
            LOG.warn("Task produce failed", e);
            return null;
        }
    }

    private void execute(Runnable task) {
        block4: {
            try {
                this._executor.execute(task);
            }
            catch (RejectedExecutionException e) {
                if (this.isRunning()) {
                    LOG.warn("Execute failed", (Throwable)e);
                } else {
                    LOG.trace("IGNORED", (Throwable)e);
                }
                if (!(task instanceof Closeable)) break block4;
                IO.close((Closeable)((Object)task));
            }
        }
    }

    @ManagedAttribute(value="whether this execution strategy uses virtual threads", readonly=true)
    public boolean isUseVirtualThreads() {
        return this._isUseVirtualThreads;
    }

    @ManagedAttribute(value="number of tasks consumed with PC mode", readonly=true)
    public long getPCTasksConsumed() {
        return this._pcMode.longValue();
    }

    @ManagedAttribute(value="number of tasks executed with PIC mode", readonly=true)
    public long getPICTasksExecuted() {
        return this._picMode.longValue();
    }

    @ManagedAttribute(value="number of tasks executed with PEC mode", readonly=true)
    public long getPECTasksExecuted() {
        return this._pecMode.longValue();
    }

    @ManagedAttribute(value="number of tasks consumed with EPC mode", readonly=true)
    public long getEPCTasksConsumed() {
        return this._epcMode.longValue();
    }

    @ManagedAttribute(value="number of times a EPC thread produces again", readonly=true)
    public long getEPCProduceCount() {
        return this._epcProduce.longValue();
    }

    @ManagedAttribute(value="whether this execution strategy is idle", readonly=true)
    public boolean isIdle() {
        return this._state.get() == State.IDLE;
    }

    @ManagedOperation(value="resets the task counts", impact="ACTION")
    public void reset() {
        this._pcMode.reset();
        this._epcMode.reset();
        this._pecMode.reset();
        this._picMode.reset();
    }

    @Override
    public String toString() {
        return this.toString(this._state.get());
    }

    private String toString(State state) {
        StringBuilder builder = new StringBuilder();
        this.getString(builder);
        this.getState(builder, state);
        return builder.toString();
    }

    private void getString(StringBuilder builder) {
        builder.append(TypeUtil.toShortName(this.getClass())).append('@').append(Integer.toHexString(this.hashCode())).append('/').append(this._producer).append('/');
    }

    private void getState(StringBuilder builder, State state) {
        builder.append((Object)state).append('/').append(this._tryExecutor).append("[pc=").append(this.getPCTasksConsumed()).append(",pic=").append(this.getPICTasksExecuted()).append(",pec=").append(this.getPECTasksExecuted()).append(",epc=").append(this.getEPCProduceCount()).append("/").append(this.getEPCTasksConsumed()).append("]");
    }

    private static enum State {
        IDLE,
        PRODUCING,
        REPRODUCING;

    }

    private static enum SubStrategy {
        PRODUCE_CONSUME,
        PRODUCE_INVOKE_CONSUME,
        PRODUCE_EXECUTE_CONSUME,
        EXECUTE_PRODUCE_CONSUME;

    }
}

