/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementCoreProperties;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class InitPasswordChangeAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InitPasswordChangeAction.class);
    private final CasConfigurationProperties casProperties;

    protected Event doExecuteInternal(RequestContext requestContext) {
        PasswordManagementCoreProperties core = this.casProperties.getAuthn().getPm().getCore();
        WebUtils.putPasswordPolicyPattern((RequestContext)requestContext, (String)core.getPasswordPolicyPattern());
        requestContext.getFlowScope().put("passwordPolicyCharacterSet", (Object)core.getPasswordPolicyCharacterSet());
        requestContext.getFlowScope().put("passwordPolicyPasswordLength", (Object)core.getPasswordPolicyPasswordLength());
        UsernamePasswordCredential upc = this.getCredentialFromWebflow(requestContext);
        if (upc != null) {
            LOGGER.debug("Restoring credential [{}] for password management", (Object)upc);
            WebUtils.putCredential((RequestContext)requestContext, (Credential)upc);
            PasswordManagementWebflowUtils.putPasswordResetUsername(requestContext, upc.getId());
        }
        return null;
    }

    protected UsernamePasswordCredential getCredentialFromWebflow(RequestContext requestContext) {
        AttributeMap attributes = requestContext.getCurrentEvent().getAttributes();
        if (!attributes.isEmpty() && attributes.contains(Credential.class.getName())) {
            return (UsernamePasswordCredential)attributes.get(Credential.class.getName(), UsernamePasswordCredential.class);
        }
        return (UsernamePasswordCredential)requestContext.getConversationScope().get(Credential.class.getName(), UsernamePasswordCredential.class);
    }

    @Generated
    public InitPasswordChangeAction(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

