/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.clientapps;

import java.io.Serializable;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.clientapps.ClientAppPropertyWizardBuilder;
import org.apache.syncope.client.console.panels.AttrListDirectoryPanel;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.console.rest.ClientAppRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.ModalPanelBuilder;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.model.IModel;

public class ClientAppPropertiesDirectoryPanel<T extends ClientAppTO>
extends AttrListDirectoryPanel {
    private static final long serialVersionUID = 9072805604972532678L;
    protected final BaseModal<T> propertiesModal;
    protected final ClientAppType type;
    protected final IModel<T> model;

    public ClientAppPropertiesDirectoryPanel(String id, ClientAppRestClient restClient, BaseModal<T> propertiesModal, ClientAppType type, IModel<T> model, PageReference pageRef) {
        super(id, (BaseRestClient)restClient, pageRef, false);
        this.propertiesModal = propertiesModal;
        this.type = type;
        this.model = model;
        this.setOutputMarkupId(true);
        this.enableUtilityButton();
        this.setFooterVisibility(false);
        this.addNewItemPanelBuilder((ModalPanelBuilder)new ClientAppPropertyWizardBuilder(type, (ClientAppTO)model.getObject(), new Attr(), restClient, pageRef), true);
        this.initResultTable();
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof WizardMgtPanel.ExitEvent) {
            AjaxRequestTarget target = ((WizardMgtPanel.ExitEvent)WizardMgtPanel.ExitEvent.class.cast(event.getPayload())).getTarget();
            this.propertiesModal.close((IPartialPageRequestHandler)target);
        } else if (event.getPayload() instanceof AjaxWizard.EditItemActionEvent) {
            AjaxWizard.EditItemActionEvent payload = (AjaxWizard.EditItemActionEvent)event.getPayload();
            payload.getTarget().ifPresent(arg_0 -> ((ActionLinksTogglePanel)this.actionTogglePanel).close(arg_0));
        }
        super.onEvent(event);
    }

    protected AttrListDirectoryPanel.AttrListProvider dataProvider() {
        return new ClientAppPropertiesProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "clientapp.properties.paginator.rows";
    }

    protected ActionsPanel<Attr> getActions(final IModel<Attr> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<Attr>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, Attr ignore) {
                ClientAppPropertiesDirectoryPanel.this.send((IEventSink)ClientAppPropertiesDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((Attr)model.getObject()), target));
            }
        }, ActionLink.ActionType.EDIT, "CLIENTAPP_CREATE");
        panel.add((ActionLink)new ActionLink<Attr>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, Attr ignore) {
                try {
                    ((ClientAppTO)ClientAppPropertiesDirectoryPanel.this.model.getObject()).getProperties().remove(model.getObject());
                    ((ClientAppRestClient)ClientAppPropertiesDirectoryPanel.this.restClient).update(ClientAppPropertiesDirectoryPanel.this.type, (ClientAppTO)ClientAppPropertiesDirectoryPanel.this.model.getObject());
                    SyncopeConsoleSession.get().success((Serializable)((Object)ClientAppPropertiesDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{ClientAppPropertiesDirectoryPanel.this.container});
                }
                catch (Exception e) {
                    LOG.error("While deleting {}", (Object)((Attr)model.getObject()).getSchema(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)ClientAppPropertiesDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "CLIENTAPP_CREATE", true);
        return panel;
    }

    protected final class ClientAppPropertiesProvider
    extends AttrListDirectoryPanel.AttrListProvider {
        private static final long serialVersionUID = -185944053385660794L;

        private ClientAppPropertiesProvider(int paginatorRows) {
            super(paginatorRows);
        }

        protected List<Attr> list() {
            return ((ClientAppTO)ClientAppPropertiesDirectoryPanel.this.model.getObject()).getProperties();
        }
    }
}

