/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.security.Key;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.BaseTokenSigningAndEncryptionService;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOidcJsonWebKeyTokenSigningAndEncryptionService
extends BaseTokenSigningAndEncryptionService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOidcJsonWebKeyTokenSigningAndEncryptionService.class);
    protected final LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> defaultJsonWebKeystoreCache;
    protected final LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> serviceJsonWebKeystoreCache;
    protected final OidcIssuerService issuerService;
    protected final CasConfigurationProperties casProperties;

    public String encode(OAuthRegisteredService registeredService, JwtClaims claims) {
        return (String)FunctionUtils.doUnchecked(() -> {
            LOGGER.trace("Attempting to produce token generated for service [{}] with claims [{}]", (Object)registeredService, (Object)claims.toJson());
            String innerJwt = this.signTokenIfNecessary(claims, registeredService);
            if (this.shouldEncryptToken(registeredService)) {
                innerJwt = this.encryptToken(registeredService, innerJwt);
            }
            return innerJwt;
        });
    }

    public JwtClaims decode(String token, Optional<OAuthRegisteredService> registeredService) {
        return (JwtClaims)Unchecked.supplier(() -> {
            JWT jwt;
            if (registeredService.isPresent() && (jwt = JWTParser.parse((String)token)) instanceof EncryptedJWT) {
                PublicJsonWebKey encryptionKey = this.getJsonWebKeyForEncryption((OAuthRegisteredService)registeredService.get());
                String decoded = EncodingUtils.decryptJwtValue((Key)encryptionKey.getPrivateKey(), (String)token);
                return super.decode(decoded, registeredService);
            }
            return super.decode(token, registeredService);
        }, throwable -> {
            throw new IllegalArgumentException((Throwable)throwable);
        }).get();
    }

    public String resolveIssuer(Optional<OAuthRegisteredService> registeredService) {
        Optional<OidcRegisteredService> filter = registeredService.filter(OidcRegisteredService.class::isInstance).map(OidcRegisteredService.class::cast).stream().findFirst();
        return this.issuerService.determineIssuer(filter);
    }

    protected abstract String encryptToken(OAuthRegisteredService var1, String var2);

    public PublicJsonWebKey getJsonWebKeySigningKey(Optional<OAuthRegisteredService> registeredService) throws Throwable {
        Optional<OidcRegisteredService> servicePassed = registeredService.filter(OidcRegisteredService.class::isInstance).map(OidcRegisteredService.class::cast).stream().findFirst();
        String iss = this.issuerService.determineIssuer(servicePassed);
        LOGGER.trace("Using issuer [{}] to locate JWK signing key", (Object)iss);
        JsonWebKeySet jwks = (JsonWebKeySet)this.defaultJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey(iss, OidcJsonWebKeyUsage.SIGNING));
        return this.getJsonWebKeySigningKeyFrom(jwks, registeredService);
    }

    protected PublicJsonWebKey getJsonWebKeySigningKeyFrom(JsonWebKeySet jwks, Optional<OAuthRegisteredService> serviceResult) throws Throwable {
        FunctionUtils.throwIfNull((Object)jwks, () -> new IllegalArgumentException("JSON web keystore is empty and contains no keys"));
        List jsonWebKeys = jwks.getJsonWebKeys();
        LOGGER.trace("JSON web keystore contains [{}] key(s)", (Object)jsonWebKeys);
        Optional finalKey = serviceResult.filter(OidcRegisteredService.class::isInstance).map(OidcRegisteredService.class::cast).stream().filter(oidcService -> StringUtils.isNotBlank((CharSequence)oidcService.getJwksKeyId())).map(oidcService -> jsonWebKeys.stream().filter(PublicJsonWebKey.class::isInstance).filter(key -> StringUtils.equalsIgnoreCase((CharSequence)key.getKeyId(), (CharSequence)oidcService.getJwksKeyId())).map(PublicJsonWebKey.class::cast).findFirst()).flatMap(Optional::stream).findFirst();
        LOGGER.debug("Located key [{}] for service [{}]", finalKey, serviceResult);
        return finalKey.orElseGet(() -> (PublicJsonWebKey)jsonWebKeys.getFirst());
    }

    protected PublicJsonWebKey getJsonWebKeyForEncryption(OAuthRegisteredService registeredService) {
        LOGGER.debug("Service [{}] is set to encrypt tokens", (Object)registeredService);
        OidcRegisteredService oidcService = (OidcRegisteredService)registeredService;
        Optional jwks = (Optional)this.serviceJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey(registeredService, OidcJsonWebKeyUsage.ENCRYPTION));
        if (jwks.isEmpty()) {
            String message = "Service %s with client id %s is configured to encrypt tokens, yet no JSON web key is available to handle encryption".formatted(registeredService.getServiceId(), registeredService.getClientId());
            if (oidcService.isIdTokenEncryptionOptional()) {
                LOGGER.info(message);
                return null;
            }
            throw new IllegalArgumentException(message);
        }
        JsonWebKey jsonWebKey = ((JsonWebKeySet)jwks.get()).getJsonWebKeys().stream().filter(key -> OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.getJsonWebKeyState(key).isCurrent()).min(Comparator.comparing(JsonWebKey::getKeyId)).orElseThrow(() -> new IllegalArgumentException("Cannot locate current JSON web key for encryption"));
        LOGGER.debug("Found JSON web key to encrypt the token: [{}]", (Object)jsonWebKey);
        Objects.requireNonNull(jsonWebKey.getKey(), "JSON web key used to encrypt the token has no associated public key");
        return (PublicJsonWebKey)jsonWebKey;
    }

    @Generated
    protected BaseOidcJsonWebKeyTokenSigningAndEncryptionService(LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> defaultJsonWebKeystoreCache, LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> serviceJsonWebKeystoreCache, OidcIssuerService issuerService, CasConfigurationProperties casProperties) {
        this.defaultJsonWebKeystoreCache = defaultJsonWebKeystoreCache;
        this.serviceJsonWebKeystoreCache = serviceJsonWebKeystoreCache;
        this.issuerService = issuerService;
        this.casProperties = casProperties;
    }
}

