/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.xml.ws.WebServiceException;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.lib.SyncopeAnonymousClient;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.DateOps;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.concurrent.SimpleAsyncTaskScheduler;
import org.springframework.util.CollectionUtils;

public class SyncopeConsoleSession
extends AuthenticatedWebSession
implements BaseSession {
    private static final long serialVersionUID = 747562246415852166L;
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeConsoleSession.class);
    protected final SyncopeClientFactoryBean clientFactory;
    protected final Map<Class<?>, Object> services = Collections.synchronizedMap(new HashMap());
    protected final SimpleAsyncTaskExecutor executor;
    protected String domain;
    protected SyncopeClient client;
    protected Instant jwtExpiration;
    protected SyncopeAnonymousClient anonymousClient;
    protected Pair<String, String> gitAndBuildInfo;
    protected PlatformInfo platformInfo;
    protected SystemInfo systemInfo;
    protected SyncopeClient.Self self;
    protected String delegatedBy;
    protected Roles roles;

    public static SyncopeConsoleSession get() {
        return (SyncopeConsoleSession)Session.get();
    }

    public SyncopeConsoleSession(Request request) {
        super(request);
        this.clientFactory = SyncopeWebApplication.get().newClientFactory();
        this.executor = new SimpleAsyncTaskScheduler();
        this.executor.setVirtualThreads(true);
    }

    protected String message(SyncopeClientException sce) {
        return sce.getType().name() + ": " + String.join((CharSequence)", ", sce.getElements());
    }

    public void onException(Exception e) {
        Throwable root = ExceptionUtils.getRootCause((Throwable)e);
        String message = root.getMessage();
        if (root instanceof SyncopeClientException) {
            SyncopeClientException sce = (SyncopeClientException)root;
            message = sce.isComposite() ? sce.asComposite().getExceptions().stream().map(this::message).collect(Collectors.joining("; ")) : this.message(sce);
        } else if (root instanceof NotAuthorizedException || root instanceof ForbiddenException) {
            Error error = Strings.CI.contains((CharSequence)message, (CharSequence)"expired") ? Error.SESSION_EXPIRED : Error.AUTHORIZATION;
            message = this.getApplication().getResourceSettings().getLocalizer().getString(error.key(), null, null, null, null, error.fallback());
        } else if (root instanceof BadRequestException || root instanceof WebServiceException) {
            message = this.getApplication().getResourceSettings().getLocalizer().getString(Error.REST.key(), null, null, null, null, Error.REST.fallback());
        }
        message = this.getApplication().getResourceSettings().getLocalizer().getString(message, null, null, null, null, message);
        this.error((Serializable)((Object)message.replace("\n", "<br/>")));
    }

    public MediaType getMediaType() {
        return this.clientFactory.getContentType().getMediaType();
    }

    public void execute(Runnable command) {
        try {
            this.executor.execute(command);
        }
        catch (TaskRejectedException e) {
            LOG.error("Could not execute {}", (Object)command, (Object)e);
        }
    }

    public <T> Future<T> execute(Callable<T> command) {
        try {
            return this.executor.submit(command);
        }
        catch (TaskRejectedException e) {
            LOG.error("Could not execute {}", command, (Object)e);
            return new CompletableFuture();
        }
    }

    public Pair<String, String> gitAndBuildInfo() {
        return this.gitAndBuildInfo;
    }

    public PlatformInfo getPlatformInfo() {
        return this.platformInfo;
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return StringUtils.isBlank((CharSequence)this.domain) ? "Master" : this.domain;
    }

    public String getJWT() {
        return Optional.ofNullable(this.client).flatMap(SyncopeClient::jwtInfo).map(SyncopeClient.JwtInfo::value).orElse(null);
    }

    public boolean isJWTExpiring() {
        return Optional.ofNullable(this.jwtExpiration).map(je -> je.isBefore(Instant.now().plus((long)SyncopeWebApplication.get().getJwtExpirationMinutesThreshold(), ChronoUnit.MINUTES))).orElse(false);
    }

    public boolean authenticate(String username, String password) {
        boolean authenticated = false;
        try {
            this.client = this.clientFactory.setDomain(this.getDomain()).create(username, password);
            this.jwtExpiration = this.client.jwtInfo().map(jwtInfo -> jwtInfo.expiration().toInstant()).orElse(null);
            this.reloadSettings(username);
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        return authenticated;
    }

    public boolean authenticate(String jwt, Instant jwtExpiration) {
        boolean authenticated = false;
        try {
            this.client = this.clientFactory.setDomain(this.getDomain()).create(jwt);
            this.jwtExpiration = jwtExpiration;
            this.reloadSettings(null);
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        if (authenticated) {
            this.bind();
        }
        this.signIn(authenticated);
        return authenticated;
    }

    public boolean refresh() {
        boolean refreshed = false;
        try {
            this.client.refresh();
            this.jwtExpiration = this.client.jwtInfo().map(jwtInfo -> jwtInfo.expiration().toInstant()).orElse(null);
            this.reloadSettings(null);
            refreshed = true;
        }
        catch (Exception e) {
            LOG.error("Refresh failed", (Throwable)e);
        }
        if (refreshed) {
            this.changeSessionId();
            this.bind();
        }
        return refreshed;
    }

    public void cleanup() {
        this.anonymousClient = null;
        this.gitAndBuildInfo = null;
        this.platformInfo = null;
        this.systemInfo = null;
        this.client = null;
        this.jwtExpiration = null;
        this.self = null;
        this.delegatedBy = null;
        this.services.clear();
    }

    public void invalidate() {
        SyncopeWebApplication.get().storeLoggedOutSessionId(this.getId());
        if (this.getJWT() != null) {
            if (this.client != null) {
                this.client.logout();
            }
            this.cleanup();
        }
        super.invalidate();
    }

    public UserTO getSelfTO() {
        return this.self.user();
    }

    public List<String> getAuthRealms() {
        return this.self.entitlements().values().stream().flatMap(Collection::stream).distinct().sorted().toList();
    }

    public List<String> getSearchableRealms() {
        Set roots = (Set)this.self.entitlements().get("REALM_SEARCH");
        return CollectionUtils.isEmpty((Collection)roots) ? List.of() : roots.stream().sorted().toList();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Optional<String> getRootRealm(String initial) {
        Optional<String> optional;
        List<String> searchable = this.getSearchableRealms();
        if (searchable.isEmpty()) {
            optional = Optional.empty();
            return optional;
        }
        if (initial != null) {
            if (searchable.stream().anyMatch(initial::startsWith)) {
                optional = Optional.of(initial);
                return optional;
            }
        }
        optional = searchable.stream().findFirst();
        return optional;
    }

    public boolean owns(String entitlements, String ... realms) {
        if (StringUtils.isEmpty((CharSequence)entitlements)) {
            return true;
        }
        if (this.self.entitlements() == null) {
            return false;
        }
        Set<Object> requested = ArrayUtils.isEmpty((Object[])realms) ? Set.of() : Set.of(realms);
        for (String entitlement : entitlements.split(",")) {
            if (!this.self.entitlements().containsKey(entitlement)) continue;
            boolean owns = false;
            Set owned = ((Set)this.self.entitlements().get(entitlement)).stream().map(RealmsUtils::getFullPath).collect(Collectors.toSet());
            if (requested.isEmpty()) {
                return !owned.isEmpty();
            }
            for (String string : requested) {
                if (string.startsWith("/")) {
                    owns |= owned.stream().anyMatch(string::startsWith);
                    continue;
                }
                owns |= owned.contains(string);
            }
            return owns;
        }
        return false;
    }

    public Roles getRoles() {
        if (this.isSignedIn() && this.roles == null && this.self.entitlements() != null) {
            this.roles = new Roles((String[])this.self.entitlements().keySet().toArray(String[]::new));
            this.roles.add((Object)"AUTHENTICATED");
        }
        return this.roles;
    }

    public List<String> getDelegations() {
        return this.self.delegations();
    }

    public String getDelegatedBy() {
        return this.delegatedBy;
    }

    public void setDelegatedBy(String delegatedBy) {
        this.delegatedBy = delegatedBy;
        this.client.delegatedBy(delegatedBy);
        this.reloadSettings(null);
    }

    public void reloadSettings(String username) {
        try {
            this.anonymousClient = SyncopeWebApplication.get().newAnonymousClient(this.getDomain());
            this.gitAndBuildInfo = this.anonymousClient.gitAndBuildInfo();
            this.platformInfo = this.anonymousClient.platform();
            this.systemInfo = this.anonymousClient.system();
            this.self = this.client.self();
            this.roles = null;
        }
        catch (ForbiddenException e) {
            LOG.warn("Could not read self(), probably in a {} scenario", (Object)"MUST_CHANGE_PASSWORD", (Object)e);
            UserTO user = new UserTO();
            user.setUsername(username);
            user.setMustChangePassword(true);
            this.self = new SyncopeClient.Self(user, Map.of(), List.of());
        }
    }

    public SyncopeAnonymousClient getAnonymousClient() {
        if (this.anonymousClient == null) {
            this.anonymousClient = SyncopeWebApplication.get().newAnonymousClient(this.getDomain());
        }
        return this.anonymousClient;
    }

    public <T> T getAnonymousService(Class<T> serviceClass) {
        return (T)this.getAnonymousClient().getService(serviceClass);
    }

    protected <T> T getCachedService(Class<T> serviceClass) {
        Object service;
        if (this.services.containsKey(serviceClass)) {
            service = this.services.get(serviceClass);
        } else {
            service = this.client.getService(serviceClass);
            this.services.put(serviceClass, service);
        }
        WebClient.client((Object)service).type("application/json").accept(new String[]{"application/json"});
        return (T)service;
    }

    public <T> T getService(Class<T> serviceClass) {
        return this.getCachedService(serviceClass);
    }

    public <T> T getService(String etag, Class<T> serviceClass) {
        T serviceInstance = this.getCachedService(serviceClass);
        WebClient.client(serviceInstance).match(new EntityTag(etag), false);
        return serviceInstance;
    }

    public BatchRequest batch() {
        return this.client.batch();
    }

    public <T> void resetClient(Class<T> service) {
        T serviceInstance = this.getCachedService(service);
        WebClient.client(serviceInstance).reset();
    }

    public DateOps.Format getDateFormat() {
        return new DateOps.Format(FastDateFormat.getDateTimeInstance((int)3, (int)3, (Locale)this.getLocale()));
    }

    public static enum Error {
        SESSION_EXPIRED("error.session.expired", "Session expired: please login again"),
        AUTHORIZATION("error.authorization", "Insufficient access rights when performing the requested operation"),
        REST("error.rest", "There was an error while contacting the Core server");

        private final String key;
        private final String fallback;

        private Error(String key, String fallback) {
            this.key = key;
            this.fallback = fallback;
        }

        public String key() {
            return this.key;
        }

        public String fallback() {
            return this.fallback;
        }
    }
}

