/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn;

import com.yubico.core.RegistrationStorage;
import com.yubico.core.SessionManager;
import com.yubico.webauthn.data.ByteArray;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.webauthn.WebAuthnCredential;
import org.springframework.beans.factory.ObjectProvider;

@Monitorable
public class WebAuthnAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler
implements MultifactorAuthenticationHandler {
    private final RegistrationStorage webAuthnCredentialRepository;
    private final SessionManager sessionManager;
    private final ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider;

    public WebAuthnAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, RegistrationStorage webAuthnCredentialRepository, SessionManager sessionManager, Integer order, ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider) {
        super(name, servicesManager, principalFactory, order);
        this.webAuthnCredentialRepository = webAuthnCredentialRepository;
        this.sessionManager = sessionManager;
        this.multifactorAuthenticationProvider = multifactorAuthenticationProvider;
    }

    public boolean supports(Credential credential) {
        return WebAuthnCredential.class.isAssignableFrom(credential.getClass());
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return WebAuthnCredential.class.isAssignableFrom(clazz);
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws Throwable {
        WebAuthnCredential webAuthnCredential = (WebAuthnCredential)credential;
        Authentication authentication = Objects.requireNonNull(WebUtils.getInProgressAuthentication(), "CAS has no reference to an authentication event to locate a principal");
        Principal principal = authentication.getPrincipal();
        String uid = principal.getId();
        Set credentials = this.webAuthnCredentialRepository.getCredentialIdsForUsername(principal.getId());
        if (credentials.isEmpty()) {
            throw new AccountNotFoundException("Unable to locate registration record for " + uid);
        }
        ByteArray token = WebAuthnCredential.from((WebAuthnCredential)webAuthnCredential);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext();
        if (this.sessionManager.getSession(request, token).isEmpty()) {
            throw new FailedLoginException("Unable to validate session token " + String.valueOf(webAuthnCredential));
        }
        return this.createHandlerResult((Credential)webAuthnCredential, this.principalFactory.createPrincipal(uid));
    }

    @Generated
    public RegistrationStorage getWebAuthnCredentialRepository() {
        return this.webAuthnCredentialRepository;
    }

    @Generated
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Generated
    public ObjectProvider<MultifactorAuthenticationProvider> getMultifactorAuthenticationProvider() {
        return this.multifactorAuthenticationProvider;
    }
}

