/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;

public final class FunctionMessageHandler
extends AbstractMessageHandler {
    @Nonnull
    private Function<MessageContext, Function<MessageContext, Exception>> lookupStrategy = FunctionSupport.constant(null);

    public void setFunction(@Nullable Function<MessageContext, Exception> function) {
        this.checkSetterPreconditions();
        this.lookupStrategy = FunctionSupport.constant(function);
    }

    public void setFunctionLookupStrategy(@Nonnull Function<MessageContext, Function<MessageContext, Exception>> strategy) {
        this.checkSetterPreconditions();
        this.lookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Function lookup strategy cannot be null");
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        Function<MessageContext, Exception> f = this.lookupStrategy.apply(messageContext);
        if (f != null) {
            try {
                Exception e = f.apply(messageContext);
                if (e != null) {
                    throw e;
                }
            }
            catch (Exception e) {
                if (e instanceof MessageHandlerException) {
                    throw (MessageHandlerException)e;
                }
                throw new MessageHandlerException(e);
            }
        }
    }
}

