/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Map;
import java.util.function.Function;
import org.springframework.integration.aggregator.AbstractAggregatingMessageGroupProcessor;
import org.springframework.integration.aggregator.AggregatingMessageHandler;
import org.springframework.integration.aggregator.DefaultAggregatingMessageGroupProcessor;
import org.springframework.integration.aggregator.DelegatingMessageGroupProcessor;
import org.springframework.integration.aggregator.ExpressionEvaluatingMessageGroupProcessor;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.aggregator.MethodInvokingMessageGroupProcessor;
import org.springframework.integration.dsl.CorrelationHandlerSpec;
import org.springframework.integration.store.MessageGroup;
import org.springframework.lang.Nullable;

public class AggregatorSpec
extends CorrelationHandlerSpec<AggregatorSpec, AggregatingMessageHandler> {
    private Function<MessageGroup, Map<String, Object>> headersFunction;

    protected AggregatorSpec() {
        super(new AggregatingMessageHandler(new DefaultAggregatingMessageGroupProcessor()));
    }

    @Override
    public AggregatorSpec processor(Object target) {
        return this.processor(target, null);
    }

    public AggregatorSpec processor(Object target, @Nullable String methodName) {
        MessageGroupProcessor messageGroupProcessor;
        AggregatorSpec aggregatorSpec = (AggregatorSpec)super.processor(target);
        if (methodName != null) {
            messageGroupProcessor = new MethodInvokingMessageGroupProcessor(target, methodName);
        } else if (target instanceof MessageGroupProcessor) {
            MessageGroupProcessor messageGroupProcessor2 = (MessageGroupProcessor)target;
            messageGroupProcessor = messageGroupProcessor2;
        } else {
            messageGroupProcessor = new MethodInvokingMessageGroupProcessor(target);
        }
        return aggregatorSpec.outputProcessor(messageGroupProcessor);
    }

    public AggregatorSpec outputExpression(String expression) {
        return this.outputProcessor(new ExpressionEvaluatingMessageGroupProcessor(expression));
    }

    public AggregatorSpec outputProcessor(MessageGroupProcessor outputProcessor) {
        ((AggregatingMessageHandler)this.handler).setOutputProcessor(outputProcessor);
        return (AggregatorSpec)this._this();
    }

    public AggregatorSpec expireGroupsUponCompletion(boolean expireGroupsUponCompletion) {
        ((AggregatingMessageHandler)this.handler).setExpireGroupsUponCompletion(expireGroupsUponCompletion);
        return (AggregatorSpec)this._this();
    }

    public AggregatorSpec headersFunction(Function<MessageGroup, Map<String, Object>> headersFunction) {
        this.headersFunction = headersFunction;
        return (AggregatorSpec)this._this();
    }

    @Override
    public Map<Object, String> getComponentsToRegister() {
        if (this.headersFunction != null) {
            MessageGroupProcessor outputProcessor = ((AggregatingMessageHandler)this.handler).getOutputProcessor();
            if (outputProcessor instanceof AbstractAggregatingMessageGroupProcessor) {
                AbstractAggregatingMessageGroupProcessor abstractAggregatingMessageGroupProcessor = (AbstractAggregatingMessageGroupProcessor)outputProcessor;
                abstractAggregatingMessageGroupProcessor.setHeadersFunction(this.headersFunction);
            } else {
                ((AggregatingMessageHandler)this.handler).setOutputProcessor(new DelegatingMessageGroupProcessor(outputProcessor, this.headersFunction));
            }
        }
        return super.getComponentsToRegister();
    }
}

