/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowAdapter;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DefaultAnyObjectProvisioningManager
implements AnyObjectProvisioningManager {
    protected final AnyObjectWorkflowAdapter awfAdapter;
    protected final PropagationManager propagationManager;
    protected final PropagationTaskExecutor taskExecutor;
    protected final AnyObjectDAO anyObjectDAO;

    public DefaultAnyObjectProvisioningManager(AnyObjectWorkflowAdapter awfAdapter, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor, AnyObjectDAO anyObjectDAO) {
        this.awfAdapter = awfAdapter;
        this.propagationManager = propagationManager;
        this.taskExecutor = taskExecutor;
        this.anyObjectDAO = anyObjectDAO;
    }

    public ProvisioningManager.ProvisioningResult<String> create(AnyObjectCR anyObjectCR, boolean nullPriorityAsync, String creator, String context) {
        return this.create(anyObjectCR, Set.of(), nullPriorityAsync, creator, context);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ProvisioningManager.ProvisioningResult<String> create(AnyObjectCR anyObjectCR, Set<String> excludedResources, boolean nullPriorityAsync, String creator, String context) {
        WorkflowResult created = this.awfAdapter.create(anyObjectCR, creator, context);
        List taskInfos = this.propagationManager.getCreateTasks(AnyTypeKind.ANY_OBJECT, (String)created.getResult(), null, created.getPropByRes(), excludedResources);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, creator);
        return new ProvisioningManager.ProvisioningResult((Object)((String)created.getResult()), propagationReporter.getStatuses());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ProvisioningManager.ProvisioningResult<AnyObjectUR> update(AnyObjectUR anyObjectUR, Set<String> excludedResources, boolean nullPriorityAsync, String updater, String context) {
        List beforeAttrs = this.propagationManager.prepareAttrs(AnyTypeKind.ANY_OBJECT, anyObjectUR.getKey(), null, List.of(), null, excludedResources);
        WorkflowResult updated = this.awfAdapter.update(anyObjectUR, updater, context);
        List taskInfos = this.propagationManager.setAttributeDeltas(this.propagationManager.getUpdateTasks((AnyUR)updated.getResult(), AnyTypeKind.ANY_OBJECT, ((AnyObjectUR)updated.getResult()).getKey(), List.of(), null, updated.getPropByRes(), null, excludedResources), beforeAttrs);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, updater);
        return new ProvisioningManager.ProvisioningResult((Object)((AnyObjectUR)updated.getResult()), propagationReporter.getStatuses());
    }

    public List<PropagationStatus> delete(String key, boolean nullPriorityAsync, String eraser, String context) {
        return this.delete(key, Set.of(), nullPriorityAsync, eraser, context);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<PropagationStatus> delete(String key, Set<String> excludedResources, boolean nullPriorityAsync, String eraser, String context) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.DELETE, this.anyObjectDAO.findAllResourceKeys(key));
        List taskInfos = this.propagationManager.getDeleteTasks(AnyTypeKind.ANY_OBJECT, key, propByRes, null, excludedResources);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, eraser);
        this.awfAdapter.delete(key, eraser, context);
        return propagationReporter.getStatuses();
    }

    public String unlink(AnyObjectUR anyObjectUR, String updater, String context) {
        return ((AnyObjectUR)this.awfAdapter.update(anyObjectUR, updater, context).getResult()).getKey();
    }

    public String link(AnyObjectUR anyObjectUR, String updater, String context) {
        return ((AnyObjectUR)this.awfAdapter.update(anyObjectUR, updater, context).getResult()).getKey();
    }

    public List<PropagationStatus> provision(String key, Collection<String> resources, boolean nullPriorityAsync, String executor) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.UPDATE, resources);
        List taskInfos = this.propagationManager.getUpdateTasks(null, AnyTypeKind.ANY_OBJECT, key, List.of(), null, propByRes, null, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, executor);
        return propagationReporter.getStatuses();
    }

    public List<PropagationStatus> deprovision(String key, Collection<String> resources, boolean nullPriorityAsync, String executor) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.DELETE, resources);
        List taskInfos = this.propagationManager.getDeleteTasks(AnyTypeKind.ANY_OBJECT, key, propByRes, null, this.anyObjectDAO.findAllResourceKeys(key).stream().filter(resource -> !resources.contains(resource)).toList());
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, executor);
        return propagationReporter.getStatuses();
    }
}

