/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.authn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPSamlRegisteredServiceCriterion;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.scripting.ScriptResourceCacheManager;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.opensaml.saml.metadata.criteria.entity.impl.EvaluableEntityRoleEntityDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.AuthenticatingAuthority;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.util.StringUtils;

public class SamlProfileAuthnContextClassRefBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<AuthnContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileAuthnContextClassRefBuilder.class);
    private static final long serialVersionUID = 5783371664834470257L;
    private final MetadataResolver samlIdPMetadataResolver;
    private final CasConfigurationProperties casProperties;
    private final ObjectProvider<ScriptResourceCacheManager> scriptResourceCacheManager;

    public SamlProfileAuthnContextClassRefBuilder(OpenSamlConfigBean configBean, MetadataResolver samlIdPMetadataResolver, CasConfigurationProperties casProperties, ObjectProvider<ScriptResourceCacheManager> scriptResourceCacheManager) {
        super(configBean);
        this.samlIdPMetadataResolver = samlIdPMetadataResolver;
        this.casProperties = casProperties;
        this.scriptResourceCacheManager = scriptResourceCacheManager;
    }

    @Override
    public AuthnContext build(SamlProfileBuilderContext context) throws Exception {
        String classRefValue = this.buildAuthnContextClassRefValue(context);
        AuthnContext authnContext = (AuthnContext)this.newSamlObject(AuthnContext.class);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)classRefValue)) {
            AuthnContextClassRef classRef = (AuthnContextClassRef)this.newSamlObject(AuthnContextClassRef.class);
            classRef.setURI(classRefValue);
            authnContext.setAuthnContextClassRef(classRef);
        }
        this.buildDefaultAuthenticatingAuthority(context, authnContext);
        return authnContext;
    }

    protected void buildDefaultAuthenticatingAuthority(SamlProfileBuilderContext context, AuthnContext authnContext) throws Exception {
        if (!context.getRegisteredService().isSkipGeneratingAuthenticatingAuthority()) {
            CriteriaSet entityIdCriteriaSet = new CriteriaSet(new Criterion[]{new EvaluableEntityRoleEntityDescriptorCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME), new SamlIdPSamlRegisteredServiceCriterion(context.getRegisteredService())});
            LOGGER.trace("Resolving entity id from SAML2 IdP metadata for signature signing configuration is [{}]", (Object)context.getRegisteredService().getName());
            String entityId = Objects.requireNonNull((EntityDescriptor)this.samlIdPMetadataResolver.resolveSingle((Object)entityIdCriteriaSet)).getEntityID();
            LOGGER.trace("Resolved entity id from SAML2 IdP metadata is [{}]", (Object)entityId);
            AuthenticatingAuthority authority = (AuthenticatingAuthority)this.newSamlObject(AuthenticatingAuthority.class);
            authority.setURI(entityId);
            authnContext.getAuthenticatingAuthorities().add(authority);
        }
    }

    private String buildAuthnContextClassRefValue(SamlProfileBuilderContext context) {
        RequestedAuthnContext requestedAuthnContext;
        String assignedContextClass = context.getRegisteredService().getRequiredAuthenticationContextClass();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)assignedContextClass)) {
            LOGGER.debug("Using [{}] as indicated by SAML registered service [{}]", (Object)assignedContextClass, (Object)context.getRegisteredService().getName());
            Optional scriptFactory = ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory();
            if (scriptFactory.isPresent() && ((ExecutableCompiledScriptFactory)scriptFactory.get()).isScript(assignedContextClass)) {
                String requiredClass = ((ExecutableCompiledScriptFactory)scriptFactory.get()).isExternalScript(assignedContextClass) ? SpringExpressionLanguageValueResolver.getInstance().resolve(assignedContextClass) : assignedContextClass;
                return this.buildScriptedAuthnContextClassRef(context, requiredClass);
            }
            return SpringExpressionLanguageValueResolver.getInstance().resolve(assignedContextClass);
        }
        String defClass = this.getDefaultAuthenticationContextClass();
        RequestAbstractType requestAbstractType = context.getSamlRequest();
        if (requestAbstractType instanceof AuthnRequest) {
            AuthnRequest authnRequest = (AuthnRequest)requestAbstractType;
            v0 = authnRequest.getRequestedAuthnContext();
        } else {
            v0 = requestedAuthnContext = null;
        }
        if (requestedAuthnContext == null) {
            LOGGER.debug("No specific authN context is requested. Returning [{}]", (Object)defClass);
            return this.buildDefaultAuthenticationContextClass(defClass, context);
        }
        List authnContextClassRefs = requestedAuthnContext.getAuthnContextClassRefs();
        if (authnContextClassRefs == null || authnContextClassRefs.isEmpty()) {
            LOGGER.debug("Requested authN context class ref is unspecified. Returning [{}]", (Object)defClass);
            return this.buildDefaultAuthenticationContextClass(defClass, context);
        }
        String contextInAssertion = this.getAuthenticationContextByAssertion(context, requestedAuthnContext, authnContextClassRefs);
        String finalCtx = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)contextInAssertion, (CharSequence)defClass);
        LOGGER.debug("Returning authentication context [{}]", (Object)finalCtx);
        return finalCtx;
    }

    protected String buildScriptedAuthnContextClassRef(SamlProfileBuilderContext context, String requiredClass) {
        LOGGER.debug("Executing groovy script [{}] to determine authentication context class for [{}]", (Object)requiredClass, (Object)context.getAdaptor().getEntityId());
        return this.scriptResourceCacheManager.stream().map(cacheMgr -> {
            ExecutableCompiledScript script = cacheMgr.resolveScriptableResource(requiredClass, new String[]{requiredClass, context.getAdaptor().getEntityId()});
            return (String)FunctionUtils.doIfNotNull((Object)script, () -> {
                Map args = CollectionUtils.wrap((String)"context", (Object)context, (String)"logger", (Object)LOGGER);
                script.setBinding(args);
                return (String)script.execute(args.values().toArray(), String.class, true);
            }, () -> requiredClass).get();
        }).findFirst().orElseThrow(() -> new RuntimeException("Unable to locate script cache manager or execute groovy script"));
    }

    protected String buildDefaultAuthenticationContextClass(String defClass, SamlProfileBuilderContext context) {
        Set contextValues = CollectionUtils.toCollection((Object)context.getAuthenticatedAssertion().orElseThrow().getAttributes().get(this.casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute()));
        Map definedContexts = CollectionUtils.convertDirectedListToMap((Collection)this.casProperties.getAuthn().getSamlIdp().getCore().getContext().getAuthenticationContextClassMappings());
        return definedContexts.entrySet().stream().filter(entry -> contextValues.contains(entry.getValue())).map(Map.Entry::getKey).findFirst().orElse(defClass);
    }

    protected String getDefaultAuthenticationContextClass() {
        return (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)this.casProperties.getAuthn().getSamlIdp().getCore().getContext().getDefaultAuthenticationContextClass(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
    }

    protected String getAuthenticationContextByAssertion(SamlProfileBuilderContext context, RequestedAuthnContext requestedAuthnContext, List<AuthnContextClassRef> authnContextClassRefs) {
        LOGGER.debug("AuthN context comparison to use [{}]", (Object)requestedAuthnContext.getComparison());
        authnContextClassRefs.forEach(ref -> LOGGER.debug("Requested AuthN Context [{}]", (Object)ref.getURI()));
        Map definedContexts = CollectionUtils.convertDirectedListToMap((Collection)this.casProperties.getAuthn().getSamlIdp().getCore().getContext().getAuthenticationContextClassMappings());
        LOGGER.debug("Defined authentication context mappings are [{}]", (Object)definedContexts);
        return authnContextClassRefs.stream().filter(ref -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ref.getURI())).filter(ref -> definedContexts.containsKey(ref.getURI())).map(ref -> Pair.of((Object)ref, (Object)((String)definedContexts.get(ref.getURI())))).findFirst().map(mappedMethod -> this.getMappedAuthenticationContextClass(context, (Pair<AuthnContextClassRef, String>)mappedMethod)).orElse("");
    }

    private String getMappedAuthenticationContextClass(SamlProfileBuilderContext context, Pair<AuthnContextClassRef, String> mappedMethod) {
        ArrayList requestedMappedValues = new ArrayList(StringUtils.commaDelimitedListToSet((String)((String)mappedMethod.getValue())));
        Map<String, Object> attributes = context.getAuthenticatedAssertion().orElseThrow().getAttributes();
        Set contextAttributes = StringUtils.commaDelimitedListToSet((String)this.casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute());
        for (String contextAttribute : contextAttributes) {
            LOGGER.debug("Checking for mapped authentication context method [{}] in attributes [{}] via [{}]", new Object[]{requestedMappedValues, attributes, contextAttribute});
            if (!attributes.containsKey(contextAttribute)) continue;
            Object authnContext = attributes.get(contextAttribute);
            String satisfiedContext = CollectionUtils.firstElement((Object)authnContext).map(Object::toString).orElse("");
            LOGGER.debug("Comparing satisfied authentication context [{}] against [{}]", (Object)satisfiedContext, mappedMethod.getValue());
            if (!requestedMappedValues.contains(satisfiedContext)) continue;
            return ((AuthnContextClassRef)mappedMethod.getLeft()).getURI();
        }
        return null;
    }
}

