/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.response.artifact;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSamlResponseBuilderConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.soap.SamlProfileSamlSoap11ResponseBuilder;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.impl.ArtifactResponseBuilder;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;

public class SamlProfileArtifactResponseBuilder
extends SamlProfileSamlSoap11ResponseBuilder {
    private static final long serialVersionUID = -5582616946993706815L;

    public SamlProfileArtifactResponseBuilder(SamlProfileSamlResponseBuilderConfigurationContext ctx) {
        super(ctx);
    }

    @Override
    protected Envelope buildResponse(Optional<Assertion> assertion, SamlProfileBuilderContext context) {
        SamlArtifactTicket ticket = (SamlArtifactTicket)context.getAuthenticatedAssertion().orElseThrow().getAttributes().get("artifact");
        ArtifactResponse artifactResponse = new ArtifactResponseBuilder().buildObject();
        artifactResponse.setIssueInstant(ZonedDateTime.now(ZoneOffset.UTC).toInstant());
        artifactResponse.setIssuer(this.newIssuer(ticket.getIssuer()));
        artifactResponse.setInResponseTo(ticket.getRelyingPartyId());
        artifactResponse.setID(ticket.getId());
        artifactResponse.setStatus(this.newStatus("urn:oasis:names:tc:SAML:2.0:status:Success", "Success"));
        SAMLObject samlResponse = (SAMLObject)SamlUtils.transformSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (String)ticket.getObject(), SAMLObject.class);
        artifactResponse.setMessage(samlResponse);
        Header header = (Header)SamlUtils.newSoapObject(Header.class);
        Body body = (Body)SamlUtils.newSoapObject(Body.class);
        body.getUnknownXMLObjects().add(artifactResponse);
        Envelope envelope = (Envelope)SamlUtils.newSoapObject(Envelope.class);
        envelope.setHeader(header);
        envelope.setBody(body);
        this.openSamlConfigBean.logObject((XMLObject)envelope);
        return envelope;
    }
}

