/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.reactive;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.authentication.ObservationReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authorization.ObservationReactiveAuthorizationManager;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.observation.SecurityObservationSettings;
import org.springframework.security.web.server.ObservationWebFilterChainDecorator;
import org.springframework.security.web.server.WebFilterChainProxy;
import org.springframework.web.server.ServerWebExchange;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
class ReactiveObservationConfiguration {
    private static final SecurityObservationSettings all = SecurityObservationSettings.withDefaults().shouldObserveRequests(true).shouldObserveAuthentications(true).shouldObserveAuthorizations(true).build();

    ReactiveObservationConfiguration() {
    }

    @Bean
    @Role(value=2)
    static ObjectPostProcessor<ReactiveAuthorizationManager<ServerWebExchange>> webAuthorizationManagerPostProcessor(final ObjectProvider<ObservationRegistry> registry, final ObjectProvider<SecurityObservationSettings> predicate) {
        return new ObjectPostProcessor<ReactiveAuthorizationManager<ServerWebExchange>>(){

            @Override
            public ReactiveAuthorizationManager postProcess(ReactiveAuthorizationManager object) {
                ObservationRegistry r = (ObservationRegistry)registry.getIfUnique(() -> ObservationRegistry.NOOP);
                boolean active = !r.isNoop() && ((SecurityObservationSettings)predicate.getIfUnique(() -> all)).shouldObserveAuthorizations();
                return active ? new ObservationReactiveAuthorizationManager(r, object) : object;
            }
        };
    }

    @Bean
    @Role(value=2)
    static ObjectPostProcessor<ReactiveAuthenticationManager> reactiveAuthenticationManagerPostProcessor(final ObjectProvider<ObservationRegistry> registry, final ObjectProvider<SecurityObservationSettings> predicate) {
        return new ObjectPostProcessor<ReactiveAuthenticationManager>(){

            @Override
            public ReactiveAuthenticationManager postProcess(ReactiveAuthenticationManager object) {
                ObservationRegistry r = (ObservationRegistry)registry.getIfUnique(() -> ObservationRegistry.NOOP);
                boolean active = !r.isNoop() && ((SecurityObservationSettings)predicate.getIfUnique(() -> all)).shouldObserveAuthentications();
                return active ? new ObservationReactiveAuthenticationManager(r, object) : object;
            }
        };
    }

    @Bean
    @Role(value=2)
    static ObjectPostProcessor<WebFilterChainProxy.WebFilterChainDecorator> filterChainDecoratorPostProcessor(final ObjectProvider<ObservationRegistry> registry, final ObjectProvider<SecurityObservationSettings> predicate) {
        return new ObjectPostProcessor<WebFilterChainProxy.WebFilterChainDecorator>(){

            @Override
            public WebFilterChainProxy.WebFilterChainDecorator postProcess(WebFilterChainProxy.WebFilterChainDecorator object) {
                ObservationRegistry r = (ObservationRegistry)registry.getIfUnique(() -> ObservationRegistry.NOOP);
                boolean active = !r.isNoop() && ((SecurityObservationSettings)predicate.getIfUnique(() -> all)).shouldObserveRequests();
                return active ? new ObservationWebFilterChainDecorator(r) : object;
            }
        };
    }
}

