/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.spring;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.apache.syncope.core.persistence.jpa.spring.OpenJpaDialect;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.Database;

public class OpenJpaVendorAdapter
extends AbstractJpaVendorAdapter {
    private final PersistenceProvider persistenceProvider = new PersistenceProviderImpl();
    private final OpenJpaDialect jpaDialect = new OpenJpaDialect();

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public String getPersistenceProviderRootPackage() {
        return "org.apache.openjpa";
    }

    public Map<String, Object> getJpaPropertyMap() {
        String databaseDictonary;
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>();
        if (this.getDatabasePlatform() != null) {
            jpaProperties.put("openjpa.jdbc.DBDictionary", this.getDatabasePlatform());
        } else if (this.getDatabase() != null && (databaseDictonary = OpenJpaVendorAdapter.determineDatabaseDictionary(this.getDatabase())) != null) {
            jpaProperties.put("openjpa.jdbc.DBDictionary", databaseDictonary);
        }
        if (this.isGenerateDdl()) {
            jpaProperties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        }
        if (this.isShowSql()) {
            jpaProperties.put("openjpa.Log", "DefaultLevel=WARN, Runtime=INFO, Tool=INFO, SQL=TRACE");
        }
        return jpaProperties;
    }

    protected static String determineDatabaseDictionary(Database database) {
        return switch (database) {
            case Database.DB2 -> "db2";
            case Database.DERBY -> "derby";
            case Database.HSQL -> "hsql(SimulateLocking=true)";
            case Database.INFORMIX -> "informix";
            case Database.MYSQL -> "mysql";
            case Database.ORACLE -> "oracle";
            case Database.POSTGRESQL -> "postgres";
            case Database.SQL_SERVER -> "sqlserver";
            case Database.SYBASE -> "sybase";
            default -> null;
        };
    }

    public OpenJpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    public Class<? extends EntityManagerFactory> getEntityManagerFactoryInterface() {
        return OpenJPAEntityManagerFactorySPI.class;
    }

    public Class<? extends EntityManager> getEntityManagerInterface() {
        return OpenJPAEntityManagerSPI.class;
    }
}

