/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.cmd.JobType;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;

public class GetJobExceptionStacktraceCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected JobServiceConfiguration jobServiceConfiguration;
    protected String jobId;
    protected JobType jobType;

    public GetJobExceptionStacktraceCmd(String jobId, JobType jobType, JobServiceConfiguration jobServiceConfiguration) {
        this.jobId = jobId;
        this.jobType = jobType;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public String execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId is null");
        }
        AbstractRuntimeJobEntity job = null;
        switch (this.jobType) {
            case ASYNC: {
                job = (AbstractRuntimeJobEntity)this.jobServiceConfiguration.getJobEntityManager().findById(this.jobId);
                break;
            }
            case TIMER: {
                job = (AbstractRuntimeJobEntity)this.jobServiceConfiguration.getTimerJobEntityManager().findById(this.jobId);
                break;
            }
            case SUSPENDED: {
                job = (AbstractRuntimeJobEntity)this.jobServiceConfiguration.getSuspendedJobEntityManager().findById(this.jobId);
                break;
            }
            case DEADLETTER: {
                job = (AbstractRuntimeJobEntity)this.jobServiceConfiguration.getDeadLetterJobEntityManager().findById(this.jobId);
                break;
            }
            case EXTERNAL_WORKER: {
                job = (AbstractRuntimeJobEntity)this.jobServiceConfiguration.getExternalWorkerJobEntityManager().findById(this.jobId);
                break;
            }
        }
        if (job == null) {
            throw new FlowableObjectNotFoundException("No job found with id " + this.jobId, Job.class);
        }
        return job.getExceptionStacktrace();
    }
}

