/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.util.Extensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.net.InetAddress;
import java.net.UnknownHostException;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class NameResolver {
    @NotNull
    private static final String JVM_PROPERTY_POSITIVE_ADDRESS_CACHE_TTL_SECONDS = "networkaddress.cache.ttl";
    @NotNull
    private static final String JVM_PROPERTY_NEGATIVE_ADDRESS_CACHE_TTL_SECONDS = "networkaddress.cache.negative.ttl";

    protected NameResolver() {
    }

    @NotNull
    public InetAddress getByName(@Nullable String host) throws UnknownHostException, SecurityException {
        return InetAddress.getByName(host);
    }

    @NotNull
    public InetAddress[] getAllByName(@Nullable String host) throws UnknownHostException, SecurityException {
        return InetAddress.getAllByName(host);
    }

    @NotNull
    public String getHostName(@NotNull InetAddress inetAddress) {
        return inetAddress.getHostName();
    }

    @NotNull
    public String getCanonicalHostName(@NotNull InetAddress inetAddress) {
        return inetAddress.getCanonicalHostName();
    }

    @NotNull
    public InetAddress getLocalHost() throws UnknownHostException, SecurityException {
        return InetAddress.getLocalHost();
    }

    @NotNull
    public InetAddress getLoopbackAddress() {
        return InetAddress.getLoopbackAddress();
    }

    public static void setJVMSuccessfulLookupCacheTTLSeconds(int seconds) {
        if (seconds < 0) {
            StaticUtils.setSystemProperty(JVM_PROPERTY_POSITIVE_ADDRESS_CACHE_TTL_SECONDS, "-1");
        } else {
            StaticUtils.setSystemProperty(JVM_PROPERTY_POSITIVE_ADDRESS_CACHE_TTL_SECONDS, String.valueOf(seconds));
        }
    }

    public static void setJVMUnsuccessfulLookupCacheTTLSeconds(int seconds) {
        if (seconds < 0) {
            StaticUtils.setSystemProperty(JVM_PROPERTY_NEGATIVE_ADDRESS_CACHE_TTL_SECONDS, "-1");
        } else {
            StaticUtils.setSystemProperty(JVM_PROPERTY_NEGATIVE_ADDRESS_CACHE_TTL_SECONDS, String.valueOf(seconds));
        }
    }

    @NotNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(@NotNull StringBuilder var1);
}

