/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.google.common.escape;

import com.signalfx.shaded.google.common.annotations.GwtCompatible;
import com.signalfx.shaded.google.common.annotations.VisibleForTesting;
import com.signalfx.shaded.google.common.base.Preconditions;
import com.signalfx.shaded.google.common.escape.ElementTypesAreNonnullByDefault;
import java.util.Collections;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class ArrayBasedEscaperMap {
    private final char[][] replacementArray;
    private static final char[][] EMPTY_REPLACEMENT_ARRAY = new char[0][0];

    public static ArrayBasedEscaperMap create(Map<Character, String> replacements) {
        return new ArrayBasedEscaperMap(ArrayBasedEscaperMap.createReplacementArray(replacements));
    }

    private ArrayBasedEscaperMap(char[][] replacementArray) {
        this.replacementArray = replacementArray;
    }

    char[][] getReplacementArray() {
        return this.replacementArray;
    }

    @VisibleForTesting
    static char[][] createReplacementArray(Map<Character, String> map) {
        Preconditions.checkNotNull(map);
        if (map.isEmpty()) {
            return EMPTY_REPLACEMENT_ARRAY;
        }
        char max = Collections.max(map.keySet()).charValue();
        char[][] replacements = new char[max + '\u0001'][];
        for (Character c : map.keySet()) {
            replacements[c.charValue()] = map.get(c).toCharArray();
        }
        return replacements;
    }
}

