/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.crud;

import java.util.TreeSet;
import javax.naming.NamingException;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.modify.LdapDelete;
import net.tirasa.connid.bundles.ldap.search.LdapSearches;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

public class ADDelete
extends LdapDelete {
    public ADDelete(ADConnection conn, ObjectClass oclass, Uid uid) {
        super((LdapConnection)conn, oclass, uid);
    }

    public void execute() {
        String entryDN = "objectGUID".equals(this.conn.getSchema().getLdapUidAttribute(this.oclass)) ? String.format("<GUID=%s>", this.uid.getUidValue()) : LdapSearches.getEntryDN((LdapConnection)this.conn, (ObjectClass)this.oclass, (Uid)this.uid);
        TreeSet ldapGroups = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        ldapGroups.addAll(this.groupHelper.getLdapGroups(entryDN));
        this.groupHelper.removeLdapGroupMemberships(entryDN, ldapGroups);
        try {
            this.conn.getInitialContext().destroySubcontext(entryDN);
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }
}

