/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.smallrye.metrics.elementdesc.MemberInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.metrics.MetricID;

public class MemberToMetricMappings {
    private static final String CLASS_NAME = MemberToMetricMappings.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private final Map<MemberInfo, Set<MetricID>> counters = new HashMap<MemberInfo, Set<MetricID>>();
    private final Map<MemberInfo, Set<MetricID>> timers = new HashMap<MemberInfo, Set<MetricID>>();

    public Set<MetricID> getCounters(MemberInfo member) {
        return this.counters.get(member);
    }

    public Set<MetricID> getTimers(MemberInfo member) {
        return this.timers.get(member);
    }

    public void addTimer(MemberInfo member, MetricID metricID) {
        this.timers.computeIfAbsent(member, id -> new HashSet()).add(metricID);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "addTimer", "Matching member {0} to metric ID={1} and type={2}", new Object[]{member, metricID, "Timer"});
        }
    }

    public void addCounter(MemberInfo member, MetricID metricID) {
        this.counters.computeIfAbsent(member, id -> new HashSet()).add(metricID);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "addCounter", "Matching member {0} to metric ID={1} and type={2}", new Object[]{member, metricID, "Counter"});
        }
    }
}

