/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import jakarta.validation.ValidationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.metadata.MetadataBuilder;
import org.apache.bval.jsr.metadata.Signature;
import org.apache.bval.jsr.util.Methods;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;

public class MetadataBuilders {
    private final Map<Class<?>, List<MetadataBuilder.ForBean<?>>> beanBuilders = new ConcurrentHashMap();

    public <T> void registerCustomBuilder(Class<T> bean, MetadataBuilder.ForBean<T> builder) {
        Validate.notNull(bean, "bean", new Object[0]);
        Validate.notNull(builder, "builder", new Object[0]);
        this.validateCustomBuilder(bean, builder);
        this.beanBuilders.computeIfAbsent(bean, c -> new ArrayList()).add(builder);
    }

    public <T> List<MetadataBuilder.ForBean<T>> getCustomBuilders(Class<T> bean) {
        List<MetadataBuilder.ForBean<?>> list = this.beanBuilders.get(bean);
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public Set<Class<?>> getCustomizedTypes() {
        return this.beanBuilders.keySet();
    }

    private <T> void validateCustomBuilder(Class<T> bean, MetadataBuilder.ForBean<T> builder) {
        Meta.ForClass<T> meta = new Meta.ForClass<T>(bean);
        Set<String> propertyNames = builder.getGetters(meta).keySet();
        builder.getMethods(meta).keySet().stream().map(Signature::getName).filter(Methods::isGetter).map(Methods::propertyName).forEach(pn -> Exceptions.raiseIf(propertyNames.contains(pn), ValidationException::new, "%s user metadata cannot specify both method and getter elements for %s", f -> f.args(bean, pn)));
    }
}

