/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.status;

import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.services.JobStatusManagerService;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.status.JobStatus;
import org.apache.batchee.container.status.StepStatus;
import org.apache.batchee.spi.PersistenceManagerService;

public class DefaultJobStatusManager
implements JobStatusManagerService {
    private PersistenceManagerService persistenceManager;

    public DefaultJobStatusManager(ServicesManager servicesManager) {
        this.persistenceManager = servicesManager.service(PersistenceManagerService.class);
    }

    @Override
    public JobStatus createJobStatus(long jobInstanceId) throws BatchContainerServiceException {
        return this.persistenceManager.createJobStatus(jobInstanceId);
    }

    @Override
    public JobStatus getJobStatus(long jobInstanceId) throws BatchContainerServiceException {
        return this.persistenceManager.getJobStatus(jobInstanceId);
    }

    @Override
    public void updateJobStatus(JobStatus jobStatus) {
        this.persistJobStatus(jobStatus.getJobInstanceId(), jobStatus);
    }

    @Override
    public JobStatus getJobStatusFromExecutionId(long executionId) throws BatchContainerServiceException {
        return this.persistenceManager.getJobStatusFromExecution(executionId);
    }

    @Override
    public void updateJobBatchStatus(long jobInstanceId, BatchStatus batchStatus) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setBatchStatus(batchStatus);
        this.persistJobStatus(jobInstanceId, js);
    }

    @Override
    public void updateJobExecutionStatus(long jobInstanceId, BatchStatus batchStatus, String exitStatus) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setBatchStatus(batchStatus);
        js.setExitStatus(exitStatus);
        this.persistJobStatus(jobInstanceId, js);
    }

    @Override
    public void updateJobCurrentStep(long jobInstanceId, String currentStepName) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setCurrentStepId(currentStepName);
        this.persistJobStatus(jobInstanceId, js);
    }

    @Override
    public void updateJobStatusWithNewExecution(long jobInstanceId, long newExecutionId) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setRestartOn(null);
        js.setLatestExecutionId(newExecutionId);
        js.setBatchStatus(BatchStatus.STARTING);
        this.persistJobStatus(jobInstanceId, js);
    }

    private void persistJobStatus(long jobInstanceId, JobStatus newJobStatus) throws BatchContainerServiceException {
        this.persistenceManager.updateJobStatus(jobInstanceId, newJobStatus);
    }

    @Override
    public StepStatus createStepStatus(long stepExecutionId) throws BatchContainerServiceException {
        return this.persistenceManager.createStepStatus(stepExecutionId);
    }

    @Override
    public StepStatus getStepStatus(long jobInstanceId, String stepId) throws BatchContainerServiceException {
        return this.persistenceManager.getStepStatus(jobInstanceId, stepId);
    }

    @Override
    public void updateStepStatus(long stepExecutionId, StepStatus newStepStatus) {
        this.persistenceManager.updateStepStatus(stepExecutionId, newStepStatus);
    }

    @Override
    public void init(Properties batchConfig) throws BatchContainerServiceException {
    }

    @Override
    public void updateJobStatusFromJSLStop(long jobInstanceId, String restartOn) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setRestartOn(restartOn);
        this.persistJobStatus(jobInstanceId, js);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

