/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.superbiz.rest;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;


@Path("/weather")
@Produces(MediaType.TEXT_PLAIN)
@RequestScoped
public class WeatherService {

    @Inject
    private WeatherGateway weatherService;

    @GET
    @Path("/day/status")
    public String dayStatus() {
        return weatherService.statusOfDay();
    }

    @GET
    @Path("/week/status")
    public Response weekStatus() {
        try {
            return Response.ok().entity(weatherService.statusOfWeek()).build();
        } catch (WeatherGatewayBusyServiceException e) {
            return Response.serverError().entity("WeatherGateway Service is Busy. Retry later").build();
        }
    }

    @GET
    @Path("/weekend/status")
    public Response weekendStatus() {
        return Response.ok().entity(weatherService.statusOfWeekend()).build();
    }

    @GET
    @Path("/month/status")
    public Response monthStatus() {
        return Response.ok().entity(weatherService.statusOfMonth()).build();
    }

    @GET
    @Path("/year/status")
    public Response yearStatus() {
        try {
            return Response.ok().entity(weatherService.statusOfYear()).build();
        } catch (RuntimeException e) {
            return Response.serverError().entity("WeatherGateway Service Timeout").build();
        }
    }
}
