/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.validator;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import org.apache.myfaces.core.api.shared.MessageUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class RequiredValidator
implements Validator {
    public static final String VALIDATOR_ID = "jakarta.faces.Required";

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) {
        boolean empty;
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(uiComponent, "uiComponent");
        boolean bl = empty = value == null || value instanceof String && ((String)value).length() == 0;
        if (empty) {
            UIInput uiInput;
            if (uiComponent instanceof UIInput && (uiInput = (UIInput)uiComponent).getRequiredMessage() != null) {
                String requiredMessage = uiInput.getRequiredMessage();
                throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessage, requiredMessage));
            }
            throw new ValidatorException(MessageUtils.getMessage(facesContext, facesContext.getViewRoot().getLocale(), FacesMessage.SEVERITY_ERROR, "jakarta.faces.component.UIInput.REQUIRED", new Object[]{MessageUtils.getLabel(facesContext, uiComponent)}));
        }
    }

    private Boolean isDisabled() {
        return null;
    }

    private String getFor() {
        return null;
    }
}

