/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.rsa;

import io.churchkey.Key;
import io.churchkey.Spec;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class Rsa {

    public static class Private
    implements Spec<RSAPrivateCrtKey, RSAPublicKey> {
        private final BigInteger modulus;
        private final BigInteger publicExponent;
        private final BigInteger privateExponent;
        private final BigInteger primeP;
        private final BigInteger primeQ;
        private final BigInteger primeExponentP;
        private final BigInteger primeExponentQ;
        private final BigInteger crtCoefficient;

        @Override
        public RSAPrivateCrtKey toKey() {
            return (RSAPrivateCrtKey)Key.Algorithm.RSA.getKeyFactory().generatePrivate(new RSAPrivateCrtKeySpec(this.modulus, this.publicExponent, this.privateExponent, this.primeP, this.primeQ, this.primeExponentP, this.primeExponentQ, this.crtCoefficient));
        }

        @Override
        public Spec<RSAPublicKey, RSAPublicKey> toPublic() {
            return Public.builder().modulus(this.modulus).publicExponent(this.publicExponent).build();
        }

        Private(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient) {
            this.modulus = modulus;
            this.publicExponent = publicExponent;
            this.privateExponent = privateExponent;
            this.primeP = primeP;
            this.primeQ = primeQ;
            this.primeExponentP = primeExponentP;
            this.primeExponentQ = primeExponentQ;
            this.crtCoefficient = crtCoefficient;
        }

        public static Builder builder() {
            return new Builder();
        }

        public BigInteger getModulus() {
            return this.modulus;
        }

        public BigInteger getPublicExponent() {
            return this.publicExponent;
        }

        public BigInteger getPrivateExponent() {
            return this.privateExponent;
        }

        public BigInteger getPrimeP() {
            return this.primeP;
        }

        public BigInteger getPrimeQ() {
            return this.primeQ;
        }

        public BigInteger getPrimeExponentP() {
            return this.primeExponentP;
        }

        public BigInteger getPrimeExponentQ() {
            return this.primeExponentQ;
        }

        public BigInteger getCrtCoefficient() {
            return this.crtCoefficient;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Private)) {
                return false;
            }
            Private other = (Private)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$modulus = this.getModulus();
            BigInteger other$modulus = other.getModulus();
            if (this$modulus == null ? other$modulus != null : !((Object)this$modulus).equals(other$modulus)) {
                return false;
            }
            BigInteger this$publicExponent = this.getPublicExponent();
            BigInteger other$publicExponent = other.getPublicExponent();
            if (this$publicExponent == null ? other$publicExponent != null : !((Object)this$publicExponent).equals(other$publicExponent)) {
                return false;
            }
            BigInteger this$privateExponent = this.getPrivateExponent();
            BigInteger other$privateExponent = other.getPrivateExponent();
            if (this$privateExponent == null ? other$privateExponent != null : !((Object)this$privateExponent).equals(other$privateExponent)) {
                return false;
            }
            BigInteger this$primeP = this.getPrimeP();
            BigInteger other$primeP = other.getPrimeP();
            if (this$primeP == null ? other$primeP != null : !((Object)this$primeP).equals(other$primeP)) {
                return false;
            }
            BigInteger this$primeQ = this.getPrimeQ();
            BigInteger other$primeQ = other.getPrimeQ();
            if (this$primeQ == null ? other$primeQ != null : !((Object)this$primeQ).equals(other$primeQ)) {
                return false;
            }
            BigInteger this$primeExponentP = this.getPrimeExponentP();
            BigInteger other$primeExponentP = other.getPrimeExponentP();
            if (this$primeExponentP == null ? other$primeExponentP != null : !((Object)this$primeExponentP).equals(other$primeExponentP)) {
                return false;
            }
            BigInteger this$primeExponentQ = this.getPrimeExponentQ();
            BigInteger other$primeExponentQ = other.getPrimeExponentQ();
            if (this$primeExponentQ == null ? other$primeExponentQ != null : !((Object)this$primeExponentQ).equals(other$primeExponentQ)) {
                return false;
            }
            BigInteger this$crtCoefficient = this.getCrtCoefficient();
            BigInteger other$crtCoefficient = other.getCrtCoefficient();
            return !(this$crtCoefficient == null ? other$crtCoefficient != null : !((Object)this$crtCoefficient).equals(other$crtCoefficient));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Private;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $modulus = this.getModulus();
            result = result * 59 + ($modulus == null ? 43 : ((Object)$modulus).hashCode());
            BigInteger $publicExponent = this.getPublicExponent();
            result = result * 59 + ($publicExponent == null ? 43 : ((Object)$publicExponent).hashCode());
            BigInteger $privateExponent = this.getPrivateExponent();
            result = result * 59 + ($privateExponent == null ? 43 : ((Object)$privateExponent).hashCode());
            BigInteger $primeP = this.getPrimeP();
            result = result * 59 + ($primeP == null ? 43 : ((Object)$primeP).hashCode());
            BigInteger $primeQ = this.getPrimeQ();
            result = result * 59 + ($primeQ == null ? 43 : ((Object)$primeQ).hashCode());
            BigInteger $primeExponentP = this.getPrimeExponentP();
            result = result * 59 + ($primeExponentP == null ? 43 : ((Object)$primeExponentP).hashCode());
            BigInteger $primeExponentQ = this.getPrimeExponentQ();
            result = result * 59 + ($primeExponentQ == null ? 43 : ((Object)$primeExponentQ).hashCode());
            BigInteger $crtCoefficient = this.getCrtCoefficient();
            result = result * 59 + ($crtCoefficient == null ? 43 : ((Object)$crtCoefficient).hashCode());
            return result;
        }

        public String toString() {
            return "Rsa.Private(modulus=" + this.getModulus() + ", publicExponent=" + this.getPublicExponent() + ", privateExponent=" + this.getPrivateExponent() + ", primeP=" + this.getPrimeP() + ", primeQ=" + this.getPrimeQ() + ", primeExponentP=" + this.getPrimeExponentP() + ", primeExponentQ=" + this.getPrimeExponentQ() + ", crtCoefficient=" + this.getCrtCoefficient() + ")";
        }

        public static class Builder {
            private BigInteger modulus;
            private BigInteger publicExponent;
            private BigInteger privateExponent;
            private BigInteger primeP;
            private BigInteger primeQ;
            private BigInteger primeExponentP;
            private BigInteger primeExponentQ;
            private BigInteger crtCoefficient;

            Builder() {
            }

            public Builder modulus(BigInteger modulus) {
                this.modulus = modulus;
                return this;
            }

            public Builder publicExponent(BigInteger publicExponent) {
                this.publicExponent = publicExponent;
                return this;
            }

            public Builder privateExponent(BigInteger privateExponent) {
                this.privateExponent = privateExponent;
                return this;
            }

            public Builder primeP(BigInteger primeP) {
                this.primeP = primeP;
                return this;
            }

            public Builder primeQ(BigInteger primeQ) {
                this.primeQ = primeQ;
                return this;
            }

            public Builder primeExponentP(BigInteger primeExponentP) {
                this.primeExponentP = primeExponentP;
                return this;
            }

            public Builder primeExponentQ(BigInteger primeExponentQ) {
                this.primeExponentQ = primeExponentQ;
                return this;
            }

            public Builder crtCoefficient(BigInteger crtCoefficient) {
                this.crtCoefficient = crtCoefficient;
                return this;
            }

            public Private build() {
                return new Private(this.modulus, this.publicExponent, this.privateExponent, this.primeP, this.primeQ, this.primeExponentP, this.primeExponentQ, this.crtCoefficient);
            }

            public String toString() {
                return "Rsa.Private.Builder(modulus=" + this.modulus + ", publicExponent=" + this.publicExponent + ", privateExponent=" + this.privateExponent + ", primeP=" + this.primeP + ", primeQ=" + this.primeQ + ", primeExponentP=" + this.primeExponentP + ", primeExponentQ=" + this.primeExponentQ + ", crtCoefficient=" + this.crtCoefficient + ")";
            }
        }
    }

    public static class Public
    implements Spec<RSAPublicKey, RSAPublicKey> {
        private final BigInteger modulus;
        private final BigInteger publicExponent;

        @Override
        public RSAPublicKey toKey() {
            return (RSAPublicKey)Key.Algorithm.RSA.getKeyFactory().generatePublic(new RSAPublicKeySpec(this.modulus, this.publicExponent));
        }

        @Override
        public Spec<RSAPublicKey, RSAPublicKey> toPublic() {
            return this;
        }

        Public(BigInteger modulus, BigInteger publicExponent) {
            this.modulus = modulus;
            this.publicExponent = publicExponent;
        }

        public static Builder builder() {
            return new Builder();
        }

        public BigInteger getModulus() {
            return this.modulus;
        }

        public BigInteger getPublicExponent() {
            return this.publicExponent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Public)) {
                return false;
            }
            Public other = (Public)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$modulus = this.getModulus();
            BigInteger other$modulus = other.getModulus();
            if (this$modulus == null ? other$modulus != null : !((Object)this$modulus).equals(other$modulus)) {
                return false;
            }
            BigInteger this$publicExponent = this.getPublicExponent();
            BigInteger other$publicExponent = other.getPublicExponent();
            return !(this$publicExponent == null ? other$publicExponent != null : !((Object)this$publicExponent).equals(other$publicExponent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Public;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $modulus = this.getModulus();
            result = result * 59 + ($modulus == null ? 43 : ((Object)$modulus).hashCode());
            BigInteger $publicExponent = this.getPublicExponent();
            result = result * 59 + ($publicExponent == null ? 43 : ((Object)$publicExponent).hashCode());
            return result;
        }

        public String toString() {
            return "Rsa.Public(modulus=" + this.getModulus() + ", publicExponent=" + this.getPublicExponent() + ")";
        }

        public static class Builder {
            private BigInteger modulus;
            private BigInteger publicExponent;

            Builder() {
            }

            public Builder modulus(BigInteger modulus) {
                this.modulus = modulus;
                return this;
            }

            public Builder publicExponent(BigInteger publicExponent) {
                this.publicExponent = publicExponent;
                return this;
            }

            public Public build() {
                return new Public(this.modulus, this.publicExponent);
            }

            public String toString() {
                return "Rsa.Public.Builder(modulus=" + this.modulus + ", publicExponent=" + this.publicExponent + ")";
            }
        }
    }
}

