/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Advice;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;

public final class SAML2ActionSupport {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(SAML2ActionSupport.class);

    private SAML2ActionSupport() {
    }

    @Nonnull
    public static Assertion buildAssertion(@Nonnull AbstractProfileAction action, @Nonnull IdentifierGenerationStrategy idGenerator, @Nullable String issuer) {
        SAMLObjectBuilder assertionBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = (Assertion)assertionBuilder.buildObject();
        assertion.setID(idGenerator.generateIdentifier());
        assertion.setIssueInstant(Instant.now());
        assertion.setVersion(SAMLVersion.VERSION_20);
        if (issuer != null) {
            SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Issuer.DEFAULT_ELEMENT_NAME);
            Issuer issuerObject = (Issuer)issuerBuilder.buildObject();
            issuerObject.setValue(issuer);
            assertion.setIssuer(issuerObject);
        }
        LOG.debug("Profile Action {}: Created Assertion {}", (Object)action.getClass().getSimpleName(), (Object)assertion.getID());
        return assertion;
    }

    @Nonnull
    public static Assertion addAssertionToResponse(@Nonnull AbstractProfileAction action, @Nonnull Response response, @Nonnull IdentifierGenerationStrategy idGenerator, @Nullable String issuer) {
        Assertion assertion = SAML2ActionSupport.buildAssertion(action, idGenerator, issuer);
        assertion.setIssueInstant(response.getIssueInstant());
        LOG.debug("Profile Action {}: Added Assertion {} to Response {}", new Object[]{action.getClass().getSimpleName(), assertion.getID(), response.getID()});
        response.getAssertions().add(assertion);
        return assertion;
    }

    @Nonnull
    public static Conditions addConditionsToAssertion(@Nonnull AbstractProfileAction action, @Nonnull Assertion assertion) {
        Conditions conditions = assertion.getConditions();
        if (conditions == null) {
            SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Conditions.DEFAULT_ELEMENT_NAME);
            conditions = (Conditions)conditionsBuilder.buildObject();
            assertion.setConditions(conditions);
            LOG.debug("Profile Action {}: Assertion {} did not already contain Conditions, one was added", (Object)action.getClass().getSimpleName(), (Object)assertion.getID());
        } else {
            LOG.debug("Profile Action {}: Assertion {} already contained Conditions, nothing was done", (Object)action.getClass().getSimpleName(), (Object)assertion.getID());
        }
        return conditions;
    }

    @Nonnull
    public static Advice addAdviceToAssertion(@Nonnull AbstractProfileAction action, @Nonnull Assertion assertion) {
        Advice advice = assertion.getAdvice();
        if (advice == null) {
            SAMLObjectBuilder adviceBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Advice.DEFAULT_ELEMENT_NAME);
            advice = (Advice)adviceBuilder.buildObject();
            assertion.setAdvice(advice);
            LOG.debug("Profile Action {}: Assertion {} did not already contain Advice, one was added", (Object)action.getClass().getSimpleName(), (Object)assertion.getID());
        } else {
            LOG.debug("Profile Action {}: Assertion {} already contained Advice, nothing was done", (Object)action.getClass().getSimpleName(), (Object)assertion.getID());
        }
        return advice;
    }
}

