/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;

@XmlType(name="isolation-levelType")
@XmlEnum
public enum IsolationLevel {
    TRANSACTION_READ_UNCOMMITTED,
    TRANSACTION_READ_COMMITTED,
    TRANSACTION_REPEATABLE_READ,
    TRANSACTION_SERIALIZABLE;


    public String value() {
        return this.name();
    }

    public static IsolationLevel fromValue(String v) {
        return IsolationLevel.valueOf(v);
    }

    public static IsolationLevel fromFlag(int flag) {
        if (flag == 1) {
            return TRANSACTION_READ_UNCOMMITTED;
        }
        if (flag == 2) {
            return TRANSACTION_READ_COMMITTED;
        }
        if (flag == 4) {
            return TRANSACTION_REPEATABLE_READ;
        }
        if (flag == 8) {
            return TRANSACTION_SERIALIZABLE;
        }
        if (flag == 0 || flag == -1) {
            return null;
        }
        throw new IllegalArgumentException("Invalid isolation level flag: " + flag);
    }
}

