/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import org.apache.unomi.api.Parameter;
import org.apache.unomi.api.PluginType;
import org.apache.unomi.api.ValueType;
import org.apache.unomi.api.actions.ActionType;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.rest.models.RESTActionType;
import org.apache.unomi.rest.models.RESTConditionType;
import org.apache.unomi.rest.models.RESTParameter;
import org.apache.unomi.rest.models.RESTValueType;
import org.apache.unomi.rest.service.impl.ResourceBundleHelper;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LocalizationHelper.class})
public class LocalizationHelper {
    private BundleContext bundleContext;
    @Reference
    private ResourceBundleHelper resourceBundleHelper;

    @Activate
    public void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
    }

    public Collection<RESTConditionType> generateConditions(Collection<ConditionType> conditionTypes, String language) {
        ArrayList<RESTConditionType> result = new ArrayList<RESTConditionType>();
        if (conditionTypes == null) {
            return result;
        }
        for (ConditionType conditionType : conditionTypes) {
            result.add(this.generateCondition(conditionType, language));
        }
        return result;
    }

    public Collection<RESTActionType> generateActions(Collection<ActionType> actionTypes, String language) {
        ArrayList<RESTActionType> result = new ArrayList<RESTActionType>();
        if (actionTypes == null) {
            return result;
        }
        for (ActionType actionType : actionTypes) {
            result.add(this.generateAction(actionType, language));
        }
        return result;
    }

    public RESTConditionType generateCondition(ConditionType conditionType, String language) {
        RESTConditionType result = new RESTConditionType();
        result.setId(conditionType.getItemId());
        result.setVersion(conditionType.getVersion());
        result.setName(conditionType.getMetadata().getName());
        result.setDescription(conditionType.getMetadata().getDescription());
        result.setTags(conditionType.getMetadata().getTags());
        result.setSystemTags(conditionType.getMetadata().getSystemTags());
        for (Parameter parameter : conditionType.getParameters()) {
            result.getParameters().add(this.generateParameter(parameter, language));
        }
        return result;
    }

    public RESTActionType generateAction(ActionType actionType, String language) {
        RESTActionType result = new RESTActionType();
        result.setId(actionType.getItemId());
        result.setVersion(actionType.getVersion());
        result.setName(actionType.getMetadata().getName());
        result.setDescription(actionType.getMetadata().getDescription());
        result.setTags(actionType.getMetadata().getTags());
        result.setSystemTags(actionType.getMetadata().getSystemTags());
        ArrayList<RESTParameter> parameters = new ArrayList<RESTParameter>();
        for (Parameter parameter : actionType.getParameters()) {
            parameters.add(this.generateParameter(parameter, language));
        }
        result.setParameters(parameters);
        return result;
    }

    public RESTParameter generateParameter(Parameter parameter, String language) {
        RESTParameter result = new RESTParameter();
        result.setId(parameter.getId());
        result.setDefaultValue(parameter.getDefaultValue());
        result.setMultivalued(parameter.isMultivalued());
        result.setType(parameter.getType());
        return result;
    }

    public Collection<RESTValueType> generateValueTypes(Collection<ValueType> valueTypes, String language) {
        ArrayList<RESTValueType> result = new ArrayList<RESTValueType>();
        if (valueTypes == null) {
            return result;
        }
        for (ValueType valueType : valueTypes) {
            result.add(this.generateValueType(valueType, language));
        }
        return result;
    }

    public RESTValueType generateValueType(ValueType valueType, String language) {
        RESTValueType result = new RESTValueType();
        result.setId(valueType.getId());
        ResourceBundle bundle = this.resourceBundleHelper.getResourceBundle((PluginType)valueType, language);
        result.setName(this.resourceBundleHelper.getResourceBundleValue(bundle, valueType.getNameKey()));
        result.setDescription(this.resourceBundleHelper.getResourceBundleValue(bundle, valueType.getDescriptionKey()));
        result.setTags(valueType.getTags());
        return result;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setResourceBundleHelper(ResourceBundleHelper resourceBundleHelper) {
        this.resourceBundleHelper = resourceBundleHelper;
    }
}

