/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater.data;

import java.util.Iterator;
import org.apache.wicket.markup.repeater.AbstractPageableView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public abstract class DataViewBase<T>
extends AbstractPageableView<T> {
    private static final long serialVersionUID = 1L;
    private final IDataProvider<T> dataProvider;

    public DataViewBase(String id, IDataProvider<T> dataProvider) {
        super(id);
        this.dataProvider = (IDataProvider)Args.notNull(dataProvider, (String)"dataProvider");
    }

    protected final IDataProvider<T> internalGetDataProvider() {
        return this.dataProvider;
    }

    @Override
    protected final Iterator<IModel<T>> getItemModels(long offset, long count) {
        return new ModelIterator<T>(this.internalGetDataProvider(), offset, count);
    }

    @Override
    protected final long internalGetItemCount() {
        return this.internalGetDataProvider().size();
    }

    @Override
    protected void onDetach() {
        this.dataProvider.detach();
        super.onDetach();
    }

    private static final class ModelIterator<T>
    implements Iterator<IModel<T>> {
        private final Iterator<? extends T> items;
        private final IDataProvider<T> dataProvider;
        private final long max;
        private long index;

        public ModelIterator(IDataProvider<T> dataProvider, long offset, long count) {
            this.dataProvider = dataProvider;
            this.max = count;
            this.items = count > 0L ? dataProvider.iterator(offset, count) : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.items != null && this.items.hasNext() && this.index < this.max;
        }

        @Override
        public IModel<T> next() {
            ++this.index;
            return this.dataProvider.model(this.items.next());
        }
    }
}

